/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.data.builder;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import forestry.factory.features.FactoryRecipeTypes;
import forestry.factory.recipes.RecipeSerializers;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraftforge.fluids.FluidStack;

public class SqueezerRecipeBuilder {
    private int processingTime;
    private List<Ingredient> resources;
    private FluidStack fluidOutput;
    private ItemStack remnants = ItemStack.f_41583_;
    private float remnantsChance;

    public SqueezerRecipeBuilder setProcessingTime(int processingTime) {
        this.processingTime = processingTime;
        return this;
    }

    public SqueezerRecipeBuilder setResources(List<Ingredient> resources) {
        this.resources = resources;
        return this;
    }

    public SqueezerRecipeBuilder setFluidOutput(FluidStack fluidOutput) {
        this.fluidOutput = fluidOutput;
        return this;
    }

    public SqueezerRecipeBuilder setRemnants(ItemStack remnants) {
        this.remnants = remnants;
        return this;
    }

    public SqueezerRecipeBuilder setRemnantsChance(float remnantsChance) {
        this.remnantsChance = remnantsChance;
        return this;
    }

    public void build(Consumer<FinishedRecipe> consumer, ResourceLocation id) {
        consumer.accept(new Result(id, this.processingTime, this.resources, this.fluidOutput, this.remnants, this.remnantsChance));
    }

    private static class Result
    implements FinishedRecipe {
        private final ResourceLocation id;
        private final int processingTime;
        private final List<Ingredient> resources;
        private final FluidStack fluidOutput;
        private final ItemStack remnants;
        private final float remnantsChance;

        public Result(ResourceLocation id, int processingTime, List<Ingredient> resources, FluidStack fluidOutput, ItemStack remnants, float remnantsChance) {
            this.id = id;
            this.processingTime = processingTime;
            this.resources = resources;
            this.fluidOutput = fluidOutput;
            this.remnants = remnants;
            this.remnantsChance = remnantsChance;
        }

        public void m_7917_(JsonObject json) {
            json.addProperty("time", (Number)this.processingTime);
            JsonArray resources = new JsonArray();
            for (Ingredient resource : this.resources) {
                resources.add(resource.m_43942_());
            }
            json.add("resources", (JsonElement)resources);
            json.add("output", (JsonElement)RecipeSerializers.serializeFluid(this.fluidOutput));
            json.add("remnant", (JsonElement)RecipeSerializers.item(this.remnants));
            json.addProperty("chance", (Number)Float.valueOf(this.remnantsChance));
        }

        public ResourceLocation m_6445_() {
            return this.id;
        }

        public RecipeSerializer<?> m_6637_() {
            return FactoryRecipeTypes.SQUEEZER.serializer();
        }

        @Nullable
        public JsonObject m_5860_() {
            return null;
        }

        @Nullable
        public ResourceLocation m_6448_() {
            return null;
        }
    }
}

