/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.data.builder;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import forestry.factory.features.FactoryRecipeTypes;
import forestry.factory.recipes.RecipeSerializers;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;

public class MoistenerRecipeBuilder {
    private int timePerItem;
    private Ingredient resource;
    private ItemStack product;

    public MoistenerRecipeBuilder setTimePerItem(int timePerItem) {
        this.timePerItem = timePerItem;
        return this;
    }

    public MoistenerRecipeBuilder setResource(Ingredient resource) {
        this.resource = resource;
        return this;
    }

    public MoistenerRecipeBuilder setProduct(ItemStack product) {
        this.product = product;
        return this;
    }

    public void build(Consumer<FinishedRecipe> consumer, ResourceLocation id) {
        consumer.accept(new Result(id, this.timePerItem, this.resource, this.product));
    }

    private static class Result
    implements FinishedRecipe {
        private final ResourceLocation id;
        private final int timePerItem;
        private final Ingredient resource;
        private final ItemStack product;

        public Result(ResourceLocation id, int timePerItem, Ingredient resource, ItemStack product) {
            this.id = id;
            this.timePerItem = timePerItem;
            this.resource = resource;
            this.product = product;
        }

        public void m_7917_(JsonObject json) {
            json.addProperty("time", (Number)this.timePerItem);
            json.add("resource", this.resource.m_43942_());
            json.add("product", (JsonElement)RecipeSerializers.item(this.product));
        }

        public ResourceLocation m_6445_() {
            return this.id;
        }

        public RecipeSerializer<?> m_6637_() {
            return FactoryRecipeTypes.MOISTENER.serializer();
        }

        @Nullable
        public JsonObject m_5860_() {
            return null;
        }

        @Nullable
        public ResourceLocation m_6448_() {
            return null;
        }
    }
}

