/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.data.builder;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import forestry.factory.features.FactoryRecipeTypes;
import forestry.factory.recipes.RecipeSerializers;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.ImpossibleTrigger;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraftforge.fluids.FluidStack;
import org.apache.commons.lang3.mutable.MutableObject;

public class CarpenterRecipeBuilder {
    private int packagingTime = 5;
    @Nullable
    private FluidStack liquid;
    private Ingredient box;
    private FinishedRecipe recipe;
    @Nullable
    private ItemStack result;

    public CarpenterRecipeBuilder setPackagingTime(int packagingTime) {
        this.packagingTime = packagingTime;
        return this;
    }

    public CarpenterRecipeBuilder setLiquid(@Nullable FluidStack liquid) {
        this.liquid = liquid;
        return this;
    }

    public CarpenterRecipeBuilder setBox(Ingredient box) {
        this.box = box;
        return this;
    }

    public CarpenterRecipeBuilder recipe(ShapedRecipeBuilder recipe) {
        MutableObject holder = new MutableObject();
        recipe.m_126132_("impossible", (CriterionTriggerInstance)new ImpossibleTrigger.TriggerInstance()).m_176498_(arg_0 -> ((MutableObject)holder).setValue(arg_0));
        this.recipe = (FinishedRecipe)holder.getValue();
        return this;
    }

    public CarpenterRecipeBuilder recipe(ShapelessRecipeBuilder recipe) {
        MutableObject holder = new MutableObject();
        recipe.m_126132_("impossible", (CriterionTriggerInstance)new ImpossibleTrigger.TriggerInstance()).m_176498_(arg_0 -> ((MutableObject)holder).setValue(arg_0));
        this.recipe = (FinishedRecipe)holder.getValue();
        return this;
    }

    public CarpenterRecipeBuilder override(ItemStack result) {
        this.result = result;
        return this;
    }

    public void build(Consumer<FinishedRecipe> consumer, ResourceLocation id) {
        consumer.accept(new Result(id, this.packagingTime, this.liquid, this.box, this.recipe, this.result));
    }

    public static class Result
    implements FinishedRecipe {
        private final ResourceLocation id;
        private final int packagingTime;
        @Nullable
        private final FluidStack liquid;
        private final Ingredient box;
        private final FinishedRecipe recipe;
        @Nullable
        private final ItemStack result;

        public Result(ResourceLocation id, int packagingTime, @Nullable FluidStack liquid, Ingredient box, FinishedRecipe recipe, @Nullable ItemStack result) {
            this.id = id;
            this.packagingTime = packagingTime;
            this.liquid = liquid;
            this.box = box;
            this.recipe = recipe;
            this.result = result;
        }

        public void m_7917_(JsonObject json) {
            json.addProperty("time", (Number)this.packagingTime);
            if (this.liquid != null) {
                json.add("liquid", (JsonElement)RecipeSerializers.serializeFluid(this.liquid));
            }
            json.add("box", this.box.m_43942_());
            json.add("recipe", (JsonElement)this.recipe.m_125966_());
            if (this.result != null) {
                json.add("result", (JsonElement)RecipeSerializers.item(this.result));
            }
        }

        public ResourceLocation m_6445_() {
            return this.id;
        }

        public RecipeSerializer<?> m_6637_() {
            return FactoryRecipeTypes.CARPENTER.serializer();
        }

        public JsonObject m_5860_() {
            return null;
        }

        public ResourceLocation m_6448_() {
            return null;
        }
    }
}

