/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.data;

import forestry.api.IForestryApi;
import forestry.apiimpl.plugin.PluginManager;
import forestry.core.data.ForestryAdvancementProvider;
import forestry.core.data.ForestryAtlasProvider;
import forestry.core.data.ForestryBackpackTagProvider;
import forestry.core.data.ForestryBiomeTagsProvider;
import forestry.core.data.ForestryBlockTagsProvider;
import forestry.core.data.ForestryDamageTypesProvider;
import forestry.core.data.ForestryFeaturesProvider;
import forestry.core.data.ForestryFluidTagsProvider;
import forestry.core.data.ForestryItemModels;
import forestry.core.data.ForestryItemTagsProvider;
import forestry.core.data.ForestryLootModifierProvider;
import forestry.core.data.ForestryLootTableProvider;
import forestry.core.data.ForestryPaintingTagsProvider;
import forestry.core.data.ForestryPoiTypeTagProvider;
import forestry.core.data.ForestryRecipeProvider;
import forestry.core.data.models.ForestryBlockStateProvider;
import forestry.core.data.models.ForestryItemModelProvider;
import forestry.core.data.models.ForestryWoodModelProvider;
import forestry.modules.ForestryModuleManager;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.world.item.Item;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import thedarkcolour.modkit.data.DataHelper;
import thedarkcolour.modkit.data.MKTagsProvider;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class Data {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        Data.preDataGen();
        DataGenerator generator = event.getGenerator();
        PackOutput output = generator.getPackOutput();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        DataHelper dataHelper = new DataHelper("forestry", event);
        CompletableFuture lookup = event.getLookupProvider();
        dataHelper.createTags(Registries.f_256747_, ForestryBlockTagsProvider::addTags);
        dataHelper.createTags(Registries.f_256913_, (tags, l) -> {
            ForestryItemTagsProvider.addTags((MKTagsProvider<Item>)tags);
            ForestryBackpackTagProvider.addTags((MKTagsProvider<Item>)tags);
        });
        dataHelper.createTags(Registries.f_256952_, ForestryBiomeTagsProvider::addTags);
        dataHelper.createTags(Registries.f_256808_, ForestryFluidTagsProvider::addTags);
        dataHelper.createTags(Registries.f_256805_, ForestryPoiTypeTagProvider::addTags);
        dataHelper.createTags(Registries.f_256836_, ForestryPaintingTagsProvider::addTags);
        dataHelper.createRecipes(ForestryRecipeProvider::addRecipes);
        dataHelper.createDamageTypes(ForestryDamageTypesProvider::addTypes);
        dataHelper.createItemModels(false, false, false, ForestryItemModels::addModels);
        generator.addProvider(event.includeServer(), (DataProvider)new ForestryAdvancementProvider(output, lookup, existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new ForestryLootTableProvider(output));
        generator.addProvider(event.includeServer(), (DataProvider)new ForestryLootModifierProvider(output));
        generator.addProvider(event.includeClient(), (DataProvider)new ForestryBlockStateProvider(output, existingFileHelper));
        generator.addProvider(event.includeClient(), (DataProvider)new ForestryWoodModelProvider(output, existingFileHelper));
        generator.addProvider(event.includeClient(), (DataProvider)new ForestryItemModelProvider(output, existingFileHelper));
        generator.addProvider(event.includeClient(), (DataProvider)new ForestryAtlasProvider(output, existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new ForestryFeaturesProvider(output, lookup));
    }

    public static void preDataGen() {
        ((ForestryModuleManager)IForestryApi.INSTANCE.getModuleManager()).setupApi();
        PluginManager.registerClient();
    }
}

