/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.commands;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import forestry.Forestry;
import forestry.api.genetics.IBreedingTracker;
import forestry.api.genetics.ISpecies;
import forestry.core.commands.CommandHelpers;
import forestry.core.commands.IStatsSaveHelper;
import forestry.core.utils.StringUtil;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;

public final class CommandSaveStats
implements Command<CommandSourceStack> {
    private static final Component discoveredSymbol = Component.m_237115_((String)"for.chat.command.forestry.stats.save.key.discovered.symbol");
    private static final Component blacklistedSymbol = Component.m_237115_((String)"for.chat.command.forestry.stats.save.key.blacklisted.symbol");
    private static final Component notCountedSymbol = Component.m_237115_((String)"for.chat.command.forestry.stats.save.key.notCounted.symbol");
    private final IStatsSaveHelper saveHelper;

    public CommandSaveStats(IStatsSaveHelper saveHelper) {
        this.saveHelper = saveHelper;
    }

    public static ArgumentBuilder<CommandSourceStack, ?> register(IStatsSaveHelper saveHelper) {
        return Commands.m_82127_((String)"save").then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).executes((Command)new CommandSaveStats(saveHelper)));
    }

    public int run(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        ServerPlayer player = EntityArgument.m_91474_(ctx, (String)"player");
        ServerLevel world = ((CommandSourceStack)ctx.getSource()).m_81372_();
        ArrayList<Component> statistics = new ArrayList<Component>();
        String date = DateFormat.getInstance().format(new Date());
        MutableComponent emptyLiteral = Component.m_237113_((String)"");
        statistics.add((Component)Component.m_237110_((String)this.saveHelper.getTranslationKey(), (Object[])new Object[]{player.m_5446_(), date}));
        statistics.add((Component)emptyLiteral);
        statistics.add((Component)emptyLiteral);
        IBreedingTracker tracker = this.saveHelper.getBreedingTracker((Level)world, player.m_36316_());
        this.saveHelper.addExtraInfo(statistics, tracker);
        Collection<ISpecies<?>> species = this.saveHelper.getSpecies();
        String speciesCount = Component.m_237115_((String)"for.gui.speciescount").getString();
        String speciesCountLine = String.format("%s (%s):", speciesCount, species.size());
        statistics.add((Component)Component.m_237113_((String)speciesCountLine));
        statistics.add(StringUtil.line(speciesCountLine.length()));
        statistics.add((Component)Component.m_237113_((String)(discoveredSymbol + ": ")).m_7220_((Component)Component.m_237115_((String)"for.chat.command.forestry.stats.save.key.discovered")));
        statistics.add((Component)Component.m_237113_((String)(blacklistedSymbol + ": ")).m_7220_((Component)Component.m_237115_((String)"for.chat.command.forestry.stats.save.key.blacklisted")));
        statistics.add((Component)Component.m_237113_((String)(notCountedSymbol + ": ")).m_7220_((Component)Component.m_237115_((String)"for.chat.command.forestry.stats.save.key.notCounted")));
        statistics.add((Component)Component.m_237113_((String)""));
        String header = CommandSaveStats.generateSpeciesListHeader();
        statistics.add((Component)Component.m_237113_((String)header));
        statistics.add(StringUtil.line(header.length()));
        statistics.add((Component)Component.m_237113_((String)""));
        for (ISpecies<?> allele : species) {
            statistics.add((Component)Component.m_237113_((String)CommandSaveStats.generateSpeciesListEntry(allele, tracker)));
        }
        File file = new File("config/forestry/stats/" + player.m_5446_().getString() + "-" + this.saveHelper.getFileSuffix() + ".log");
        try {
            boolean success;
            File folder = file.getParentFile();
            if (folder != null && !folder.exists() && !(success = file.getParentFile().mkdirs())) {
                CommandHelpers.sendLocalizedChatMessage((CommandSourceStack)ctx.getSource(), "for.chat.command.forestry.stats.save.error1", new Object[0]);
                return 0;
            }
            if (!file.exists() && !file.createNewFile()) {
                CommandHelpers.sendLocalizedChatMessage((CommandSourceStack)ctx.getSource(), "for.chat.command.forestry.stats.save.error1", new Object[0]);
                return 0;
            }
            if (!file.canWrite()) {
                CommandHelpers.sendLocalizedChatMessage((CommandSourceStack)ctx.getSource(), "for.chat.command.forestry.stats.save.error2", new Object[0]);
                return 0;
            }
            String newLine = System.lineSeparator();
            FileOutputStream fileout = new FileOutputStream(file);
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)fileout, StandardCharsets.UTF_8));
            writer.write("# forestry" + newLine + "# " + ((ModContainer)ModList.get().getModContainerById("forestry").get()).getModInfo().getVersion() + newLine);
            for (Component line : statistics) {
                writer.write(line.getString() + newLine);
            }
            writer.close();
        }
        catch (IOException ex) {
            CommandHelpers.sendLocalizedChatMessage((CommandSourceStack)ctx.getSource(), "for.chat.command.forestry.stats.save.error3", new Object[0]);
            Forestry.LOGGER.error("Write operation threw an exception. Failed to save statistics.", (Throwable)ex);
            return 0;
        }
        CommandHelpers.sendLocalizedChatMessage((CommandSourceStack)ctx.getSource(), "for.chat.command.forestry.stats.save.saved", player.m_5446_());
        return 1;
    }

    private static String generateSpeciesListHeader() {
        MutableComponent authority = Component.m_237115_((String)"for.gui.alyzer.authority");
        MutableComponent species = Component.m_237115_((String)"for.gui.species");
        return CommandSaveStats.speciesListEntry(discoveredSymbol, notCountedSymbol, "UID", (Component)species, authority.getString());
    }

    private static String generateSpeciesListEntry(ISpecies<?> species, IBreedingTracker tracker) {
        MutableComponent discovered = Component.m_237119_();
        if (tracker.isDiscovered(species)) {
            discovered = discoveredSymbol;
        }
        MutableComponent notCounted = Component.m_237119_();
        if (!species.isDominant()) {
            notCounted = notCountedSymbol;
        }
        return CommandSaveStats.speciesListEntry((Component)discovered, (Component)notCounted, species.id().toString(), (Component)species.getDisplayName(), species.getAuthority());
    }

    private static String speciesListEntry(Component discovered, Component notCounted, String UID, Component speciesName, String authority) {
        return String.format("[ %-2s ] [ %-2s ]\t%-40s %-20s %-20s", discovered, notCounted, UID, speciesName, authority);
    }
}

