/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.circuits;

import forestry.api.IForestryApi;
import forestry.api.circuits.ICircuit;
import forestry.api.circuits.ICircuitBoard;
import forestry.api.circuits.ICircuitLayout;
import forestry.core.circuits.EnumCircuitBoardType;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class CircuitBoard
implements ICircuitBoard {
    private final EnumCircuitBoardType type;
    @Nullable
    private final ICircuitLayout layout;
    private final ICircuit[] circuits;

    public CircuitBoard(EnumCircuitBoardType type, @Nullable ICircuitLayout layout, ICircuit[] circuits) {
        this.type = type;
        this.layout = layout;
        this.circuits = circuits;
    }

    public CircuitBoard(CompoundTag compound) {
        this.type = EnumCircuitBoardType.values()[compound.m_128448_("T")];
        ICircuitLayout layout = null;
        if (compound.m_128441_("LY")) {
            layout = IForestryApi.INSTANCE.getCircuitManager().getLayout(compound.m_128461_("LY"));
        }
        this.layout = layout;
        this.circuits = new ICircuit[4];
        for (int i = 0; i < 4; ++i) {
            ICircuit circuit;
            if (!compound.m_128441_("CA.I" + i) || (circuit = IForestryApi.INSTANCE.getCircuitManager().getCircuit(compound.m_128461_("CA.I" + i))) == null) continue;
            this.circuits[i] = circuit;
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public int getPrimaryColor() {
        return this.type.getPrimaryColor();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public int getSecondaryColor() {
        return this.type.getSecondaryColor();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void addTooltip(List<Component> list) {
        if (this.layout != null) {
            list.add((Component)Component.m_237113_((String)(this.layout.getUsage().getString() + ":")).m_130940_(ChatFormatting.GOLD));
            ArrayList<Component> extendedTooltip = new ArrayList<Component>();
            for (ICircuit circuit : this.circuits) {
                if (circuit == null) continue;
                circuit.addTooltip(extendedTooltip);
            }
            if (Screen.m_96638_() || extendedTooltip.size() <= 4) {
                list.addAll(extendedTooltip);
            } else {
                list.add((Component)Component.m_237113_((String)"<").m_130944_(new ChatFormatting[]{ChatFormatting.UNDERLINE, ChatFormatting.GRAY}).m_7220_((Component)Component.m_237115_((String)"for.gui.tooltip.tmi")).m_7220_((Component)Component.m_237113_((String)">")));
            }
        } else {
            int socketCount = this.type.getSockets();
            String localizationKey = "item.forestry.circuit_board.tooltip." + (socketCount == 1 ? "singular" : "plural");
            list.add((Component)Component.m_237110_((String)localizationKey, (Object[])new Object[]{this.type.getSockets()}).m_130940_(ChatFormatting.GRAY));
        }
    }

    @Override
    public CompoundTag write(CompoundTag compound) {
        compound.m_128376_("T", (short)this.type.ordinal());
        if (this.layout != null) {
            compound.m_128359_("LY", this.layout.getId());
        }
        for (int i = 0; i < this.circuits.length; ++i) {
            ICircuit circuit = this.circuits[i];
            if (circuit == null) continue;
            compound.m_128359_("CA.I" + i, circuit.getId());
        }
        return compound;
    }

    @Override
    public void onInsertion(Object tile) {
        for (int i = 0; i < this.circuits.length; ++i) {
            ICircuit circuit = this.circuits[i];
            if (circuit == null) continue;
            circuit.onInsertion(i, tile);
        }
    }

    @Override
    public void onLoad(Object tile) {
        for (int i = 0; i < this.circuits.length; ++i) {
            ICircuit circuit = this.circuits[i];
            if (circuit == null) continue;
            circuit.onLoad(i, tile);
        }
    }

    @Override
    public void onRemoval(Object tile) {
        for (int i = 0; i < this.circuits.length; ++i) {
            ICircuit circuit = this.circuits[i];
            if (circuit == null) continue;
            circuit.onRemoval(i, tile);
        }
    }

    @Override
    public void onTick(Object tile) {
        for (int i = 0; i < this.circuits.length; ++i) {
            ICircuit circuit = this.circuits[i];
            if (circuit == null) continue;
            circuit.onTick(i, tile);
        }
    }

    @Override
    public ICircuit[] getCircuits() {
        return this.circuits;
    }

    @Override
    @Nullable
    public ResourceLocation getSocketType() {
        if (this.layout == null) {
            return null;
        }
        return this.layout.getSocketType();
    }
}

