/*
 * Decompiled with CFR 0.152.
 */
package forestry.core;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import forestry.api.ForestryConstants;
import forestry.api.IForestryApi;
import forestry.api.client.IClientModuleHandler;
import forestry.api.modules.ForestryModule;
import forestry.api.modules.ForestryModuleIds;
import forestry.api.modules.IForestryModule;
import forestry.api.modules.IPacketRegistry;
import forestry.apiculture.features.ApicultureItems;
import forestry.apiculture.items.ItemPollenCluster;
import forestry.apiimpl.plugin.PluginManager;
import forestry.arboriculture.features.ArboricultureBlocks;
import forestry.arboriculture.features.ArboricultureItems;
import forestry.arboriculture.loot.GrafterLootModifier;
import forestry.core.PickupHandlerCore;
import forestry.core.blocks.TileStreamUpdateTracker;
import forestry.core.client.CoreClientHandler;
import forestry.core.climate.ForestryClimateManager;
import forestry.core.commands.DiagnosticsCommand;
import forestry.core.commands.DumpCommand;
import forestry.core.features.CoreItems;
import forestry.core.items.definitions.EnumCraftingMaterial;
import forestry.core.loot.ConditionLootModifier;
import forestry.core.network.PacketIdClient;
import forestry.core.network.PacketIdServer;
import forestry.core.network.packets.PacketActiveUpdate;
import forestry.core.network.packets.PacketChipsetClick;
import forestry.core.network.packets.PacketErrorUpdate;
import forestry.core.network.packets.PacketGenomeTrackerSync;
import forestry.core.network.packets.PacketGuiEnergy;
import forestry.core.network.packets.PacketGuiLayoutSelect;
import forestry.core.network.packets.PacketGuiSelectRequest;
import forestry.core.network.packets.PacketGuiStream;
import forestry.core.network.packets.PacketItemStackDisplay;
import forestry.core.network.packets.PacketPipetteClick;
import forestry.core.network.packets.PacketSocketUpdate;
import forestry.core.network.packets.PacketSolderingIronClick;
import forestry.core.network.packets.PacketTankLevelUpdate;
import forestry.core.network.packets.PacketTileStream;
import forestry.core.network.packets.RecipeCachePacket;
import forestry.core.owner.GameProfileDataSerializer;
import forestry.core.recipes.RecipeManagers;
import forestry.core.utils.NetworkUtil;
import forestry.lepidopterology.features.LepidopterologyItems;
import forestry.modules.BlankForestryModule;
import forestry.modules.ForestryModuleManager;
import forestry.modules.ModuleUtil;
import forestry.modules.features.FeatureItem;
import it.unimi.dsi.fastutil.objects.Object2FloatMap;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Unit;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.ComposterBlock;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.TagsUpdatedEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ObjectHolderRegistry;
import net.minecraftforge.registries.RegisterEvent;

@ForestryModule
public class ModuleCore
extends BlankForestryModule {
    private static boolean hasInit;

    @Override
    public ResourceLocation getId() {
        return ForestryModuleIds.CORE;
    }

    @Override
    public void registerEvents(IEventBus modBus) {
        modBus.addListener(ModuleCore::onCommonSetup);
        modBus.addListener(ModuleCore::registerGlobalLootModifiers);
        ObjectHolderRegistry.addHandler(ModuleCore::postItemRegistry);
        ModuleUtil.loadFeatureProviders();
        MinecraftForge.EVENT_BUS.addListener(ModuleCore::onItemPickup);
        MinecraftForge.EVENT_BUS.addListener(ModuleCore::onLevelTick);
        MinecraftForge.EVENT_BUS.addListener(ModuleCore::onTagsUpdated);
        MinecraftForge.EVENT_BUS.addListener(ModuleCore::registerReloadListeners);
        MinecraftForge.EVENT_BUS.addListener(ModuleCore::registerCommands);
        PluginManager.registerAsyncException(modBus);
    }

    private static void onCommonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            ((ForestryModuleManager)IForestryApi.INSTANCE.getModuleManager()).setupApi();
            PluginManager.registerCircuits();
            EntityDataSerializers.m_135050_((EntityDataSerializer)GameProfileDataSerializer.INSTANCE);
            ModuleCore.registerComposts();
        });
    }

    private static void registerComposts() {
        Object2FloatMap composts = ComposterBlock.f_51914_;
        for (FeatureItem fruit : CoreItems.FRUITS.getFeatures()) {
            composts.put(fruit.item(), 0.65f);
        }
        composts.put((Object)CoreItems.MOULDY_WHEAT.item(), 0.65f);
        composts.put((Object)CoreItems.DECAYING_WHEAT.item(), 0.65f);
        composts.put((Object)CoreItems.MULCH.item(), 0.65f);
        composts.put((Object)CoreItems.ASH.item(), 0.65f);
        composts.put((Object)CoreItems.CRAFTING_MATERIALS.item(EnumCraftingMaterial.WOOD_PULP), 0.65f);
        composts.put((Object)CoreItems.PEAT.item(), 0.75f);
        composts.put((Object)CoreItems.COMPOST.item(), 1.0f);
        for (ItemPollenCluster pollen : ApicultureItems.POLLEN_CLUSTER.getItems()) {
            composts.put((Object)pollen, 0.3f);
        }
        composts.put((Object)ArboricultureItems.SAPLING.item(), 0.3f);
        composts.put((Object)ArboricultureItems.POLLEN_FERTILE.item(), 0.3f);
        for (BlockItem leaves : ArboricultureBlocks.LEAVES_DECORATIVE.getItems()) {
            composts.put((Object)leaves, 0.3f);
        }
        composts.put((Object)LepidopterologyItems.COCOON_GE.item(), 0.3f);
    }

    private static void registerGlobalLootModifiers(RegisterEvent event) {
        event.register(ForgeRegistries.Keys.GLOBAL_LOOT_MODIFIER_SERIALIZERS, helper -> {
            helper.register(ForestryConstants.forestry("condition_modifier"), ConditionLootModifier.CODEC);
            helper.register(ForestryConstants.forestry("grafter_modifier"), GrafterLootModifier.CODEC);
        });
    }

    private static void postItemRegistry(Predicate<ResourceLocation> registryPredicate) {
        if (!hasInit && registryPredicate.test(Registries.f_256913_.m_135782_())) {
            PluginManager.registerGenetics();
            PluginManager.registerFarming();
            PluginManager.registerPollen();
            hasInit = true;
        }
    }

    private static void onItemPickup(EntityItemPickupEvent event) {
        if (event.isCanceled() || event.getResult() == Event.Result.ALLOW) {
            return;
        }
        PickupHandlerCore.onItemPickup(event.getEntity(), event.getItem());
    }

    private static void onLevelTick(TickEvent.LevelTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            TileStreamUpdateTracker.syncVisualUpdates();
        }
    }

    private static void onTagsUpdated(TagsUpdatedEvent event) {
        if (event.shouldUpdateStaticData()) {
            event.getRegistryAccess().m_6632_(Registries.f_256952_).ifPresent(registry -> ((ForestryClimateManager)IForestryApi.INSTANCE.getClimateManager()).onBiomesReloaded((Registry<Biome>)registry));
        }
    }

    private static void registerReloadListeners(AddReloadListenerEvent event) {
        event.addListener((prepBarrier, resourceManager, prepProfiler, reloadProfiler, backgroundExecutor, gameExecutor) -> prepBarrier.m_6769_((Object)Unit.INSTANCE).thenRunAsync(() -> {
            RecipeManagers.invalidateCaches();
            NetworkUtil.sendToAllPlayers(new RecipeCachePacket());
        }));
    }

    private static void registerCommands(RegisterCommandsEvent event) {
        LiteralArgumentBuilder forestryCommand = LiteralArgumentBuilder.literal((String)"forestry");
        forestryCommand.then(DiagnosticsCommand.register());
        forestryCommand.then(DumpCommand.register());
        for (IForestryModule module : IForestryApi.INSTANCE.getModuleManager().getModulesForMod("forestry")) {
            if (!(module instanceof BlankForestryModule)) continue;
            BlankForestryModule forestryModule = (BlankForestryModule)module;
            forestryModule.addToRootCommand((LiteralArgumentBuilder<CommandSourceStack>)forestryCommand);
        }
        event.getDispatcher().register(forestryCommand);
    }

    @Override
    public boolean isCore() {
        return true;
    }

    @Override
    public List<ResourceLocation> getModuleDependencies() {
        return List.of();
    }

    @Override
    public void registerPackets(IPacketRegistry registry) {
        registry.serverbound(PacketIdServer.GUI_SELECTION_REQUEST, PacketGuiSelectRequest.class, PacketGuiSelectRequest::decode, PacketGuiSelectRequest::handle);
        registry.serverbound(PacketIdServer.PIPETTE_CLICK, PacketPipetteClick.class, PacketPipetteClick::decode, PacketPipetteClick::handle);
        registry.serverbound(PacketIdServer.CHIPSET_CLICK, PacketChipsetClick.class, PacketChipsetClick::decode, PacketChipsetClick::handle);
        registry.serverbound(PacketIdServer.SOLDERING_IRON_CLICK, PacketSolderingIronClick.class, PacketSolderingIronClick::decode, PacketSolderingIronClick::handle);
        registry.clientbound(PacketIdClient.ERROR_UPDATE, PacketErrorUpdate.class, PacketErrorUpdate::decode, PacketErrorUpdate::handle);
        registry.clientbound(PacketIdClient.GUI_UPDATE, PacketGuiStream.class, PacketGuiStream::decode, PacketGuiStream::handle);
        registry.clientbound(PacketIdClient.GUI_LAYOUT_SELECT, PacketGuiLayoutSelect.class, PacketGuiLayoutSelect::decode, PacketGuiLayoutSelect::handle);
        registry.clientbound(PacketIdClient.GUI_ENERGY, PacketGuiEnergy.class, PacketGuiEnergy::decode, PacketGuiEnergy::handle);
        registry.clientbound(PacketIdClient.SOCKET_UPDATE, PacketSocketUpdate.class, PacketSocketUpdate::decode, PacketSocketUpdate::handle);
        registry.clientbound(PacketIdClient.TILE_FORESTRY_UPDATE, PacketTileStream.class, PacketTileStream::decode, PacketTileStream::handle);
        registry.clientbound(PacketIdClient.TILE_FORESTRY_ACTIVE, PacketActiveUpdate.class, PacketActiveUpdate::decode, PacketActiveUpdate::handle);
        registry.clientbound(PacketIdClient.ITEMSTACK_DISPLAY, PacketItemStackDisplay.class, PacketItemStackDisplay::decode, PacketItemStackDisplay::handle);
        registry.clientbound(PacketIdClient.GENOME_TRACKER_UPDATE, PacketTankLevelUpdate.class, PacketTankLevelUpdate::decode, PacketTankLevelUpdate::handle);
        registry.clientbound(PacketIdClient.TANK_LEVEL_UPDATE, PacketGenomeTrackerSync.class, PacketGenomeTrackerSync::decode, PacketGenomeTrackerSync::handle);
        registry.clientbound(PacketIdClient.RECIPE_CACHE, RecipeCachePacket.class, RecipeCachePacket::decode, RecipeCachePacket::handle);
    }

    @Override
    public void registerClientHandler(Consumer<IClientModuleHandler> registrar) {
        registrar.accept(new CoreClientHandler());
    }
}

