/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.worldgen;

import com.google.common.collect.Lists;
import forestry.api.arboriculture.ITreeGenData;
import forestry.api.genetics.IGenome;
import forestry.arboriculture.blocks.BlockSapling;
import forestry.arboriculture.worldgen.TreeBlockTypeLeaf;
import forestry.arboriculture.worldgen.TreeBlockTypeLog;
import forestry.arboriculture.worldgen.TreeContour;
import forestry.core.utils.VecUtil;
import forestry.core.worldgen.FeatureBase;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.OptionalInt;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.phys.shapes.BitSetDiscreteVoxelShape;
import net.minecraft.world.phys.shapes.DiscreteVoxelShape;

public abstract class FeatureArboriculture
extends FeatureBase {
    protected static final int minPodHeight = 3;
    protected final ITreeGenData tree;

    protected FeatureArboriculture(ITreeGenData tree) {
        this.tree = tree;
    }

    @Override
    public IGenome getDefaultGenome() {
        return this.tree.getDefaultGenome();
    }

    @Override
    public boolean place(IGenome genome, LevelAccessor level, RandomSource rand, BlockPos pos, boolean forced) {
        TreeBlockTypeLeaf leaf = new TreeBlockTypeLeaf(this.tree, genome);
        TreeBlockTypeLog wood = new TreeBlockTypeLog(this.tree, genome);
        this.preGenerate(genome, level, rand, pos);
        BlockPos genPos = forced ? pos : this.getValidGrowthPos(level, pos);
        if (genPos != null) {
            this.clearSaplings(level, genPos);
            ArrayList<BlockPos> branchEnds = new ArrayList<BlockPos>(this.generateTrunk(level, rand, wood, genPos));
            branchEnds.sort(VecUtil.TOP_DOWN_COMPARATOR);
            TreeContour.Impl contour = new TreeContour.Impl(branchEnds);
            this.generateLeaves(level, rand, leaf, contour, genPos);
            this.generateExtras(level, rand, genPos);
            if (contour.boundingBox != null) {
                DiscreteVoxelShape voxelshapepart = this.updateLeaves(level, contour);
                StructureTemplate.m_74510_((LevelAccessor)level, (int)3, (DiscreteVoxelShape)voxelshapepart, (int)contour.boundingBox.m_162395_(), (int)contour.boundingBox.m_162396_(), (int)contour.boundingBox.m_162398_());
            }
            return true;
        }
        return false;
    }

    public void preGenerate(IGenome genome, LevelAccessor level, RandomSource rand, BlockPos startPos) {
    }

    private DiscreteVoxelShape updateLeaves(LevelAccessor level, TreeContour.Impl contour) {
        BoundingBox pBox = contour.boundingBox;
        BitSetDiscreteVoxelShape discretevoxelshape = new BitSetDiscreteVoxelShape(pBox.m_71056_(), pBox.m_71057_(), pBox.m_71058_());
        ArrayList list = new ArrayList();
        for (int j = 0; j < 7; ++j) {
            list.add(new HashSet());
        }
        for (BlockPos blockpos : Lists.newArrayList(contour.leavePositions)) {
            if (!pBox.m_71051_((Vec3i)blockpos)) continue;
            discretevoxelshape.m_142703_(blockpos.m_123341_() - pBox.m_162395_(), blockpos.m_123342_() - pBox.m_162396_(), blockpos.m_123343_() - pBox.m_162398_());
        }
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        int k1 = 0;
        block2: while (true) {
            if (k1 >= 7 || !((HashSet)list.get(k1)).isEmpty()) {
                if (k1 >= 7) {
                    return discretevoxelshape;
                }
                Iterator iterator = ((HashSet)list.get(k1)).iterator();
                BlockPos blockpos1 = (BlockPos)iterator.next();
                iterator.remove();
                if (!pBox.m_71051_((Vec3i)blockpos1)) continue;
                if (k1 != 0) {
                    BlockState blockstate = level.m_8055_(blockpos1);
                    FeatureArboriculture.setBlockKnownShape((LevelWriter)level, blockpos1, (BlockState)blockstate.m_61124_((Property)BlockStateProperties.f_61414_, (Comparable)Integer.valueOf(k1)));
                }
                discretevoxelshape.m_142703_(blockpos1.m_123341_() - pBox.m_162395_(), blockpos1.m_123342_() - pBox.m_162396_(), blockpos1.m_123343_() - pBox.m_162398_());
                Direction[] directionArray = Direction.values();
                int n = directionArray.length;
                int n2 = 0;
                while (true) {
                    int j1;
                    BlockState blockstate1;
                    OptionalInt optionalint;
                    int i1;
                    int l;
                    int k;
                    if (n2 >= n) continue block2;
                    Direction direction = directionArray[n2];
                    blockpos$mutableblockpos.m_122159_((Vec3i)blockpos1, direction);
                    if (pBox.m_71051_((Vec3i)blockpos$mutableblockpos) && !discretevoxelshape.m_6696_(k = blockpos$mutableblockpos.m_123341_() - pBox.m_162395_(), l = blockpos$mutableblockpos.m_123342_() - pBox.m_162396_(), i1 = blockpos$mutableblockpos.m_123343_() - pBox.m_162398_()) && !(optionalint = LeavesBlock.m_277200_((BlockState)(blockstate1 = level.m_8055_((BlockPos)blockpos$mutableblockpos)))).isEmpty() && (j1 = Math.min(optionalint.getAsInt(), k1 + 1)) < 7) {
                        ((HashSet)list.get(j1)).add(blockpos$mutableblockpos.m_7949_());
                        k1 = Math.min(k1, j1);
                    }
                    ++n2;
                }
            }
            ++k1;
        }
    }

    private static void setBlockKnownShape(LevelWriter level, BlockPos pos, BlockState state) {
        level.m_7731_(pos, state, 19);
    }

    protected abstract Set<BlockPos> generateTrunk(LevelAccessor var1, RandomSource var2, TreeBlockTypeLog var3, BlockPos var4);

    protected abstract void generateLeaves(LevelAccessor var1, RandomSource var2, TreeBlockTypeLeaf var3, TreeContour var4, BlockPos var5);

    protected abstract void generateExtras(LevelAccessor var1, RandomSource var2, BlockPos var3);

    @Nullable
    public abstract BlockPos getValidGrowthPos(LevelAccessor var1, BlockPos var2);

    public void clearSaplings(LevelAccessor level, BlockPos genPos) {
        int treeGirth = this.tree.getGirth(this.tree.getDefaultGenome());
        for (int x = 0; x < treeGirth; ++x) {
            for (int z = 0; z < treeGirth; ++z) {
                BlockPos saplingPos = genPos.m_7918_(x, 0, z);
                if (!(level.m_8055_(saplingPos).m_60734_() instanceof BlockSapling)) continue;
                level.m_7731_(saplingPos, Blocks.f_50016_.m_49966_(), 18);
            }
        }
    }

    public boolean hasPods() {
        return this.tree.allowsFruitBlocks(this.tree.getDefaultGenome());
    }
}

