/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.tiles;

import forestry.api.IForestryApi;
import forestry.api.arboriculture.ITreeSpecies;
import forestry.api.arboriculture.genetics.IFruit;
import forestry.api.arboriculture.genetics.ITreeSpeciesType;
import forestry.api.core.IProduct;
import forestry.api.genetics.IFruitBearer;
import forestry.api.genetics.IGenome;
import forestry.api.genetics.alleles.ForestryAlleles;
import forestry.api.genetics.alleles.IValueAllele;
import forestry.api.genetics.alleles.TreeChromosomes;
import forestry.arboriculture.features.ArboricultureTiles;
import forestry.core.ClientsideCode;
import forestry.core.network.IStreamable;
import forestry.core.utils.BlockUtil;
import forestry.core.utils.NBTUtilForestry;
import forestry.core.utils.SpeciesUtil;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.CocoaBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class TileFruitPod
extends BlockEntity
implements IFruitBearer,
IStreamable {
    private static final short MAX_MATURITY = 2;
    private static final IGenome defaultGenome = ((ITreeSpecies)((ITreeSpeciesType)SpeciesUtil.TREE_TYPE.get()).getDefaultSpecies()).getDefaultGenome();
    public static final String NBT_MATURITY = "MT";
    public static final String NBT_YIELD = "SP";
    public static final String NBT_FRUIT = "UID";
    private IGenome genome = defaultGenome;
    @Nullable
    private IFruit fruit = null;
    private short maturity;
    private float yield;

    public TileFruitPod(BlockPos pos, BlockState state) {
        super(ArboricultureTiles.PODS.tileType(), pos, state);
    }

    public void setProperties(IGenome genome, IFruit allele, float yield) {
        this.genome = genome;
        this.fruit = allele;
        this.yield = yield;
        this.m_6596_();
    }

    @Override
    public void writeData(FriendlyByteBuf data) {
        if (this.fruit != null) {
            data.writeBoolean(true);
            data.m_130085_(TreeChromosomes.FRUIT.getId(this.fruit));
        } else {
            data.writeBoolean(false);
        }
    }

    @Override
    public void readData(FriendlyByteBuf data) {
        IValueAllele stored;
        Object v;
        if (data.readBoolean() && (v = (stored = (IValueAllele)IForestryApi.INSTANCE.getAlleleManager().getAllele(data.m_130281_()).cast()).value()) instanceof IFruit) {
            IFruit newFruit;
            this.fruit = newFruit = (IFruit)v;
            ClientsideCode.markForUpdate(this.f_58858_);
        }
    }

    public void m_183515_(CompoundTag compoundNBT) {
        super.m_183515_(compoundNBT);
        if (this.fruit != null) {
            compoundNBT.m_128359_(NBT_FRUIT, TreeChromosomes.FRUIT.getId(this.fruit).toString());
        }
        compoundNBT.m_128376_(NBT_MATURITY, this.maturity);
        compoundNBT.m_128350_(NBT_YIELD, this.yield);
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        String fruitNbt = nbt.m_128461_(NBT_FRUIT);
        if (!fruitNbt.isEmpty()) {
            this.fruit = TreeChromosomes.FRUIT.getSafe(new ResourceLocation(fruitNbt));
        }
        if (this.fruit == null) {
            this.fruit = (IFruit)ForestryAlleles.FRUIT_COCOA.value();
        }
        this.maturity = nbt.m_128448_(NBT_MATURITY);
        this.yield = nbt.m_128457_(NBT_YIELD);
    }

    public void onBlockTick(RandomSource rand) {
        if (this.canMature() && rand.m_188501_() <= this.yield) {
            this.addRipeness(0.5f);
        }
    }

    public boolean canMature() {
        return this.maturity < 2;
    }

    public short getMaturity() {
        return this.maturity;
    }

    public ItemStack getPickBlock() {
        if (this.fruit == null) {
            return ItemStack.f_41583_;
        }
        List<IProduct> products = this.fruit.getProducts();
        ItemStack pickBlock = ItemStack.f_41583_;
        float maxChance = 0.0f;
        for (IProduct product : products) {
            if (!(maxChance < product.chance())) continue;
            maxChance = product.chance();
            pickBlock = product.createStack();
        }
        pickBlock.m_41764_(1);
        return pickBlock;
    }

    public List<ItemStack> getDrops() {
        return this.fruit == null ? List.of() : this.fruit.getFruits(this.genome, this.f_58857_, this.maturity);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = super.m_5995_();
        return NBTUtilForestry.writeStreamableToNbt(this, tag);
    }

    public void handleUpdateTag(CompoundTag tag) {
        super.handleUpdateTag(tag);
        NBTUtilForestry.readStreamableFromNbt(this, tag);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        super.onDataPacket(net, pkt);
        CompoundTag nbt = pkt.m_131708_();
        this.handleUpdateTag(nbt);
    }

    @Override
    public boolean hasFruit() {
        return true;
    }

    @Override
    public List<ItemStack> pickFruit(ItemStack tool) {
        List<ItemStack> fruits = this.getDrops();
        this.maturity = 0;
        BlockState oldState = this.m_58900_();
        BlockState newState = (BlockState)oldState.m_61124_((Property)CocoaBlock.f_51736_, (Comparable)Integer.valueOf(0));
        BlockUtil.setBlockWithBreakSound(this.f_58857_, this.m_58899_(), newState, oldState);
        return fruits;
    }

    @Override
    public float getRipeness() {
        return (float)this.maturity / 2.0f;
    }

    @Override
    public void addRipeness(float add) {
        short age;
        short previousAge = this.maturity;
        this.maturity = (short)((float)this.maturity + 2.0f * add);
        if (this.maturity > 2) {
            this.maturity = (short)2;
        }
        if ((age = this.maturity) - previousAge > 0) {
            BlockState state = (BlockState)this.m_58900_().m_61124_((Property)CocoaBlock.f_51736_, (Comparable)Integer.valueOf(age));
            this.f_58857_.m_46597_(this.m_58899_(), state);
        }
    }
}

