/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.models;

import forestry.api.arboriculture.ITreeSpecies;
import forestry.api.arboriculture.genetics.ITree;
import forestry.api.arboriculture.genetics.ITreeSpeciesType;
import forestry.api.client.IForestryClientApi;
import forestry.arboriculture.blocks.BlockForestryLeaves;
import forestry.arboriculture.features.ArboricultureBlocks;
import forestry.arboriculture.tiles.TileLeaves;
import forestry.core.models.ModelBlockCached;
import forestry.core.models.baker.ModelBaker;
import forestry.core.utils.ResourceUtil;
import forestry.core.utils.SpeciesUtil;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.ItemTransform;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.data.ModelData;
import org.joml.Vector3f;

@OnlyIn(value=Dist.CLIENT)
public class ModelLeaves
extends ModelBlockCached<BlockForestryLeaves, Key> {
    public static final ItemTransforms TRANSFORMS = new ItemTransforms(new ItemTransform(new Vector3f(75.0f, 45.0f, 0.0f), new Vector3f(0.0f, 0.15625f, 0.0f), new Vector3f(0.375f, 0.375f, 0.375f)), new ItemTransform(new Vector3f(75.0f, 45.0f, 0.0f), new Vector3f(0.0f, 0.15625f, 0.0f), new Vector3f(0.375f, 0.375f, 0.375f)), new ItemTransform(new Vector3f(0.0f, 225.0f, 0.0f), new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.4f, 0.4f, 0.4f)), new ItemTransform(new Vector3f(0.0f, 45.0f, 0.0f), new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.4f, 0.4f, 0.4f)), ItemTransform.f_111754_, new ItemTransform(new Vector3f(30.0f, 225.0f, 0.0f), new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.625f, 0.625f, 0.625f)), new ItemTransform(new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.0f, 0.1875f, 0.0f), new Vector3f(0.25f, 0.25f, 0.25f)), new ItemTransform(new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.5f, 0.5f, 0.5f)));

    @Override
    protected Key getInventoryKey(ItemStack stack) {
        TileLeaves leaves = new TileLeaves(BlockPos.f_121853_, ArboricultureBlocks.LEAVES.defaultState());
        if (stack.m_41783_() != null) {
            leaves.m_142466_(stack.m_41783_());
        } else {
            leaves.setTree((ITree)((ITreeSpecies)((ITreeSpeciesType)SpeciesUtil.TREE_TYPE.get()).getDefaultSpecies()).createIndividual());
        }
        return this.getKey(leaves.getModelData());
    }

    @Override
    protected Key getWorldKey(BlockState state, ModelData extraData) {
        return this.getKey(extraData);
    }

    private Key getKey(ModelData extraData) {
        boolean fancy = Minecraft.m_91405_();
        ITreeSpecies species = (ITreeSpecies)extraData.get(TileLeaves.PROPERTY_SPECIES);
        if (species == null) {
            species = (ITreeSpecies)((ITreeSpeciesType)SpeciesUtil.TREE_TYPE.get()).getDefaultSpecies();
        }
        ResourceLocation leafLocation = IForestryClientApi.INSTANCE.getTreeManager().getLeafSprite(species).get(Boolean.TRUE.equals(extraData.get(TileLeaves.PROPERTY_POLLINATED)), fancy);
        ResourceLocation fruitLocation = (ResourceLocation)extraData.get(TileLeaves.PROPERTY_FRUIT_TEXTURE);
        return new Key(ResourceUtil.getBlockSprite(leafLocation), fruitLocation != null ? ResourceUtil.getBlockSprite(fruitLocation) : null, fancy);
    }

    @Override
    protected void bakeBlock(BlockForestryLeaves block, ModelData extraData, Key key, ModelBaker baker, boolean inventory) {
        baker.addBlockModel(key.leafSprite, 0);
        if (key.fruitSprite != null) {
            baker.addBlockModel(key.fruitSprite, 2);
        }
        baker.setParticleSprite(key.leafSprite);
    }

    public ModelLeaves() {
        super(BlockForestryLeaves.class);
    }

    @Override
    public ItemTransforms m_7442_() {
        return TRANSFORMS;
    }

    public static class Key {
        public final TextureAtlasSprite leafSprite;
        @Nullable
        public final TextureAtlasSprite fruitSprite;
        public final boolean fancy;
        private final int hashCode;

        public Key(TextureAtlasSprite leafSprite, @Nullable TextureAtlasSprite fruitSprite, boolean fancy) {
            this.leafSprite = leafSprite;
            this.fruitSprite = fruitSprite;
            this.fancy = fancy;
            this.hashCode = Objects.hash(leafSprite, fruitSprite, fancy);
        }

        public boolean equals(Object other) {
            if (!(other instanceof Key)) {
                return false;
            }
            Key otherKey = (Key)other;
            return otherKey.leafSprite == this.leafSprite && otherKey.fruitSprite == this.fruitSprite && otherKey.fancy == this.fancy;
        }

        public int hashCode() {
            return this.hashCode;
        }
    }
}

