/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.genetics;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.mojang.authlib.GameProfile;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import forestry.api.arboriculture.IArboristTracker;
import forestry.api.arboriculture.ILeafTickHandler;
import forestry.api.arboriculture.ITreeSpecies;
import forestry.api.arboriculture.genetics.IFruit;
import forestry.api.arboriculture.genetics.ITree;
import forestry.api.arboriculture.genetics.ITreeSpeciesType;
import forestry.api.core.IProduct;
import forestry.api.genetics.ForestrySpeciesTypes;
import forestry.api.genetics.IAlyzerPlugin;
import forestry.api.genetics.IBreedingTracker;
import forestry.api.genetics.IBreedingTrackerHandler;
import forestry.api.genetics.IGenome;
import forestry.api.genetics.IIndividual;
import forestry.api.genetics.IMutationManager;
import forestry.api.genetics.alleles.IKaryotype;
import forestry.api.genetics.alleles.TreeChromosomes;
import forestry.api.plugin.IForestryPlugin;
import forestry.api.plugin.ISpeciesTypeBuilder;
import forestry.apiimpl.plugin.ArboricultureRegistration;
import forestry.arboriculture.PodFruit;
import forestry.arboriculture.blocks.BlockFruitPod;
import forestry.arboriculture.blocks.ForestryLeafType;
import forestry.arboriculture.features.ArboricultureBlocks;
import forestry.arboriculture.genetics.ArboristTracker;
import forestry.arboriculture.genetics.Tree;
import forestry.arboriculture.genetics.TreeAlyzerPlugin;
import forestry.arboriculture.tiles.TileFruitPod;
import forestry.arboriculture.tiles.TileSapling;
import forestry.arboriculture.tiles.TileTreeContainer;
import forestry.core.ClientsideCode;
import forestry.core.genetics.SpeciesType;
import forestry.core.genetics.root.BreedingTrackerManager;
import forestry.core.tiles.TileUtil;
import forestry.core.utils.BlockUtil;
import forestry.modules.features.FeatureBlock;
import java.io.Serializable;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class TreeSpeciesType
extends SpeciesType<ITreeSpecies, ITree>
implements ITreeSpeciesType,
IBreedingTrackerHandler {
    private final LinkedList<ILeafTickHandler> leafTickHandlers = new LinkedList();
    private final IdentityHashMap<BlockState, ITree> vanillaIndividuals = new IdentityHashMap();
    private final IdentityHashMap<Item, ITree> vanillaItems = new IdentityHashMap();

    public TreeSpeciesType(IKaryotype karyotype, ISpeciesTypeBuilder builder) {
        super(ForestrySpeciesTypes.TREE, karyotype, builder);
    }

    @Override
    public void onSpeciesRegistered(ImmutableMap<ResourceLocation, ITreeSpecies> allSpecies, IMutationManager<ITreeSpecies> mutations) {
        super.onSpeciesRegistered(allSpecies, mutations);
        this.vanillaIndividuals.clear();
        this.vanillaItems.clear();
        for (ITreeSpecies entry : allSpecies.values()) {
            ITree defaultIndividual = (ITree)entry.createIndividual();
            for (BlockState state : entry.getVanillaLeafStates()) {
                this.vanillaIndividuals.put(state, defaultIndividual);
            }
            for (Item item : entry.getVanillaSaplingItems()) {
                this.vanillaItems.put(item, defaultIndividual);
            }
        }
        for (ForestryLeafType type : ForestryLeafType.allValues()) {
            ITreeSpecies species = (ITreeSpecies)allSpecies.get((Object)type.getSpeciesId());
            if (species != null) {
                type.setSpecies(species);
                continue;
            }
            throw new IllegalStateException("Invalid ForestryLeafType " + type.m_7912_() + ": no tree species found with ID: " + type.getSpeciesId());
        }
    }

    @Override
    public Pair<ImmutableMap<ResourceLocation, ITreeSpecies>, IMutationManager<ITreeSpecies>> handleSpeciesRegistration(List<IForestryPlugin> plugins) {
        ArboricultureRegistration registration = new ArboricultureRegistration(this);
        for (IForestryPlugin plugin : plugins) {
            plugin.registerArboriculture(registration);
        }
        TreeChromosomes.EFFECT.populate(registration.getEffects());
        TreeChromosomes.FRUIT.populate(registration.getFruits());
        return registration.buildAll();
    }

    @Override
    public ITree getTree(IGenome genome) {
        return new Tree(genome);
    }

    @Override
    public boolean isMember(IIndividual individual) {
        return individual instanceof ITree;
    }

    @Override
    @Nullable
    public ITree getTree(Level level, BlockPos pos) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof TileTreeContainer) {
            TileTreeContainer container = (TileTreeContainer)blockEntity;
            return container.getTree();
        }
        return null;
    }

    @Override
    @Nullable
    public ITree getTree(BlockEntity tileEntity) {
        ITree iTree;
        if (tileEntity instanceof TileTreeContainer) {
            TileTreeContainer container = (TileTreeContainer)tileEntity;
            iTree = container.getTree();
        } else {
            iTree = null;
        }
        return iTree;
    }

    @Override
    public boolean plantSapling(Level level, ITree tree, GameProfile owner, BlockPos pos) {
        BlockState state = ArboricultureBlocks.SAPLING_GE.defaultState();
        boolean placed = level.m_46597_(pos, state);
        if (!placed) {
            return false;
        }
        BlockState blockState = level.m_8055_(pos);
        Block block = blockState.m_60734_();
        if (!ArboricultureBlocks.SAPLING_GE.blockEqual(block)) {
            return false;
        }
        TileSapling sapling = TileUtil.getTile((BlockGetter)level, pos, TileSapling.class);
        if (sapling == null) {
            level.m_46597_(pos, Blocks.f_50016_.m_49966_());
            return false;
        }
        sapling.setTree(tree.copy());
        sapling.getOwnerHandler().setOwner(owner);
        BlockUtil.sendPlaceSound(level, pos, blockState);
        return true;
    }

    @Override
    public boolean setFruitBlock(LevelAccessor level, IGenome genome, IFruit fruit, float yield, BlockPos pos) {
        Block block;
        BlockFruitPod fruitPod;
        BlockState state;
        boolean placed;
        PodFruit podFruit;
        Direction facing = BlockUtil.getValidPodFacing(level, pos, fruit.getLogTag());
        if (facing != null && fruit instanceof PodFruit && ArboricultureBlocks.PODS.has((podFruit = (PodFruit)fruit).getType()) && (placed = level.m_7731_(pos, state = (BlockState)(fruitPod = (BlockFruitPod)((Object)((FeatureBlock)ArboricultureBlocks.PODS.get(podFruit.getType())).block())).m_49966_().m_61124_((Property)HorizontalDirectionalBlock.f_54117_, (Comparable)facing), 18)) && fruitPod == (block = level.m_8055_(pos).m_60734_())) {
            TileFruitPod pod = TileUtil.getTile((BlockGetter)level, pos, TileFruitPod.class);
            if (pod != null) {
                pod.setProperties(genome, fruit, yield);
                if (level.m_5776_()) {
                    ClientsideCode.markForUpdate(pos);
                }
                return true;
            }
            level.m_7731_(pos, Blocks.f_50016_.m_49966_(), 18);
            return false;
        }
        return false;
    }

    @Override
    public IArboristTracker getBreedingTracker(LevelAccessor level, @Nullable GameProfile profile) {
        return (IArboristTracker)BreedingTrackerManager.INSTANCE.getTracker(this, level, profile);
    }

    @Override
    public String getBreedingTrackerFile(@Nullable GameProfile profile) {
        return "ArboristTracker." + (Serializable)(profile == null ? "common" : profile.getId());
    }

    @Override
    public IBreedingTracker createBreedingTracker() {
        return new ArboristTracker();
    }

    @Override
    public void initializeBreedingTracker(IBreedingTracker tracker, @Nullable Level world, @Nullable GameProfile profile) {
        if (tracker instanceof ArboristTracker) {
            ArboristTracker arboristTracker = (ArboristTracker)tracker;
            arboristTracker.setLevel(world);
            arboristTracker.setUsername(profile);
        }
    }

    @Override
    public void registerLeafTickHandler(ILeafTickHandler handler) {
        this.leafTickHandlers.add(handler);
    }

    @Override
    public Collection<ILeafTickHandler> getLeafTickHandlers() {
        return this.leafTickHandlers;
    }

    @Override
    public IAlyzerPlugin getAlyzerPlugin() {
        return TreeAlyzerPlugin.INSTANCE;
    }

    @Override
    @Nullable
    public ITree getVanillaIndividual(BlockState state) {
        return this.vanillaIndividuals.get(state);
    }

    @Override
    @Nullable
    public ITree getVanillaIndividual(Item item) {
        return this.vanillaItems.get(item);
    }

    @Override
    public Codec<? extends ITree> getIndividualCodec() {
        return Tree.CODEC;
    }

    @Override
    public float getResearchSuitability(ITreeSpecies species, ItemStack stack) {
        if (stack.m_41619_()) {
            return 0.0f;
        }
        IFruit fruit = species.getDefaultGenome().getActiveValue(TreeChromosomes.FRUIT);
        for (IProduct product : Iterables.concat(fruit.getProducts(), fruit.getSpecialty())) {
            if (!stack.m_150930_(product.item())) continue;
            return 1.0f;
        }
        return super.getResearchSuitability(species, stack);
    }
}

