/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.blocks;

import forestry.api.arboriculture.IWoodType;
import forestry.api.arboriculture.WoodBlockKind;
import forestry.arboriculture.ForestryWoodType;
import forestry.arboriculture.IWoodTyped;
import forestry.arboriculture.features.ArboricultureBlocks;
import forestry.arboriculture.features.ArboricultureTiles;
import forestry.modules.features.FeatureBlock;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.WallSignBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.SignBlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;

public class BlockForestryWallSign
extends WallSignBlock
implements IWoodTyped {
    private final ForestryWoodType type;

    public BlockForestryWallSign(ForestryWoodType type) {
        super(BlockBehaviour.Properties.m_284310_().m_280606_().m_280658_(NoteBlockInstrument.BASS).m_60910_().m_60978_(1.0f).lootFrom(((FeatureBlock)ArboricultureBlocks.SIGN.get(type))::block).m_278183_(), type.getWoodType());
        this.type = type;
    }

    @Override
    public WoodBlockKind getBlockKind() {
        return WoodBlockKind.WALL_SIGN;
    }

    @Override
    public boolean isFireproof() {
        return false;
    }

    @Override
    public IWoodType getWoodType() {
        return this.type;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> actual) {
        return BlockForestryWallSign.m_152132_(actual, ArboricultureTiles.SIGN.tileType(), SignBlockEntity::m_276836_);
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new SignBlockEntity(ArboricultureTiles.SIGN.tileType(), pos, state);
    }
}

