/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture;

import forestry.api.arboriculture.genetics.TreeLifeStage;
import forestry.api.client.ForestrySprites;
import forestry.api.genetics.ForestrySpeciesTypes;
import forestry.api.genetics.filter.FilterData;
import forestry.api.genetics.filter.IFilterRuleType;
import java.util.Locale;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum ArboricultureFilterRuleType implements IFilterRuleType
{
    TREE(ForestrySprites.ANALYZER_TREE){

        @Override
        public boolean isValid(ItemStack stack, FilterData data) {
            return true;
        }
    }
    ,
    SAPLING(ForestrySprites.ANALYZER_SAPLING){

        @Override
        public boolean isValid(ItemStack stack, FilterData data) {
            return data.stage() == TreeLifeStage.SAPLING;
        }
    }
    ,
    POLLEN(ForestrySprites.ANALYZER_POLLEN){

        @Override
        public boolean isValid(ItemStack stack, FilterData data) {
            return data.stage() == TreeLifeStage.POLLEN;
        }
    };

    private final String id;
    private final ResourceLocation sprite;

    private ArboricultureFilterRuleType(ResourceLocation sprite) {
        this.sprite = sprite;
        this.id = "forestry.arboriculture." + this.name().toLowerCase(Locale.ENGLISH);
    }

    @Override
    public ResourceLocation getSprite() {
        return this.sprite;
    }

    @Override
    public ResourceLocation getSpeciesTypeId() {
        return ForestrySpeciesTypes.TREE;
    }

    @Override
    public String getId() {
        return this.id;
    }
}

