/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.genetics.effects;

import forestry.api.apiculture.IBeeHousing;
import forestry.api.genetics.IEffectData;
import forestry.api.genetics.IGenome;
import forestry.apiculture.genetics.effects.ThrottledBeeEffect;
import forestry.core.utils.EntityUtil;
import forestry.core.utils.ItemStackUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.boss.enderdragon.phases.EnderDragonPhase;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;

public class ResurrectionBeeEffect
extends ThrottledBeeEffect {
    private final List<Resurrectable<? extends Mob>> resurrectables;

    public ResurrectionBeeEffect(List<Resurrectable<? extends Mob>> resurrectables) {
        super(true, 40, true, true);
        this.resurrectables = resurrectables;
    }

    @Override
    public IEffectData doEffectThrottled(IGenome genome, IEffectData storedData, IBeeHousing housing) {
        List<ItemEntity> entities = ThrottledBeeEffect.getEntitiesInRange(genome, housing, ItemEntity.class);
        if (entities.isEmpty()) {
            return storedData;
        }
        Collections.shuffle(this.resurrectables);
        for (ItemEntity entity : entities) {
            if (this.resurrectEntity(entity)) break;
        }
        return storedData;
    }

    private boolean resurrectEntity(ItemEntity entity) {
        if (!entity.m_6084_()) {
            return false;
        }
        ItemStack contained = entity.m_32055_();
        for (Resurrectable<? extends Mob> entry : this.resurrectables) {
            if (!ItemStackUtil.isIdenticalItem(entry.res, contained)) continue;
            if (entry.spawnAndTransform(entity)) {
                contained.m_41774_(1);
                if (contained.m_41613_() <= 0) {
                    entity.m_146870_();
                }
            }
            return true;
        }
        return false;
    }

    public static List<Resurrectable<? extends Mob>> getReanimationList() {
        ArrayList<Resurrectable<? extends Mob>> list = new ArrayList<Resurrectable<? extends Mob>>();
        list.add(new Resurrectable(new ItemStack((ItemLike)Items.f_42500_), EntityType.f_20524_));
        list.add(new Resurrectable(new ItemStack((ItemLike)Items.f_42412_), EntityType.f_20524_));
        list.add(new Resurrectable(new ItemStack((ItemLike)Items.f_42583_), EntityType.f_20501_));
        list.add(new Resurrectable(new ItemStack((ItemLike)Items.f_42585_), EntityType.f_20551_));
        return list;
    }

    public static List<Resurrectable<? extends Mob>> getResurrectionList() {
        ArrayList<Resurrectable<? extends Mob>> list = new ArrayList<Resurrectable<? extends Mob>>();
        list.add(new Resurrectable(new ItemStack((ItemLike)Items.f_42403_), EntityType.f_20558_));
        list.add(new Resurrectable(new ItemStack((ItemLike)Items.f_42584_), EntityType.f_20566_));
        list.add(new Resurrectable(new ItemStack((ItemLike)Items.f_42401_), EntityType.f_20479_));
        list.add(new Resurrectable(new ItemStack((ItemLike)Items.f_42591_), EntityType.f_20479_));
        list.add(new Resurrectable(new ItemStack((ItemLike)Items.f_42401_), EntityType.f_20554_));
        list.add(new Resurrectable(new ItemStack((ItemLike)Items.f_42591_), EntityType.f_20554_));
        list.add(new Resurrectable(new ItemStack((ItemLike)Items.f_42586_), EntityType.f_20453_));
        list.add(new Resurrectable<EnderDragon>(new ItemStack((ItemLike)Blocks.f_50260_), EntityType.f_20565_, dragon -> dragon.m_31157_().m_31416_(EnderDragonPhase.f_31377_)));
        return list;
    }

    public static class Resurrectable<T extends Mob> {
        private final ItemStack res;
        private final EntityType<T> risen;
        private final Consumer<T> risenTransformer;

        private Resurrectable(ItemStack res, EntityType<T> risen) {
            this(res, risen, e -> {});
        }

        private Resurrectable(ItemStack res, EntityType<T> risen, Consumer<T> risenTransformer) {
            this.res = res;
            this.risen = risen;
            this.risenTransformer = risenTransformer;
        }

        private boolean spawnAndTransform(ItemEntity entity) {
            EntityType<T> spawnedEntity = EntityUtil.spawnEntity(entity.m_9236_(), this.risen, entity.m_20185_(), entity.m_20186_(), entity.m_20189_());
            if (spawnedEntity != null) {
                this.risenTransformer.accept(spawnedEntity);
                return true;
            }
            return false;
        }
    }
}

