/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.genetics.effects;

import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.genetics.IEffectData;
import forestry.api.genetics.IGenome;
import forestry.apiculture.genetics.effects.ThrottledBeeEffect;
import forestry.core.render.ParticleRender;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class PotionBeeEffect
extends ThrottledBeeEffect {
    private final MobEffect potion;
    private final int potionFXColor;
    private final int duration;
    private final float chance;

    public PotionBeeEffect(boolean dominant, MobEffect potion, int duration) {
        this(dominant, potion, duration, 200, 1.0f);
    }

    public PotionBeeEffect(boolean dominant, MobEffect potion, int duration, int throttle, float chance) {
        super(dominant, throttle, true, false);
        this.potion = potion;
        this.duration = duration;
        this.chance = chance;
        Set<MobEffectInstance> potionEffects = Collections.singleton(new MobEffectInstance(potion, 1, 0));
        this.potionFXColor = PotionUtils.m_43564_(potionEffects);
    }

    @Override
    public IEffectData doEffectThrottled(IGenome genome, IEffectData storedData, IBeeHousing housing) {
        RandomSource rand = housing.getWorldObj().f_46441_;
        List<LivingEntity> entities = ThrottledBeeEffect.getEntitiesInRange(genome, housing, LivingEntity.class);
        for (LivingEntity entity : entities) {
            if (rand.m_188501_() >= this.chance || !this.secondaryEntityCheck(entity)) continue;
            int dur = this.duration;
            if (this.potion.m_19483_() == MobEffectCategory.HARMFUL) {
                int count = BeeManager.armorApiaristHelper.wearsItems(entity, this, true);
                if (count >= 4) continue;
                if (count == 3) {
                    dur = this.duration / 4;
                } else if (count == 2) {
                    dur = this.duration / 2;
                } else if (count == 1) {
                    dur = this.duration * 3 / 4;
                }
            } else if (this.potion.m_19483_() == MobEffectCategory.BENEFICIAL && entity instanceof Enemy) continue;
            entity.m_7292_(new MobEffectInstance(this.potion, dur, 0, true, true));
        }
        return storedData;
    }

    public boolean secondaryEntityCheck(LivingEntity entity) {
        return true;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public IEffectData doFX(IGenome genome, IEffectData storedData, IBeeHousing housing) {
        Level level = housing.getWorldObj();
        if (level.f_46441_.m_188499_()) {
            super.doFX(genome, storedData, housing);
        } else {
            Vec3 beeFXCoordinates = housing.getBeeFXCoordinates();
            ParticleRender.addEntityPotionFX(level, beeFXCoordinates.f_82479_, beeFXCoordinates.f_82480_ + 0.5, beeFXCoordinates.f_82481_, this.potionFXColor);
        }
        return storedData;
    }
}

