/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.genetics.effects;

import forestry.api.apiculture.IBeeHousing;
import forestry.api.genetics.IEffectData;
import forestry.api.genetics.IGenome;
import forestry.apiculture.genetics.Bee;
import forestry.apiculture.genetics.effects.ThrottledBeeEffect;
import forestry.core.genetics.EffectData;
import forestry.core.utils.VecUtil;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.Cow;
import net.minecraft.world.entity.animal.MushroomCow;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.MushroomBlock;
import net.minecraft.world.level.block.state.BlockState;

public class FungificationBeeEffect
extends ThrottledBeeEffect {
    private static final int MAX_BLOCK_FIND_TRIES = 10;
    private static final int ENTITY_THROTTLE = 6;

    public FungificationBeeEffect() {
        super(true, 20, false, false);
    }

    @Override
    public IEffectData validateStorage(IEffectData storedData) {
        EffectData data;
        if (storedData instanceof EffectData && (data = (EffectData)storedData).getIntSize() == 2) {
            return storedData;
        }
        return new EffectData(2, 0);
    }

    @Override
    public IEffectData doEffectThrottled(IGenome genome, IEffectData storedData, IBeeHousing housing) {
        this.doBlockEffect(genome, housing);
        int entityThrottle = storedData.getInteger(1);
        if (entityThrottle >= 6) {
            FungificationBeeEffect.doEntityEffect(genome, housing);
            entityThrottle = 0;
        } else {
            ++entityThrottle;
        }
        storedData.setInteger(1, entityThrottle);
        return storedData;
    }

    private void doBlockEffect(IGenome genome, IBeeHousing housing) {
        Level world = housing.getWorldObj();
        BlockPos housingCoordinates = housing.getCoordinates();
        Vec3i area = Bee.getParticleArea(genome, housing);
        Vec3i halfArea = new Vec3i(area.m_123341_() / 2, area.m_123342_() / 2, area.m_123343_() / 2);
        for (int attempt = 0; attempt < 10; ++attempt) {
            BlockPos pos = VecUtil.getRandomPositionInArea(world.f_46441_, area).m_121996_(halfArea).m_121955_((Vec3i)housingCoordinates);
            if (!world.m_46805_(pos)) continue;
            BlockState blockState = world.m_8055_(pos);
            if (FungificationBeeEffect.convertToMycelium(world, blockState, pos)) {
                return;
            }
            if (!FungificationBeeEffect.growGiantMushroom((ServerLevel)world, blockState, pos)) continue;
            return;
        }
    }

    private static void doEntityEffect(IGenome genome, IBeeHousing housing) {
        List<Cow> cows = ThrottledBeeEffect.getEntitiesInRange(genome, housing, Cow.class);
        for (Cow cow : cows) {
            if (!FungificationBeeEffect.convertCowToMooshroom(cow)) continue;
            return;
        }
    }

    private static boolean convertToMycelium(Level world, BlockState blockState, BlockPos pos) {
        Block block = blockState.m_60734_();
        if (block == Blocks.f_50440_ || block == Blocks.f_50493_ && world.m_46861_(pos)) {
            world.m_46597_(pos, Blocks.f_50195_.m_49966_());
            return true;
        }
        return false;
    }

    private static boolean growGiantMushroom(ServerLevel world, BlockState blockState, BlockPos pos) {
        Block block = blockState.m_60734_();
        if (block instanceof MushroomBlock) {
            MushroomBlock mushroom = (MushroomBlock)block;
            mushroom.m_221773_(world, pos, blockState, world.f_46441_);
            return true;
        }
        return false;
    }

    private static boolean convertCowToMooshroom(Cow cow) {
        if (cow instanceof MushroomCow) {
            return false;
        }
        Level world = cow.m_9236_();
        cow.m_146870_();
        MushroomCow mooshroom = new MushroomCow(EntityType.f_20504_, world);
        mooshroom.m_7678_(cow.m_20185_(), cow.m_20186_(), cow.m_20189_(), cow.m_146908_(), cow.m_146909_());
        mooshroom.m_21153_(cow.m_21223_());
        mooshroom.f_20883_ = cow.f_20883_;
        world.m_7967_((Entity)mooshroom);
        world.m_7106_((ParticleOptions)ParticleTypes.f_123813_, cow.m_20185_(), cow.m_20186_() + (double)(cow.m_20206_() / 2.0f), cow.m_20189_(), 0.0, 0.0, 0.0);
        return true;
    }
}

