/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture;

import forestry.api.apiculture.IBeeHousing;
import forestry.api.apiculture.IFlowerType;
import forestry.api.apiculture.genetics.IBee;
import forestry.api.core.INbtReadable;
import forestry.api.core.INbtWritable;
import forestry.api.genetics.IGenome;
import forestry.api.genetics.alleles.BeeChromosomes;
import forestry.api.util.TickHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class HasFlowersCache
implements INbtWritable,
INbtReadable {
    private static final String NBT_KEY = "hasFlowerCache";
    private static final String NBT_KEY_FLOWERS = "flowers";
    private final int flowerCheckInterval;
    private final TickHelper tickHelper = new TickHelper(0);
    @Nullable
    private FlowerData flowerData;
    private final ArrayList<BlockPos> flowerCoords = new ArrayList();
    private final List<BlockState> flowers = new ArrayList<BlockState>();
    private boolean needsSync = false;

    public HasFlowersCache() {
        this.flowerCheckInterval = 200;
    }

    public HasFlowersCache(int checkInterval) {
        this.flowerCheckInterval = checkInterval;
    }

    public void update(IBee queen, IBeeHousing beeHousing) {
        int flowerCount;
        int ticksPerCheck;
        if (this.flowerData == null) {
            this.flowerData = new FlowerData(queen, beeHousing);
            this.flowerCoords.clear();
            this.flowers.clear();
        }
        Level level = beeHousing.getWorldObj();
        this.tickHelper.onTick();
        if (!this.flowerCoords.isEmpty() && this.tickHelper.updateOnInterval(this.flowerCheckInterval)) {
            Iterator<BlockPos> iterator = this.flowerCoords.iterator();
            while (iterator.hasNext()) {
                BlockPos flowerPos = iterator.next();
                if (!level.m_46805_(flowerPos) || this.flowerData.flowerType.isAcceptableFlower(level, flowerPos)) continue;
                iterator.remove();
                this.flowers.clear();
                this.needsSync = true;
            }
        }
        if (this.tickHelper.updateOnInterval(ticksPerCheck = 1 + (flowerCount = this.flowerCoords.size()) * flowerCount)) {
            if (this.flowerData.areaIterator.hasNext()) {
                BlockPos.MutableBlockPos blockPos = this.flowerData.areaIterator.next();
                if (this.flowerData.flowerType.isAcceptableFlower(level, (BlockPos)blockPos)) {
                    this.addFlowerPos(blockPos.m_7949_());
                }
            } else {
                this.flowerData.resetIterator(queen, beeHousing);
            }
        }
    }

    public boolean hasFlowers() {
        return !this.flowerCoords.isEmpty();
    }

    public boolean needsSync() {
        boolean returnVal = this.needsSync;
        this.needsSync = false;
        return returnVal;
    }

    public void onNewQueen(IBee queen, IBeeHousing housing) {
        IGenome genome;
        IFlowerType flowerType;
        if (!(this.flowerData == null || this.flowerData.flowerType == (flowerType = (genome = queen.getGenome()).getActiveValue(BeeChromosomes.FLOWER_TYPE)) && this.flowerData.territory.equals((Object)genome.getActiveValue(BeeChromosomes.TERRITORY)))) {
            this.flowerData = new FlowerData(queen, housing);
            this.flowerCoords.clear();
            this.flowers.clear();
        }
    }

    public List<BlockPos> getFlowerCoords() {
        return Collections.unmodifiableList(this.flowerCoords);
    }

    public List<BlockState> getFlowers(Level level) {
        if (this.flowers.isEmpty() && !this.flowerCoords.isEmpty()) {
            for (BlockPos flowerCoord : this.flowerCoords) {
                BlockState blockState = level.m_8055_(flowerCoord);
                this.flowers.add(blockState);
            }
        }
        return Collections.unmodifiableList(this.flowers);
    }

    public void addFlowerPos(BlockPos blockPos) {
        this.flowerCoords.add(blockPos);
        this.flowers.clear();
        this.needsSync = true;
    }

    public void forceLookForFlowers(IBee queen, IBeeHousing housing) {
        if (this.flowerData != null) {
            this.flowerCoords.clear();
            this.flowers.clear();
            this.flowerData.resetIterator(queen, housing);
            Level level = housing.getWorldObj();
            while (this.flowerData.areaIterator.hasNext()) {
                BlockPos.MutableBlockPos blockPos = this.flowerData.areaIterator.next();
                if (!this.flowerData.flowerType.isAcceptableFlower(level, (BlockPos)blockPos)) continue;
                this.addFlowerPos(blockPos.m_7949_());
            }
        }
    }

    @Override
    public void read(CompoundTag compoundNBT) {
        int[] flowersList;
        if (!compoundNBT.m_128441_(NBT_KEY)) {
            return;
        }
        CompoundTag hasFlowerCacheNBT = compoundNBT.m_128469_(NBT_KEY);
        this.flowerCoords.clear();
        if (hasFlowerCacheNBT.m_128441_(NBT_KEY_FLOWERS) && (flowersList = hasFlowerCacheNBT.m_128465_(NBT_KEY_FLOWERS)).length % 3 == 0) {
            int flowerCount = flowersList.length / 3;
            this.flowerCoords.ensureCapacity(flowerCount);
            for (int i = 0; i < flowerCount; ++i) {
                int index = i * 3;
                BlockPos flowerPos = new BlockPos(flowersList[index], flowersList[index + 1], flowersList[index + 2]);
                this.flowerCoords.add(flowerPos);
            }
            this.needsSync = true;
        }
        this.flowers.clear();
    }

    @Override
    public CompoundTag write(CompoundTag CompoundNBT) {
        CompoundTag hasFlowerCacheNBT = new CompoundTag();
        if (!this.flowerCoords.isEmpty()) {
            int[] flowersList = new int[this.flowerCoords.size() * 3];
            int i = 0;
            for (BlockPos flowerPos : this.flowerCoords) {
                flowersList[i] = flowerPos.m_123341_();
                flowersList[i + 1] = flowerPos.m_123342_();
                flowersList[i + 2] = flowerPos.m_123343_();
                i += 3;
            }
            hasFlowerCacheNBT.m_128385_(NBT_KEY_FLOWERS, flowersList);
        }
        CompoundNBT.m_128365_(NBT_KEY, (Tag)hasFlowerCacheNBT);
        return CompoundNBT;
    }

    public void writeData(FriendlyByteBuf data) {
        int size = this.flowerCoords.size();
        data.m_130130_(size);
        if (size > 0) {
            for (BlockPos pos : this.flowerCoords) {
                data.m_130130_(pos.m_123341_());
                data.m_130130_(pos.m_123342_());
                data.m_130130_(pos.m_123343_());
            }
        }
    }

    public void readData(FriendlyByteBuf data) {
        this.flowerCoords.clear();
        this.flowers.clear();
        for (int size = data.m_130242_(); size > 0; --size) {
            BlockPos pos = new BlockPos(data.m_130242_(), data.m_130242_(), data.m_130242_());
            this.flowerCoords.add(pos);
        }
    }

    private static class FlowerData {
        public final IFlowerType flowerType;
        public final Vec3i territory;
        public Iterator<BlockPos.MutableBlockPos> areaIterator;

        public FlowerData(IBee queen, IBeeHousing housing) {
            this.flowerType = queen.getGenome().getActiveValue(BeeChromosomes.FLOWER_TYPE);
            this.territory = queen.getGenome().getActiveValue(BeeChromosomes.TERRITORY);
            this.areaIterator = queen.getAreaIterator(housing);
        }

        public void resetIterator(IBee queen, IBeeHousing beeHousing) {
            this.areaIterator = queen.getAreaIterator(beeHousing);
        }
    }
}

