/*
 * Decompiled with CFR 0.152.
 */
package forestry.api.apiculture.genetics;

import forestry.api.apiculture.IBeeHousing;
import forestry.api.apiculture.genetics.IBeeSpecies;
import forestry.api.apiculture.genetics.IBeeSpeciesType;
import forestry.api.core.IError;
import forestry.api.genetics.IEffectData;
import forestry.api.genetics.IGenome;
import forestry.api.genetics.IIndividualLiving;
import forestry.api.genetics.pollen.IPollen;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public interface IBee
extends IIndividualLiving {
    public boolean isPristine();

    public int getGeneration();

    public void setPristine(boolean var1);

    public IEffectData[] doEffect(IEffectData[] var1, IBeeHousing var2);

    @OnlyIn(value=Dist.CLIENT)
    public IEffectData[] doFX(IEffectData[] var1, IBeeHousing var2);

    public Set<IError> getCanWork(IBeeHousing var1);

    public List<Holder.Reference<Biome>> getSuitableBiomes(Registry<Biome> var1);

    public List<ItemStack> getProduceList();

    public List<ItemStack> getSpecialtyList();

    public List<ItemStack> produceStacks(IBeeHousing var1);

    @Nullable
    public IBee spawnPrincess(IBeeHousing var1);

    public List<IBee> spawnDrones(IBeeHousing var1);

    @Nullable
    public BlockPos plantFlowerRandom(IBeeHousing var1, List<BlockState> var2);

    @Nullable
    public IPollen<?> retrievePollen(IBeeHousing var1);

    public boolean pollinateRandom(IBeeHousing var1, IPollen<?> var2);

    public Iterator<BlockPos.MutableBlockPos> getAreaIterator(IBeeHousing var1);

    @Override
    public IBee copy();

    @Override
    public IBee copyWithGenome(IGenome var1);

    public IBeeSpeciesType getType();

    public IBeeSpecies getSpecies();

    public IBeeSpecies getInactiveSpecies();
}

