/*
 * Decompiled with CFR 0.152.
 */
package com.kyanite.deeperdarker;

import com.kyanite.deeperdarker.DeeperDarker;
import com.kyanite.deeperdarker.DeeperDarkerConfig;
import com.kyanite.deeperdarker.client.Keybinds;
import com.kyanite.deeperdarker.client.model.AnglerFishModel;
import com.kyanite.deeperdarker.client.model.SculkCentipedeModel;
import com.kyanite.deeperdarker.client.model.SculkLeechModel;
import com.kyanite.deeperdarker.client.model.SculkSnapperModel;
import com.kyanite.deeperdarker.client.model.ShatteredModel;
import com.kyanite.deeperdarker.client.model.ShriekWormModel;
import com.kyanite.deeperdarker.client.model.SludgeModel;
import com.kyanite.deeperdarker.client.model.StalkerModel;
import com.kyanite.deeperdarker.client.model.WardenHelmetModel;
import com.kyanite.deeperdarker.client.render.AnglerFishRenderer;
import com.kyanite.deeperdarker.client.render.CrystallizedAmberBlockRenderer;
import com.kyanite.deeperdarker.client.render.DDBoatRenderer;
import com.kyanite.deeperdarker.client.render.SculkCentipedeRenderer;
import com.kyanite.deeperdarker.client.render.SculkLeechRenderer;
import com.kyanite.deeperdarker.client.render.SculkSnapperRenderer;
import com.kyanite.deeperdarker.client.render.ShatteredRenderer;
import com.kyanite.deeperdarker.client.render.ShriekWormRenderer;
import com.kyanite.deeperdarker.client.render.SludgeOuterLayer;
import com.kyanite.deeperdarker.client.render.SludgeRenderer;
import com.kyanite.deeperdarker.client.render.SoulElytraRenderer;
import com.kyanite.deeperdarker.client.render.StalkerRenderer;
import com.kyanite.deeperdarker.client.render.WardenHelmetRenderer;
import com.kyanite.deeperdarker.content.DDBlockEntities;
import com.kyanite.deeperdarker.content.DDBlocks;
import com.kyanite.deeperdarker.content.DDEntities;
import com.kyanite.deeperdarker.content.DDItems;
import com.kyanite.deeperdarker.content.blocks.AncientVaseBlock;
import com.kyanite.deeperdarker.content.blocks.CrystallizedAmberBlock;
import com.kyanite.deeperdarker.content.blocks.entity.CrystallizedAmberBlockEntity;
import com.kyanite.deeperdarker.content.blocks.vegetation.IceLilyBlock;
import com.kyanite.deeperdarker.content.items.ResonariumArmorItem;
import com.kyanite.deeperdarker.content.items.SculkTransmitterItem;
import com.kyanite.deeperdarker.content.items.SoulElytraItem;
import com.kyanite.deeperdarker.network.Messages;
import com.kyanite.deeperdarker.network.SoulElytraBoostPacket;
import com.kyanite.deeperdarker.network.SoulElytraClientPacket;
import com.kyanite.deeperdarker.network.UseTransmitterPacket;
import com.kyanite.deeperdarker.util.DDTags;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.client.model.BoatModel;
import net.minecraft.client.model.ChestBoatModel;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderers;
import net.minecraft.client.renderer.blockentity.HangingSignRenderer;
import net.minecraft.client.renderer.blockentity.SignRenderer;
import net.minecraft.client.renderer.entity.ArmorStandRenderer;
import net.minecraft.client.renderer.entity.EntityRenderers;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.inventory.AnvilMenu;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.event.AnvilUpdateEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingEquipmentChangeEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.network.PacketDistributor;

@Mod.EventBusSubscriber(modid="deeperdarker")
public class DeeperDarkerEvents {
    @SubscribeEvent
    public static void breakEvent(BlockEvent.BreakEvent event) {
        BlockEntity blockEntity;
        boolean silktouch = event.getPlayer().m_21205_().getEnchantmentLevel(Enchantments.f_44985_) > 0;
        Level level = (Level)event.getLevel();
        BlockState state = event.getState();
        BlockPos pos = event.getPos();
        if (state.m_60713_((Block)DDBlocks.CRYSTALLIZED_AMBER.get()) && (blockEntity = level.m_7702_(pos)) instanceof CrystallizedAmberBlockEntity) {
            CrystallizedAmberBlockEntity blockEntity2 = (CrystallizedAmberBlockEntity)blockEntity;
            if (!silktouch && ((Boolean)state.m_61143_((Property)CrystallizedAmberBlock.FOSSILIZED)).booleanValue()) {
                if (blockEntity2.fossilizedEntity && level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    ((EntityType)DDEntities.SCULK_LEECH.get()).m_262496_(serverLevel, pos, MobSpawnType.TRIGGERED);
                } else {
                    Block.m_49840_((Level)level, (BlockPos)pos, (ItemStack)blockEntity2.getLoot());
                }
            } else if (silktouch && !level.m_5776_() && ((Boolean)state.m_61143_((Property)CrystallizedAmberBlock.FOSSILIZED)).booleanValue()) {
                CompoundTag tag = new CompoundTag();
                tag.m_128365_("item", (Tag)blockEntity2.getLoot().m_41739_(new CompoundTag()));
                tag.m_128379_("leech", blockEntity2.fossilizedEntity);
                ItemStack stack = new ItemStack((ItemLike)DDBlocks.CRYSTALLIZED_AMBER.get());
                BlockItem.m_186338_((ItemStack)stack, (BlockEntityType)((BlockEntityType)DDBlockEntities.CRYSTALLIZED_AMBER.get()), (CompoundTag)tag);
                Block.m_49840_((Level)level, (BlockPos)pos, (ItemStack)stack);
                level.m_7731_(pos, Blocks.f_50016_.m_49966_(), 3);
                event.setCanceled(true);
            }
            return;
        }
        if (silktouch) {
            return;
        }
        if (state.m_60713_((Block)DDBlocks.ICE_LILY.get())) {
            if (((Boolean)state.m_61143_((Property)IceLilyBlock.HAS_FLOWER)).booleanValue()) {
                return;
            }
            CompoundTag tag = new CompoundTag();
            tag.m_128379_("has_flower", false);
            ItemStack stack = new ItemStack((ItemLike)DDBlocks.ICE_LILY.get());
            stack.m_41751_(tag);
            Block.m_49840_((Level)level, (BlockPos)pos, (ItemStack)stack);
            level.m_7731_(pos, Blocks.f_50016_.m_49966_(), 3);
            event.setCanceled(true);
        }
        if (state.m_60713_((Block)DDBlocks.ANCIENT_VASE.get()) && level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            RandomSource random = serverLevel.m_213780_();
            if (level.m_46791_() != Difficulty.PEACEFUL && !((Boolean)state.m_61143_((Property)AncientVaseBlock.SAFE)).booleanValue() && random.m_188500_() < DeeperDarkerConfig.fakeVaseChance) {
                if (random.m_188500_() < 1.0 - DeeperDarkerConfig.stalkerSpawnChance) {
                    for (int i = 0; i < random.m_216339_(1, 4); ++i) {
                        ((EntityType)DDEntities.SCULK_LEECH.get()).m_262496_(serverLevel, pos, MobSpawnType.TRIGGERED);
                    }
                } else {
                    ((EntityType)DDEntities.STALKER.get()).m_262496_(serverLevel, pos, MobSpawnType.TRIGGERED);
                }
                serverLevel.m_7731_(pos, Blocks.f_50016_.m_49966_(), 3);
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void livingDamageEvent(LivingDamageEvent event) {
        if (event.getSource().m_269533_(DamageTypeTags.f_268490_)) {
            return;
        }
        LivingEntity entity = event.getEntity();
        float incoming = event.getAmount();
        float reduction = incoming / 4.0f;
        for (ItemStack stack : entity.m_6168_()) {
            Item item = stack.m_41720_();
            if (!(item instanceof ArmorItem)) continue;
            ArmorItem armor = (ArmorItem)item;
            if (!stack.m_204117_(DDTags.Items.RESONARIUM_ARMOR)) continue;
            incoming -= reduction;
            stack.m_41622_((int)event.getAmount(), entity, living -> living.m_21166_(armor.m_40402_()));
        }
        event.setAmount(incoming);
    }

    @SubscribeEvent
    public static void equipmentChangeEvent(LivingEquipmentChangeEvent event) {
        if (!event.getSlot().m_254934_()) {
            return;
        }
        if (!event.getTo().m_150930_((Item)DDItems.SOUL_ELYTRA.get()) || event.getFrom().m_150930_((Item)DDItems.SOUL_ELYTRA.get())) {
            return;
        }
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)livingEntity;
            Messages.INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), (Object)new SoulElytraClientPacket());
        }
    }

    @SubscribeEvent
    public static void anvilEvent(AnvilUpdateEvent event) {
        ItemStack input = event.getLeft();
        ItemStack addition = event.getRight();
        if (!(input.m_41720_() instanceof ResonariumArmorItem)) {
            return;
        }
        if (addition.m_150930_((Item)DDItems.RESONARIUM.get())) {
            ItemStack output = input.m_41777_();
            int diff = Math.min(output.m_41773_(), output.m_41776_() / 4);
            int cost = 0;
            for (int i = 0; diff > 0 && i < addition.m_41613_(); ++i) {
                int damage = output.m_41773_() - diff;
                output.m_41721_(damage);
                diff = Math.min(damage, output.m_41776_() / 4);
                ++cost;
            }
            event.setOutput(output);
            event.setCost(DeeperDarkerEvents.nameCost(event.getName(), input, cost, output));
            return;
        }
        if (!addition.m_150930_(Items.f_42690_)) {
            return;
        }
        boolean client = event.getPlayer().m_9236_().f_46443_;
        Map inputEnchants = EnchantmentHelper.m_44831_((ItemStack)input);
        Map bookEnchants = EnchantmentHelper.m_44831_((ItemStack)addition);
        HashMap<Enchantment, Integer> finalEnchants = new HashMap<Enchantment, Integer>(inputEnchants);
        int cost = 0;
        boolean noChange = true;
        for (Enchantment enchantment : bookEnchants.keySet()) {
            int level = (Integer)bookEnchants.get(enchantment);
            int existingLevel = inputEnchants.get(enchantment) == null ? 0 : (Integer)inputEnchants.get(enchantment);
            level = level == existingLevel ? level + 1 : Math.max(level, existingLevel);
            level = Math.min(level, enchantment.m_6586_());
            if (!enchantment.m_6081_(input)) continue;
            finalEnchants.put(enchantment, level);
            int anvilCost = switch (enchantment.m_44699_()) {
                default -> throw new IncompatibleClassChangeError();
                case Enchantment.Rarity.COMMON -> 1;
                case Enchantment.Rarity.UNCOMMON -> 2;
                case Enchantment.Rarity.RARE -> 4;
                case Enchantment.Rarity.VERY_RARE -> 8;
            };
            cost += anvilCost * level;
            noChange = false;
        }
        if (noChange) {
            event.setCanceled(true);
            return;
        }
        int inputRepair = input.m_41610_();
        int additionRepair = addition.m_41610_();
        int newRepairCost = AnvilMenu.m_39025_((int)Math.max(inputRepair, additionRepair));
        cost += inputRepair + additionRepair;
        ItemStack output = input.m_41777_();
        output.m_41742_(newRepairCost);
        EnchantmentHelper.m_44865_(finalEnchants, (ItemStack)output);
        cost = DeeperDarkerEvents.nameCost(event.getName(), input, cost, output);
        event.setOutput(output);
        event.setCost(cost / 2);
    }

    private static int nameCost(String name, ItemStack input, int cost, ItemStack output) {
        if (name != null && !Util.m_288217_((String)name)) {
            if (!name.equals(input.m_41786_().getString())) {
                ++cost;
                output.m_41714_((Component)Component.m_237113_((String)name));
            }
        } else if (input.m_41788_()) {
            ++cost;
            output.m_41787_();
        }
        return cost;
    }

    @Mod.EventBusSubscriber(modid="deeperdarker", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
    public static class ForgeClientEvents {
        @SubscribeEvent
        public static void keyInput(InputEvent.Key event) {
            if (Keybinds.BOOST.m_90859_()) {
                Messages.INSTANCE.sendToServer((Object)new SoulElytraBoostPacket());
            }
            if (Keybinds.TRANSMIT.m_90859_()) {
                Messages.INSTANCE.sendToServer((Object)new UseTransmitterPacket());
            }
        }
    }

    @Mod.EventBusSubscriber(modid="deeperdarker", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientEvents {
        @SubscribeEvent
        public static void clientSetup(FMLClientSetupEvent event) {
            event.enqueueWork(() -> {
                Sheets.addWoodType((WoodType)DDBlocks.ECHO);
                Sheets.addWoodType((WoodType)DDBlocks.BLOOM);
                ItemProperties.register((Item)((Item)DDItems.SOUL_ELYTRA.get()), (ResourceLocation)new ResourceLocation("broken"), (pStack, pLevel, pEntity, pSeed) -> SoulElytraItem.m_41140_((ItemStack)pStack) ? 0.0f : 1.0f);
                ItemProperties.register((Item)((Item)DDItems.SCULK_TRANSMITTER.get()), (ResourceLocation)DeeperDarker.rl("linked"), (pStack, pLevel, pEntity, pSeed) -> SculkTransmitterItem.isLinked(pStack) ? 1.0f : 0.0f);
                ItemProperties.register((Item)((Item)DDItems.SONOROUS_STAFF.get()), (ResourceLocation)DeeperDarker.rl("charge"), (pStack, pLevel, pEntity, pSeed) -> pEntity != null && pEntity.m_21211_() == pStack ? (float)(pStack.m_41779_() - pEntity.m_21212_()) / 123.0f : 0.0f);
            });
            BlockEntityRenderers.m_173590_((BlockEntityType)((BlockEntityType)DDBlockEntities.DEEPER_DARKER_SIGNS.get()), SignRenderer::new);
            BlockEntityRenderers.m_173590_((BlockEntityType)((BlockEntityType)DDBlockEntities.DEEPER_DARKER_HANGING_SIGNS.get()), HangingSignRenderer::new);
            EntityRenderers.m_174036_((EntityType)((EntityType)DDEntities.BOAT.get()), context -> new DDBoatRenderer(context, false));
            EntityRenderers.m_174036_((EntityType)((EntityType)DDEntities.CHEST_BOAT.get()), context -> new DDBoatRenderer(context, true));
            EntityRenderers.m_174036_((EntityType)((EntityType)DDEntities.ANGLER_FISH.get()), AnglerFishRenderer::new);
            EntityRenderers.m_174036_((EntityType)((EntityType)DDEntities.SCULK_CENTIPEDE.get()), SculkCentipedeRenderer::new);
            EntityRenderers.m_174036_((EntityType)((EntityType)DDEntities.SCULK_LEECH.get()), SculkLeechRenderer::new);
            EntityRenderers.m_174036_((EntityType)((EntityType)DDEntities.SCULK_SNAPPER.get()), SculkSnapperRenderer::new);
            EntityRenderers.m_174036_((EntityType)((EntityType)DDEntities.SHATTERED.get()), ShatteredRenderer::new);
            EntityRenderers.m_174036_((EntityType)((EntityType)DDEntities.SHRIEK_WORM.get()), ShriekWormRenderer::new);
            EntityRenderers.m_174036_((EntityType)((EntityType)DDEntities.SLUDGE.get()), SludgeRenderer::new);
            EntityRenderers.m_174036_((EntityType)((EntityType)DDEntities.STALKER.get()), StalkerRenderer::new);
        }

        @SubscribeEvent
        public static void registerKeybinds(RegisterKeyMappingsEvent event) {
            event.register(Keybinds.BOOST);
            event.register(Keybinds.TRANSMIT);
        }

        @SubscribeEvent
        public static void registerRenderers(EntityRenderersEvent.RegisterRenderers event) {
            event.registerBlockEntityRenderer((BlockEntityType)DDBlockEntities.CRYSTALLIZED_AMBER.get(), CrystallizedAmberBlockRenderer::new);
        }

        @SubscribeEvent
        public static void registerLayers(EntityRenderersEvent.RegisterLayerDefinitions event) {
            event.registerLayerDefinition(DDBoatRenderer.ECHO_BOAT_MODEL, BoatModel::m_246613_);
            event.registerLayerDefinition(DDBoatRenderer.ECHO_CHEST_BOAT_MODEL, ChestBoatModel::m_247175_);
            event.registerLayerDefinition(DDBoatRenderer.BLOOM_BOAT_MODEL, BoatModel::m_246613_);
            event.registerLayerDefinition(DDBoatRenderer.BLOOM_CHEST_BOAT_MODEL, ChestBoatModel::m_247175_);
            event.registerLayerDefinition(AnglerFishRenderer.MODEL, AnglerFishModel::createBodyModel);
            event.registerLayerDefinition(SculkCentipedeRenderer.MODEL, SculkCentipedeModel::createBodyModel);
            event.registerLayerDefinition(SculkLeechRenderer.MODEL, SculkLeechModel::createBodyModel);
            event.registerLayerDefinition(SculkSnapperRenderer.MODEL, SculkSnapperModel::createBodyModel);
            event.registerLayerDefinition(ShatteredRenderer.MODEL, ShatteredModel::createBodyModel);
            event.registerLayerDefinition(ShriekWormRenderer.MODEL, ShriekWormModel::createBodyModel);
            event.registerLayerDefinition(SludgeRenderer.MODEL, SludgeModel::createInnerBodyModel);
            event.registerLayerDefinition(SludgeOuterLayer.OUTER_MODEL, SludgeModel::createOuterBodyModel);
            event.registerLayerDefinition(StalkerRenderer.MODEL, StalkerModel::createBodyModel);
            event.registerLayerDefinition(WardenHelmetRenderer.MODEL, WardenHelmetModel::createBodyModel);
        }

        @SubscribeEvent
        public static void addLayers(EntityRenderersEvent.AddLayers event) {
            event.getSkins().forEach(name -> {
                LivingEntityRenderer patt15930$temp = event.getSkin(name);
                if (patt15930$temp instanceof PlayerRenderer) {
                    PlayerRenderer renderer = (PlayerRenderer)patt15930$temp;
                    renderer.m_115326_(new SoulElytraRenderer(renderer, event.getEntityModels()));
                    renderer.m_115326_(new WardenHelmetRenderer(renderer, event.getEntityModels()));
                }
            });
            LivingEntityRenderer livingEntityRenderer = event.getRenderer(EntityType.f_20529_);
            if (livingEntityRenderer instanceof ArmorStandRenderer) {
                ArmorStandRenderer renderer = (ArmorStandRenderer)livingEntityRenderer;
                renderer.m_115326_(new SoulElytraRenderer(renderer, event.getEntityModels()));
                renderer.m_115326_(new WardenHelmetRenderer(renderer, event.getEntityModels()));
            }
        }
    }
}

