/*
 * Decompiled with CFR 0.152.
 */
package com.jesz.createdieselgenerators.world;

import com.jesz.createdieselgenerators.CDGConfig;
import com.jesz.createdieselgenerators.CreateDieselGenerators;
import com.jesz.createdieselgenerators.compat.kubejs.CDGKubeJSPlugin;
import com.simibubi.create.AllTags;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.createmod.catnip.nbt.NBTHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public class OilChunksSavedData
extends SavedData {
    Map<ChunkPos, Integer> chunks = new HashMap<ChunkPos, Integer>();

    public CompoundTag m_7176_(CompoundTag compound) {
        ListTag lt = new ListTag();
        this.chunks.forEach((pos, amount) -> {
            CompoundTag c = new CompoundTag();
            c.m_128365_("x", (Tag)IntTag.m_128679_((int)pos.f_45578_));
            c.m_128365_("z", (Tag)IntTag.m_128679_((int)pos.f_45579_));
            c.m_128365_("Amount", (Tag)IntTag.m_128679_((int)amount));
            lt.add((Object)c);
        });
        compound.m_128365_("OilChunks", (Tag)lt);
        return compound;
    }

    private OilChunksSavedData() {
    }

    private static OilChunksSavedData load(CompoundTag compound) {
        OilChunksSavedData sd = new OilChunksSavedData();
        sd.chunks = new HashMap<ChunkPos, Integer>();
        NBTHelper.iterateCompoundList((ListTag)compound.m_128437_("OilChunks", 10), c -> sd.chunks.put(new ChunkPos(c.m_128451_("x"), c.m_128451_("z")), c.m_128451_("Amount")));
        return sd;
    }

    public static OilChunksSavedData load(ServerLevel level) {
        return (OilChunksSavedData)level.m_8895_().m_164861_(OilChunksSavedData::load, OilChunksSavedData::new, "cdg_oil_chunks");
    }

    public void setChunkAmount(ChunkPos chunk, int amount) {
        if (this.chunks.containsKey(chunk)) {
            this.chunks.replace(chunk, amount);
        } else {
            this.chunks.put(chunk, amount);
        }
        this.m_77762_();
    }

    public void removeChunkAmount(ChunkPos chunk) {
        this.chunks.remove(chunk);
        this.m_77762_();
    }

    public int getChunkOilAmount(ChunkPos chunk) {
        if (this.chunks.containsKey(chunk)) {
            return (Boolean)CDGConfig.OIL_DEPOSITS_INFINITE.get() != false ? Integer.MAX_VALUE : this.chunks.get(chunk);
        }
        return -1;
    }

    public static int getOilAmount(ServerLevel level, ChunkPos pos) {
        int amount;
        long seed = level.m_7328_();
        List<Holder<Biome>> biomes = OilChunksSavedData.getBiomesInChunk(level, pos);
        if (ModList.get().isLoaded("kubejs") && (amount = CDGKubeJSPlugin.calculateOilChunks(biomes, pos, seed)) != -1) {
            return amount;
        }
        Random random = new Random(new Random(seed).nextLong() + (long)pos.f_45578_ * (long)pos.f_45579_);
        int amount2 = Math.abs(random.nextInt());
        boolean isHighInOil = false;
        boolean isDenied = false;
        for (Holder<Biome> biome : biomes) {
            if (biome.m_203656_(AllTags.optionalTag((IForgeRegistry)ForgeRegistries.BIOMES, (ResourceLocation)CreateDieselGenerators.rl("oil_biomes")))) {
                isHighInOil = true;
            }
            if (!biome.m_203656_(AllTags.optionalTag((IForgeRegistry)ForgeRegistries.BIOMES, (ResourceLocation)CreateDieselGenerators.rl("deny_oil_biomes")))) continue;
            isDenied = true;
        }
        if (isDenied) {
            return 0;
        }
        if (isHighInOil ? (double)random.nextFloat(0.0f, 100.0f) >= (Double)CDGConfig.HIGH_OIL_PERCENTAGE.get() : (double)(amount2 % 100) >= (Double)CDGConfig.OIL_PERCENTAGE.get()) {
            return 0;
        }
        if (((Boolean)CDGConfig.OIL_DEPOSITS_INFINITE.get()).booleanValue()) {
            return Integer.MAX_VALUE;
        }
        if (isHighInOil) {
            return (int)((double)Mth.m_14045_((int)(amount2 % 400000), (int)8000, (int)400000) * (Double)CDGConfig.HIGH_OIL_MULTIPLIER.get());
        }
        return (int)((double)Mth.m_14045_((int)(amount2 % 15000), (int)0, (int)12000) * (Double)CDGConfig.OIL_MULTIPLIER.get());
    }

    public static List<Holder<Biome>> getBiomesInChunk(ServerLevel level, ChunkPos chunkPos) {
        ArrayList<Holder<Biome>> list = new ArrayList<Holder<Biome>>();
        for (int x = 0; x < 16; ++x) {
            for (int y = level.m_141937_(); y < level.m_151558_(); ++y) {
                for (int z = 0; z < 16; ++z) {
                    Holder biome = level.m_204166_(new BlockPos(chunkPos.f_45578_ * 16 + x, y, chunkPos.f_45579_ * 16 + z));
                    if (list.contains(biome)) continue;
                    list.add((Holder<Biome>)biome);
                }
            }
        }
        return list;
    }
}

