/*
 * Decompiled with CFR 0.152.
 */
package com.jesz.createdieselgenerators.events;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.jesz.createdieselgenerators.CDGBlockEntityTypes;
import com.jesz.createdieselgenerators.compat.kubejs.LighterSkinsEventJS;
import com.jesz.createdieselgenerators.content.canister.SpoutCanisterFilling;
import com.jesz.createdieselgenerators.content.molds.BasinSpoutCasting;
import com.jesz.createdieselgenerators.content.molds.MoldType;
import com.jesz.createdieselgenerators.content.tools.lighter.LighterModel;
import com.jesz.createdieselgenerators.content.track_layers_bag.TrackLayersBagComponent;
import com.jesz.createdieselgenerators.content.turret.TurretOperatorHatLayer;
import com.simibubi.create.AllBlockEntityTypes;
import com.simibubi.create.api.behaviour.spouting.BlockSpoutingBehaviour;
import java.io.IOException;
import java.io.Reader;
import java.util.Map;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.ModelEvent;
import net.minecraftforge.client.event.RegisterClientTooltipComponentFactoriesEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;

@Mod.EventBusSubscriber(modid="createdieselgenerators", bus=Mod.EventBusSubscriber.Bus.MOD)
public class ModEvents {
    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public static void onModelRegistry(ModelEvent.RegisterAdditional event) {
        for (MoldType type : MoldType.types) {
            event.register(type.getModelId());
        }
        LighterModel.lighterSkinIDs.clear();
        Minecraft.m_91087_().m_91098_().m_7187_().stream().toList().forEach(n -> {
            Optional resource = Minecraft.m_91087_().m_91098_().m_213713_(new ResourceLocation(n, "lighter_skins.json"));
            if (resource.isEmpty()) {
                return;
            }
            JsonParser parser = new JsonParser();
            try {
                JsonElement data = parser.parse((Reader)((Resource)resource.get()).m_215508_());
                data.getAsJsonArray().forEach(jsonElement -> LighterModel.lighterSkinIDs.put(jsonElement.getAsJsonObject().getAsJsonPrimitive("name").getAsString(), jsonElement.getAsJsonObject().getAsJsonPrimitive("id").getAsString()));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        });
        if (ModList.get().isLoaded("kubejs")) {
            LighterModel.lighterSkinIDs.putAll(LighterSkinsEventJS.addedIds);
            LighterSkinsEventJS.removedIds.forEach((name, id) -> LighterModel.lighterSkinIDs.remove(name, id));
        }
        LighterModel.initSkins();
        LighterModel.onModelRegistry(event);
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public static void registerClientTooltips(RegisterClientTooltipComponentFactoriesEvent event) {
        event.register(TrackLayersBagComponent.class, c -> c);
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public static void addEntityRendererLayers(EntityRenderersEvent.AddLayers event) {
        EntityRenderDispatcher dispatcher = Minecraft.m_91087_().m_91290_();
        TurretOperatorHatLayer.registerOnAll(dispatcher);
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public static void onModelBake(ModelEvent.BakingCompleted event) {
        Map models = event.getModels();
        for (MoldType type : MoldType.types) {
            type.model = (BakedModel)models.get(type.getModelId());
        }
    }

    @SubscribeEvent
    public static void setup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            BlockSpoutingBehaviour.BY_BLOCK_ENTITY.register((Object)((BlockEntityType)CDGBlockEntityTypes.CANISTER.get()), (Object)new SpoutCanisterFilling());
            BlockSpoutingBehaviour.BY_BLOCK_ENTITY.register((Object)((BlockEntityType)AllBlockEntityTypes.BASIN.get()), (Object)new BasinSpoutCasting());
        });
    }
}

