/*
 * Decompiled with CFR 0.152.
 */
package com.jesz.createdieselgenerators.content.turret;

import com.jesz.createdieselgenerators.compat.computercraft.CCProxy;
import com.jesz.createdieselgenerators.content.tools.ChemicalSprayerProjectileEntity;
import com.jesz.createdieselgenerators.content.turret.TurretBlockEntity;
import com.jesz.createdieselgenerators.fuel_type.FuelTypeManager;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.compat.computercraft.AbstractComputerBehaviour;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueBoxTransform;
import com.simibubi.create.foundation.blockEntity.behaviour.fluid.SmartFluidTankBehaviour;
import java.util.List;
import java.util.Random;
import net.createmod.catnip.math.VecHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class ChemicalTurretBlockEntity
extends TurretBlockEntity {
    public boolean lighterUpgrade = false;
    public SmartFluidTankBehaviour tank;
    public AbstractComputerBehaviour computerBehaviour;
    public int redstoneSignal;

    public ChemicalTurretBlockEntity(BlockEntityType<?> typeIn, BlockPos pos, BlockState state) {
        super(typeIn, pos, state);
    }

    public float calculateStressApplied() {
        return 4.0f;
    }

    protected AABB createRenderBoundingBox() {
        return super.createRenderBoundingBox().m_82400_(2.0);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (this.computerBehaviour.isPeripheralCap(cap)) {
            return this.computerBehaviour.getPeripheralCapability();
        }
        if (side == Direction.DOWN) {
            return this.tank.getCapability().cast();
        }
        return LazyOptional.empty();
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        super.addToGoggleTooltip(tooltip, isPlayerSneaking);
        return this.containedFluidTooltip(tooltip, isPlayerSneaking, this.tank.getCapability().cast());
    }

    @Override
    public void tick() {
        super.tick();
        if (this.redstoneSignal != 0) {
            this.shootFluids();
        }
        if (this.targetedEntity == null) {
            return;
        }
        if (Math.abs(this.targetedHorizontalRotation - this.horizontalRotation) % 360.0f <= 4.0f || Math.abs(this.targetedHorizontalRotation - this.horizontalRotation) % 360.0f >= 356.0f) {
            this.shootFluids();
        }
    }

    @Override
    protected void read(CompoundTag compound, boolean clientPacket) {
        super.read(compound, clientPacket);
        this.lighterUpgrade = compound.m_128471_("LighterUpgrade");
        this.redstoneSignal = compound.m_128451_("RedstoneSignal");
    }

    @Override
    protected void write(CompoundTag compound, boolean clientPacket) {
        super.write(compound, clientPacket);
        compound.m_128379_("LighterUpgrade", this.lighterUpgrade);
        compound.m_128405_("RedstoneSignal", this.redstoneSignal);
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        this.computerBehaviour = CCProxy.behaviour((SmartBlockEntity)this);
        behaviours.add((BlockEntityBehaviour)this.computerBehaviour);
        this.tank = SmartFluidTankBehaviour.single((SmartBlockEntity)this, (int)1000);
        behaviours.add((BlockEntityBehaviour)this.tank);
        super.addBehaviours(behaviours);
    }

    public void shootFluids() {
        if (this.getSpeed() == 0.0f) {
            return;
        }
        float shootingForce = (float)Math.min(Math.abs(1.0 - Math.pow(1.0f - this.getSpeed() / 256.0f, 3.0)), 1.0);
        if (!this.f_58857_.f_46443_ && !this.tank.isEmpty()) {
            AllSoundEvents.MIXING.playOnServer(this.f_58857_, (Vec3i)this.f_58858_, 0.75f, 1.0f);
            FluidStack fluidStack = this.tank.getPrimaryHandler().getFluid().copy();
            ChemicalSprayerProjectileEntity projectile = ChemicalSprayerProjectileEntity.spray(this.f_58857_, fluidStack, FuelTypeManager.getGeneratedSpeed(fluidStack.getFluid()) != 0.0f && this.lighterUpgrade || fluidStack.getFluid().m_6212_((Fluid)Fluids.f_76195_), fluidStack.getFluid().m_6212_((Fluid)Fluids.f_76193_));
            projectile.m_146884_(Vec3.m_82512_((Vec3i)this.f_58858_).m_82520_(0.0, 0.625, 0.0));
            projectile.m_37251_((Entity)projectile, this.verticalRotation + new Random().nextFloat(-1.0f, 1.0f), (float)(Math.atan2(Math.sin((double)(this.horizontalRotation / 180.0f) * Math.PI), -Math.cos((double)(this.horizontalRotation / 180.0f) * Math.PI)) * 180.0 / Math.PI) + new Random().nextFloat(-1.0f, 1.0f), 0.0f, 0.2f + shootingForce, 0.0f);
            this.f_58857_.m_7967_((Entity)projectile);
            if (this.t == 1) {
                this.tank.getPrimaryHandler().drain(3, IFluidHandler.FluidAction.EXECUTE);
            }
        }
    }

    public static class ChemicalTurretValueBox
    extends ValueBoxTransform.Sided {
        protected Vec3 getSouthLocation() {
            return VecHelper.voxelSpace((double)8.0, (double)3.0, (double)16.05);
        }

        protected boolean isSideActive(BlockState state, Direction direction) {
            return direction.m_122434_().m_122479_();
        }
    }
}

