/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.item;

import com.simibubi.create.foundation.blockEntity.behaviour.filtering.FilteringBehaviour;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import net.createmod.catnip.data.IntAttached;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class CountedItemStackList {
    Map<Item, Set<ItemStackEntry>> items = new HashMap<Item, Set<ItemStackEntry>>();

    public CountedItemStackList(IItemHandler inventory, FilteringBehaviour filteringBehaviour) {
        for (int slot = 0; slot < inventory.getSlots(); ++slot) {
            ItemStack extractItem = inventory.getStackInSlot(slot);
            if (!filteringBehaviour.test(extractItem)) continue;
            this.add(extractItem);
        }
    }

    public Stream<IntAttached<MutableComponent>> getTopNames(int limit) {
        return this.items.values().stream().flatMap(Collection::stream).sorted(IntAttached.comparator()).limit(limit).map(entry -> IntAttached.with((int)entry.count(), (Object)entry.stack().m_41786_().m_6881_()));
    }

    public void add(ItemStack stack) {
        this.add(stack, stack.m_41613_());
    }

    public void add(ItemStack stack, int amount) {
        if (stack.m_41619_()) {
            return;
        }
        Set<ItemStackEntry> stackSet = this.getOrCreateItemSet(stack);
        for (ItemStackEntry entry : stackSet) {
            if (!entry.matches(stack)) continue;
            entry.grow(amount);
            return;
        }
        stackSet.add(new ItemStackEntry(stack, amount));
    }

    private Set<ItemStackEntry> getOrCreateItemSet(ItemStack stack) {
        if (!this.items.containsKey(stack.m_41720_())) {
            this.items.put(stack.m_41720_(), new HashSet());
        }
        return this.getItemSet(stack);
    }

    private Set<ItemStackEntry> getItemSet(ItemStack stack) {
        return this.items.get(stack.m_41720_());
    }

    public static class ItemStackEntry
    extends IntAttached<ItemStack> {
        public ItemStackEntry(ItemStack stack) {
            this(stack, stack.m_41613_());
        }

        public ItemStackEntry(ItemStack stack, int amount) {
            super(Integer.valueOf(amount), (Object)stack);
        }

        public boolean matches(ItemStack other) {
            return ItemHandlerHelper.canItemStacksStack((ItemStack)other, (ItemStack)this.stack());
        }

        public ItemStack stack() {
            return (ItemStack)this.getSecond();
        }

        public void grow(int amount) {
            this.setFirst((Integer)this.getFirst() + amount);
        }

        public int count() {
            return (Integer)this.getFirst();
        }
    }
}

