/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.trains.schedule;

import com.simibubi.create.Create;
import com.simibubi.create.content.trains.schedule.ScheduleEntry;
import com.simibubi.create.content.trains.schedule.condition.FluidThresholdCondition;
import com.simibubi.create.content.trains.schedule.condition.IdleCargoCondition;
import com.simibubi.create.content.trains.schedule.condition.ItemThresholdCondition;
import com.simibubi.create.content.trains.schedule.condition.PlayerPassengerCondition;
import com.simibubi.create.content.trains.schedule.condition.RedstoneLinkCondition;
import com.simibubi.create.content.trains.schedule.condition.ScheduleWaitCondition;
import com.simibubi.create.content.trains.schedule.condition.ScheduledDelay;
import com.simibubi.create.content.trains.schedule.condition.StationPoweredCondition;
import com.simibubi.create.content.trains.schedule.condition.StationUnloadedCondition;
import com.simibubi.create.content.trains.schedule.condition.TimeOfDayCondition;
import com.simibubi.create.content.trains.schedule.destination.ChangeThrottleInstruction;
import com.simibubi.create.content.trains.schedule.destination.ChangeTitleInstruction;
import com.simibubi.create.content.trains.schedule.destination.DeliverPackagesInstruction;
import com.simibubi.create.content.trains.schedule.destination.DestinationInstruction;
import com.simibubi.create.content.trains.schedule.destination.FetchPackagesInstruction;
import com.simibubi.create.content.trains.schedule.destination.ScheduleInstruction;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.createmod.catnip.data.Pair;
import net.createmod.catnip.nbt.NBTHelper;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class Schedule {
    public static List<Pair<ResourceLocation, Supplier<? extends ScheduleInstruction>>> INSTRUCTION_TYPES = new ArrayList<Pair<ResourceLocation, Supplier<? extends ScheduleInstruction>>>();
    public static List<Pair<ResourceLocation, Supplier<? extends ScheduleWaitCondition>>> CONDITION_TYPES = new ArrayList<Pair<ResourceLocation, Supplier<? extends ScheduleWaitCondition>>>();
    public List<ScheduleEntry> entries = new ArrayList<ScheduleEntry>();
    public boolean cyclic = true;
    public int savedProgress = 0;

    private static void registerInstruction(String name, Supplier<? extends ScheduleInstruction> factory) {
        INSTRUCTION_TYPES.add((Pair<ResourceLocation, Supplier<? extends ScheduleInstruction>>)Pair.of((Object)Create.asResource(name), factory));
    }

    private static void registerCondition(String name, Supplier<? extends ScheduleWaitCondition> factory) {
        CONDITION_TYPES.add((Pair<ResourceLocation, Supplier<? extends ScheduleWaitCondition>>)Pair.of((Object)Create.asResource(name), factory));
    }

    public static <T> List<? extends Component> getTypeOptions(List<Pair<ResourceLocation, T>> list) {
        String langSection = list.equals(INSTRUCTION_TYPES) ? "instruction." : "condition.";
        return list.stream().map(Pair::getFirst).map(rl -> rl.m_135827_() + ".schedule." + langSection + rl.m_135815_()).map(key -> Component.m_237115_((String)key)).toList();
    }

    public CompoundTag write() {
        CompoundTag tag = new CompoundTag();
        ListTag list = NBTHelper.writeCompoundList(this.entries, ScheduleEntry::write);
        tag.m_128365_("Entries", (Tag)list);
        tag.m_128379_("Cyclic", this.cyclic);
        if (this.savedProgress > 0) {
            tag.m_128405_("Progress", this.savedProgress);
        }
        return tag;
    }

    public static Schedule fromTag(CompoundTag tag) {
        Schedule schedule = new Schedule();
        schedule.entries = NBTHelper.readCompoundList((ListTag)tag.m_128437_("Entries", 10), ScheduleEntry::fromTag);
        schedule.cyclic = tag.m_128471_("Cyclic");
        if (tag.m_128441_("Progress")) {
            schedule.savedProgress = tag.m_128451_("Progress");
        }
        return schedule;
    }

    static {
        Schedule.registerInstruction("destination", DestinationInstruction::new);
        Schedule.registerInstruction("package_delivery", DeliverPackagesInstruction::new);
        Schedule.registerInstruction("package_retrieval", FetchPackagesInstruction::new);
        Schedule.registerInstruction("rename", ChangeTitleInstruction::new);
        Schedule.registerInstruction("throttle", ChangeThrottleInstruction::new);
        Schedule.registerCondition("delay", ScheduledDelay::new);
        Schedule.registerCondition("time_of_day", TimeOfDayCondition::new);
        Schedule.registerCondition("fluid_threshold", FluidThresholdCondition::new);
        Schedule.registerCondition("item_threshold", ItemThresholdCondition::new);
        Schedule.registerCondition("redstone_link", RedstoneLinkCondition::new);
        Schedule.registerCondition("player_count", PlayerPassengerCondition::new);
        Schedule.registerCondition("idle", IdleCargoCondition::new);
        Schedule.registerCondition("unloaded", StationUnloadedCondition::new);
        Schedule.registerCondition("powered", StationPoweredCondition::new);
    }
}

