/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.schematics.client;

import com.simibubi.create.AllItems;
import com.simibubi.create.AllKeys;
import com.simibubi.create.AllPackets;
import com.simibubi.create.AllSpecialTextures;
import com.simibubi.create.Create;
import com.simibubi.create.content.schematics.SchematicExport;
import com.simibubi.create.content.schematics.client.ClientSchematicLoader;
import com.simibubi.create.content.schematics.client.SchematicPromptScreen;
import com.simibubi.create.content.schematics.packet.InstantSchematicPacket;
import com.simibubi.create.foundation.utility.CreateLang;
import com.simibubi.create.foundation.utility.RaycastHelper;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import net.createmod.catnip.animation.AnimationTickHolder;
import net.createmod.catnip.gui.ScreenOpener;
import net.createmod.catnip.math.VecHelper;
import net.createmod.catnip.outliner.Outliner;
import net.createmod.catnip.render.BindableTexture;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class SchematicAndQuillHandler {
    private Object outlineSlot = new Object();
    public BlockPos firstPos;
    public BlockPos secondPos;
    private BlockPos selectedPos;
    private Direction selectedFace;
    private int range = 10;

    public boolean mouseScrolled(double delta) {
        if (!this.isActive()) {
            return false;
        }
        if (!AllKeys.ctrlDown()) {
            return false;
        }
        if (this.secondPos == null) {
            this.range = (int)Mth.m_14008_((double)((double)this.range + delta), (double)1.0, (double)100.0);
        }
        if (this.selectedFace == null) {
            return true;
        }
        AABB bb = new AABB(this.firstPos, this.secondPos);
        Vec3i vec = this.selectedFace.m_122436_();
        Vec3 projectedView = Minecraft.m_91087_().f_91063_.m_109153_().m_90583_();
        if (bb.m_82390_(projectedView)) {
            delta *= -1.0;
        }
        int intDelta = (int)(delta > 0.0 ? Math.ceil(delta) : Math.floor(delta));
        int x = vec.m_123341_() * intDelta;
        int y = vec.m_123342_() * intDelta;
        int z = vec.m_123343_() * intDelta;
        Direction.AxisDirection axisDirection = this.selectedFace.m_122421_();
        if (axisDirection == Direction.AxisDirection.NEGATIVE) {
            bb = bb.m_82386_((double)(-x), (double)(-y), (double)(-z));
        }
        double maxX = Math.max(bb.f_82291_ - (double)(x * axisDirection.m_122540_()), bb.f_82288_);
        double maxY = Math.max(bb.f_82292_ - (double)(y * axisDirection.m_122540_()), bb.f_82289_);
        double maxZ = Math.max(bb.f_82293_ - (double)(z * axisDirection.m_122540_()), bb.f_82290_);
        bb = new AABB(bb.f_82288_, bb.f_82289_, bb.f_82290_, maxX, maxY, maxZ);
        this.firstPos = BlockPos.m_274561_((double)bb.f_82288_, (double)bb.f_82289_, (double)bb.f_82290_);
        this.secondPos = BlockPos.m_274561_((double)bb.f_82291_, (double)bb.f_82292_, (double)bb.f_82293_);
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        CreateLang.translate("schematicAndQuill.dimensions", (int)bb.m_82362_() + 1, (int)bb.m_82376_() + 1, (int)bb.m_82385_() + 1).sendStatus((Player)player);
        return true;
    }

    public boolean onMouseInput(int button, boolean pressed) {
        if (!pressed || button != 1) {
            return false;
        }
        if (!this.isActive()) {
            return false;
        }
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player.m_6144_()) {
            this.discard();
            return true;
        }
        if (this.secondPos != null) {
            ScreenOpener.open((Screen)new SchematicPromptScreen());
            return true;
        }
        if (this.selectedPos == null) {
            CreateLang.translate("schematicAndQuill.noTarget", new Object[0]).sendStatus((Player)player);
            return true;
        }
        if (this.firstPos != null) {
            this.secondPos = this.selectedPos;
            CreateLang.translate("schematicAndQuill.secondPos", new Object[0]).sendStatus((Player)player);
            return true;
        }
        this.firstPos = this.selectedPos;
        CreateLang.translate("schematicAndQuill.firstPos", new Object[0]).sendStatus((Player)player);
        return true;
    }

    public void discard() {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        this.firstPos = null;
        this.secondPos = null;
        CreateLang.translate("schematicAndQuill.abort", new Object[0]).sendStatus((Player)player);
    }

    public void tick() {
        AABB currentSelectionBox;
        if (!this.isActive()) {
            return;
        }
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (AllKeys.ACTIVATE_TOOL.isPressed()) {
            float pt = AnimationTickHolder.getPartialTicks();
            Vec3 targetVec = player.m_20299_(pt).m_82549_(player.m_20154_().m_82490_((double)this.range));
            this.selectedPos = BlockPos.m_274446_((Position)targetVec);
        } else {
            BlockHitResult trace = RaycastHelper.rayTraceRange(player.m_9236_(), (Player)player, 75.0);
            if (trace != null && trace.m_6662_() == HitResult.Type.BLOCK) {
                BlockPos hit = trace.m_82425_();
                boolean replaceable = player.m_9236_().m_8055_(hit).m_60629_(new BlockPlaceContext(new UseOnContext((Player)player, InteractionHand.MAIN_HAND, trace)));
                if (trace.m_82434_().m_122434_().m_122478_() && !replaceable) {
                    hit = hit.m_121945_(trace.m_82434_());
                }
                this.selectedPos = hit;
            } else {
                this.selectedPos = null;
            }
        }
        this.selectedFace = null;
        if (this.secondPos != null) {
            Vec3 projectedView;
            AABB bb = new AABB(this.firstPos, this.secondPos).m_82363_(1.0, 1.0, 1.0).m_82400_((double)0.45f);
            boolean inside = bb.m_82390_(projectedView = Minecraft.m_91087_().f_91063_.m_109153_().m_90583_());
            RaycastHelper.PredicateTraceResult result = RaycastHelper.rayTraceUntil((Player)player, 70.0, pos -> inside ^ bb.m_82390_(VecHelper.getCenterOf((Vec3i)pos)));
            Direction direction = result.missed() ? null : (this.selectedFace = inside ? result.getFacing().m_122424_() : result.getFacing());
        }
        if ((currentSelectionBox = this.getCurrentSelectionBox()) != null) {
            this.outliner().chaseAABB(this.outlineSlot, currentSelectionBox).colored(6850245).withFaceTextures((BindableTexture)AllSpecialTextures.CHECKERED, (BindableTexture)AllSpecialTextures.HIGHLIGHT_CHECKERED).lineWidth(0.0625f).highlightFace(this.selectedFace);
        }
    }

    private AABB getCurrentSelectionBox() {
        if (this.secondPos == null) {
            if (this.firstPos == null) {
                return this.selectedPos == null ? null : new AABB(this.selectedPos);
            }
            return this.selectedPos == null ? new AABB(this.firstPos) : new AABB(this.firstPos, this.selectedPos).m_82363_(1.0, 1.0, 1.0);
        }
        return new AABB(this.firstPos, this.secondPos).m_82363_(1.0, 1.0, 1.0);
    }

    private boolean isActive() {
        return this.isPresent() && AllItems.SCHEMATIC_AND_QUILL.isIn(Minecraft.m_91087_().f_91074_.m_21205_());
    }

    private boolean isPresent() {
        return Minecraft.m_91087_() != null && Minecraft.m_91087_().f_91073_ != null && Minecraft.m_91087_().f_91080_ == null;
    }

    public void saveSchematic(String string, boolean convertImmediately) {
        SchematicExport.SchematicExportResult result = SchematicExport.saveSchematic(SchematicExport.SCHEMATICS, string, false, (Level)Minecraft.m_91087_().f_91073_, this.firstPos, this.secondPos);
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (result == null) {
            CreateLang.translate("schematicAndQuill.failed", new Object[0]).style(ChatFormatting.RED).sendStatus((Player)player);
            return;
        }
        Path file = result.file();
        CreateLang.translate("schematicAndQuill.saved", file.getFileName()).sendStatus((Player)player);
        this.firstPos = null;
        this.secondPos = null;
        if (!convertImmediately) {
            return;
        }
        try {
            if (!ClientSchematicLoader.validateSizeLimitation(Files.size(file))) {
                return;
            }
            AllPackets.getChannel().sendToServer((Object)new InstantSchematicPacket(result.fileName(), result.origin(), result.bounds()));
        }
        catch (IOException e) {
            Create.LOGGER.error("Error instantly uploading Schematic file: " + String.valueOf(file), (Throwable)e);
        }
    }

    private Outliner outliner() {
        return Outliner.getInstance();
    }
}

