/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.redstone.displayLink;

import com.simibubi.create.api.behaviour.display.DisplaySource;
import com.simibubi.create.api.behaviour.display.DisplayTarget;
import com.simibubi.create.api.registry.CreateBuiltInRegistries;
import com.simibubi.create.compat.computercraft.AbstractComputerBehaviour;
import com.simibubi.create.compat.computercraft.ComputerCraftProxy;
import com.simibubi.create.content.logistics.factoryBoard.FactoryPanelPosition;
import com.simibubi.create.content.logistics.factoryBoard.FactoryPanelSupportBehaviour;
import com.simibubi.create.content.redstone.displayLink.DisplayLinkBlock;
import com.simibubi.create.content.redstone.displayLink.DisplayLinkContext;
import com.simibubi.create.content.redstone.displayLink.LinkWithBulbBlockEntity;
import com.simibubi.create.foundation.advancement.AllAdvancements;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import java.util.Iterator;
import java.util.List;
import net.createmod.catnip.math.VecHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DisplayLinkBlockEntity
extends LinkWithBulbBlockEntity {
    protected BlockPos targetOffset = BlockPos.f_121853_;
    public DisplaySource activeSource;
    private CompoundTag sourceConfig = new CompoundTag();
    public DisplayTarget activeTarget;
    public int targetLine = 0;
    public int refreshTicks;
    public AbstractComputerBehaviour computerBehaviour;
    public FactoryPanelSupportBehaviour factoryPanelSupport;
    private static final Vec3 bulbOffset = VecHelper.voxelSpace((double)11.0, (double)7.0, (double)5.0);
    private static final Vec3 bulbOffsetVertical = VecHelper.voxelSpace((double)5.0, (double)7.0, (double)11.0);

    public DisplayLinkBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        this.computerBehaviour = ComputerCraftProxy.behaviour(this);
        behaviours.add(this.computerBehaviour);
        this.factoryPanelSupport = new FactoryPanelSupportBehaviour(this, () -> false, () -> false, () -> this.updateGatheredData());
        behaviours.add(this.factoryPanelSupport);
        this.registerAwardables(behaviours, AllAdvancements.DISPLAY_LINK, AllAdvancements.DISPLAY_BOARD);
    }

    @Override
    public void tick() {
        super.tick();
        if (this.isVirtual()) {
            return;
        }
        if (this.activeSource == null) {
            return;
        }
        if (this.f_58857_.f_46443_) {
            return;
        }
        ++this.refreshTicks;
        if (this.refreshTicks < this.activeSource.getPassiveRefreshTicks() || !this.activeSource.shouldPassiveReset()) {
            return;
        }
        this.tickSource();
    }

    public void tickSource() {
        this.refreshTicks = 0;
        if (this.m_58900_().m_61145_((Property)DisplayLinkBlock.POWERED).orElse(true).booleanValue()) {
            return;
        }
        if (!this.f_58857_.f_46443_) {
            this.updateGatheredData();
        }
    }

    public void onNoLongerPowered() {
        if (this.activeSource == null) {
            return;
        }
        this.refreshTicks = 0;
        this.activeSource.onSignalReset(new DisplayLinkContext(this.f_58857_, this));
        this.updateGatheredData();
    }

    public void updateGatheredData() {
        BlockPos sourcePosition = this.getSourcePosition();
        BlockPos targetPosition = this.getTargetPosition();
        if (!this.f_58857_.m_46749_(targetPosition) || !this.f_58857_.m_46749_(sourcePosition)) {
            return;
        }
        DisplayTarget target = DisplayTarget.get((LevelAccessor)this.f_58857_, targetPosition);
        List<DisplaySource> sources = DisplaySource.getAll((LevelAccessor)this.f_58857_, sourcePosition);
        boolean notify = false;
        if (this.activeTarget != target) {
            this.activeTarget = target;
            notify = true;
        }
        if (this.activeSource != null && !sources.contains(this.activeSource)) {
            this.activeSource = null;
            this.sourceConfig = new CompoundTag();
            notify = true;
        }
        if (notify) {
            this.notifyUpdate();
        }
        if (this.activeSource == null || this.activeTarget == null) {
            return;
        }
        DisplayLinkContext context = new DisplayLinkContext(this.f_58857_, this);
        this.activeSource.transferData(context, this.activeTarget, this.targetLine);
        this.sendPulseNextSync();
        this.sendData();
        this.award(AllAdvancements.DISPLAY_LINK);
    }

    @Override
    public void writeSafe(CompoundTag tag) {
        super.writeSafe(tag);
        this.writeGatheredData(tag);
    }

    @Override
    protected void write(CompoundTag tag, boolean clientPacket) {
        ResourceLocation id;
        super.write(tag, clientPacket);
        this.writeGatheredData(tag);
        if (clientPacket && this.activeTarget != null && (id = CreateBuiltInRegistries.DISPLAY_TARGET.m_7981_((Object)this.activeTarget)) != null) {
            tag.m_128359_("TargetType", id.toString());
        }
    }

    private void writeGatheredData(CompoundTag tag) {
        tag.m_128365_("TargetOffset", (Tag)NbtUtils.m_129224_((BlockPos)this.targetOffset));
        tag.m_128405_("TargetLine", this.targetLine);
        if (this.activeSource != null) {
            CompoundTag data = this.sourceConfig.m_6426_();
            ResourceLocation id = CreateBuiltInRegistries.DISPLAY_SOURCE.m_7981_((Object)this.activeSource);
            if (id != null) {
                data.m_128359_("Id", id.toString());
            }
            tag.m_128365_("Source", (Tag)data);
        }
    }

    @Override
    protected void read(CompoundTag tag, boolean clientPacket) {
        super.read(tag, clientPacket);
        this.targetOffset = NbtUtils.m_129239_((CompoundTag)tag.m_128469_("TargetOffset"));
        this.targetLine = tag.m_128451_("TargetLine");
        if (clientPacket && tag.m_128441_("TargetType")) {
            this.activeTarget = DisplayTarget.get(ResourceLocation.m_135820_((String)tag.m_128461_("TargetType")));
        }
        if (!tag.m_128441_("Source")) {
            return;
        }
        CompoundTag data = tag.m_128469_("Source");
        this.activeSource = DisplaySource.get(ResourceLocation.m_135820_((String)data.m_128461_("Id")));
        this.sourceConfig = new CompoundTag();
        if (this.activeSource != null) {
            this.sourceConfig = data.m_6426_();
        }
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (this.computerBehaviour.isPeripheralCap(cap)) {
            return this.computerBehaviour.getPeripheralCapability();
        }
        return super.getCapability(cap, side);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.computerBehaviour.removePeripheral();
    }

    public void target(BlockPos targetPosition) {
        this.targetOffset = targetPosition.m_121996_((Vec3i)this.f_58858_);
    }

    public BlockPos getSourcePosition() {
        Iterator<FactoryPanelPosition> iterator = this.factoryPanelSupport.getLinkedPanels().iterator();
        if (iterator.hasNext()) {
            FactoryPanelPosition position = iterator.next();
            return position.pos();
        }
        return this.f_58858_.m_121945_(this.getDirection());
    }

    public CompoundTag getSourceConfig() {
        return this.sourceConfig;
    }

    public void setSourceConfig(CompoundTag sourceConfig) {
        this.sourceConfig = sourceConfig;
    }

    public Direction getDirection() {
        return this.m_58900_().m_61145_((Property)DisplayLinkBlock.f_52588_).orElse(Direction.UP).m_122424_();
    }

    public BlockPos getTargetPosition() {
        return this.f_58858_.m_121955_((Vec3i)this.targetOffset);
    }

    @Override
    public Vec3 getBulbOffset(BlockState state) {
        if (state.m_61145_((Property)DisplayLinkBlock.f_52588_).orElse(Direction.UP).m_122434_().m_122478_()) {
            return bulbOffsetVertical;
        }
        return bulbOffset;
    }
}

