/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.item.filter.attribute.attributes;

import com.simibubi.create.Create;
import com.simibubi.create.content.logistics.item.filter.attribute.AllItemAttributeTypes;
import com.simibubi.create.content.logistics.item.filter.attribute.ItemAttribute;
import com.simibubi.create.content.logistics.item.filter.attribute.ItemAttributeType;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.CreativeModeTabRegistry;
import org.jetbrains.annotations.NotNull;

public class InItemGroupAttribute
implements ItemAttribute {
    private CreativeModeTab group;

    public InItemGroupAttribute(CreativeModeTab group) {
        this.group = group;
    }

    private static boolean tabContainsItem(CreativeModeTab tab, ItemStack stack) {
        return tab.m_257694_(stack) || tab.m_257694_(new ItemStack((ItemLike)stack.m_41720_()));
    }

    @Override
    public boolean appliesTo(ItemStack stack, Level world) {
        if (this.group == null) {
            return false;
        }
        if (this.group.m_260957_().isEmpty() && this.group.m_261235_().isEmpty()) {
            try {
                this.group.m_269498_(new CreativeModeTab.ItemDisplayParameters(world.m_246046_(), false, (HolderLookup.Provider)world.m_9598_()));
            }
            catch (LinkageError | RuntimeException e) {
                Create.LOGGER.error("Attribute Filter: Item Group {} crashed while building contents.", (Object)this.group.m_40786_().getString(), (Object)e);
                this.group = null;
                return false;
            }
        }
        return InItemGroupAttribute.tabContainsItem(this.group, stack);
    }

    @Override
    public String getTranslationKey() {
        return "in_item_group";
    }

    @Override
    public Object[] getTranslationParameters() {
        return new Object[]{this.group == null ? "<none>" : this.group.m_40786_().getString()};
    }

    @Override
    public ItemAttributeType getType() {
        return AllItemAttributeTypes.IN_ITEM_GROUP;
    }

    @Override
    public void save(CompoundTag nbt) {
        ResourceLocation groupId;
        if (this.group != null && (groupId = CreativeModeTabRegistry.getName((CreativeModeTab)this.group)) != null) {
            nbt.m_128359_("group", groupId.toString());
        }
    }

    @Override
    public void load(CompoundTag nbt) {
        if (nbt.m_128441_("group")) {
            this.group = CreativeModeTabRegistry.getTab((ResourceLocation)new ResourceLocation(nbt.m_128461_("group")));
        }
    }

    public static class Type
    implements ItemAttributeType {
        @Override
        @NotNull
        public ItemAttribute createAttribute() {
            return new InItemGroupAttribute(null);
        }

        @Override
        public List<ItemAttribute> getAllAttributes(ItemStack stack, Level level) {
            ArrayList<ItemAttribute> list = new ArrayList<ItemAttribute>();
            for (CreativeModeTab tab : CreativeModeTabs.m_257388_()) {
                if (tab.m_257962_() != CreativeModeTab.Type.CATEGORY || !InItemGroupAttribute.tabContainsItem(tab, stack)) continue;
                list.add(new InItemGroupAttribute(tab));
            }
            return list;
        }
    }
}

