/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.kinetics.saw;

import com.simibubi.create.AllTags;
import com.simibubi.create.compat.Mods;
import com.simibubi.create.compat.dynamictrees.DynamicTree;
import com.simibubi.create.foundation.utility.AbstractBlockBreakQueue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.createmod.catnip.data.Iterate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BambooStalkBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CactusBlock;
import net.minecraft.world.level.block.ChorusFlowerBlock;
import net.minecraft.world.level.block.ChorusPlantBlock;
import net.minecraft.world.level.block.KelpBlock;
import net.minecraft.world.level.block.KelpPlantBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.SugarCaneBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;

public class TreeCutter {
    public static final Tree NO_TREE = new Tree(Collections.emptyList(), Collections.emptyList(), Collections.emptyList());

    public static boolean canDynamicTreeCutFrom(Block startBlock) {
        return Mods.DYNAMICTREES.runIfInstalled(() -> () -> DynamicTree.isDynamicBranch(startBlock)).orElse(false);
    }

    @Nonnull
    public static Optional<AbstractBlockBreakQueue> findDynamicTree(Block startBlock, BlockPos pos) {
        if (TreeCutter.canDynamicTreeCutFrom(startBlock)) {
            return Mods.DYNAMICTREES.runIfInstalled(() -> () -> new DynamicTree(pos));
        }
        return Optional.empty();
    }

    @Nonnull
    public static Tree findTree(@Nullable BlockGetter reader, BlockPos pos, BlockState brokenState) {
        BlockState currentState;
        BlockPos currentPos2;
        if (reader == null) {
            return NO_TREE;
        }
        ArrayList<BlockPos> logs = new ArrayList<BlockPos>();
        ArrayList<BlockPos> leaves = new ArrayList<BlockPos>();
        ArrayList<BlockPos> attachments = new ArrayList<BlockPos>();
        HashSet<BlockPos> visited = new HashSet<BlockPos>();
        LinkedList<BlockPos> frontier = new LinkedList<BlockPos>();
        BlockState stateAbove = reader.m_8055_(pos.m_7494_());
        if (TreeCutter.isVerticalPlant(brokenState)) {
            BlockPos current;
            if (!TreeCutter.isVerticalPlant(stateAbove)) {
                return NO_TREE;
            }
            logs.add(pos.m_7494_());
            for (int i = 1; i < reader.m_141928_() && TreeCutter.isVerticalPlant(reader.m_8055_(current = pos.m_6630_(i))); ++i) {
                logs.add(current);
            }
            Collections.reverse(logs);
            return new Tree(logs, leaves, attachments);
        }
        if (TreeCutter.isChorus(brokenState)) {
            if (!TreeCutter.isChorus(stateAbove)) {
                return NO_TREE;
            }
            frontier.add(pos.m_7494_());
            while (!frontier.isEmpty()) {
                BlockPos current = (BlockPos)frontier.remove(0);
                visited.add(current);
                logs.add(current);
                for (Direction direction : Iterate.directions) {
                    BlockPos offset = current.m_121945_(direction);
                    if (visited.contains(offset) || !TreeCutter.isChorus(reader.m_8055_(offset))) continue;
                    frontier.add(offset);
                }
            }
            Collections.reverse(logs);
            return new Tree(logs, leaves, attachments);
        }
        if (!TreeCutter.validateCut(reader, pos)) {
            return NO_TREE;
        }
        visited.add(pos);
        BlockPos.m_121990_((BlockPos)pos.m_7918_(-1, 0, -1), (BlockPos)pos.m_7918_(1, 1, 1)).forEach(p -> frontier.add(new BlockPos((Vec3i)p)));
        boolean hasRoots = false;
        while (!frontier.isEmpty()) {
            currentPos2 = (BlockPos)frontier.remove(0);
            if (!visited.add(currentPos2)) continue;
            currentState = reader.m_8055_(currentPos2);
            if (TreeCutter.isRoot(currentState)) {
                hasRoots = true;
            } else if (!TreeCutter.isLog(currentState)) continue;
            logs.add(currentPos2);
            TreeCutter.forNeighbours(currentPos2, visited, SearchDirection.UP, p -> frontier.add(new BlockPos((Vec3i)p)));
        }
        visited.clear();
        visited.addAll(logs);
        frontier.addAll(logs);
        if (hasRoots) {
            while (!frontier.isEmpty()) {
                currentPos2 = (BlockPos)frontier.remove(0);
                if (!logs.contains(currentPos2) && !visited.add(currentPos2) || !TreeCutter.isRoot(currentState = reader.m_8055_(currentPos2))) continue;
                logs.add(currentPos2);
                TreeCutter.forNeighbours(currentPos2, visited, SearchDirection.DOWN, p -> frontier.add(new BlockPos((Vec3i)p)));
            }
            visited.clear();
            visited.addAll(logs);
            frontier.addAll(logs);
        }
        while (!frontier.isEmpty()) {
            BlockPos prevPos = (BlockPos)frontier.remove(0);
            if (!logs.contains(prevPos) && !visited.add(prevPos)) continue;
            BlockState prevState = reader.m_8055_(prevPos);
            int prevLeafDistance = TreeCutter.isLeaf(prevState) ? TreeCutter.getLeafDistance(prevState) : 0;
            TreeCutter.forNeighbours(prevPos, visited, SearchDirection.BOTH, currentPos -> {
                BlockState state = reader.m_8055_(currentPos);
                BlockPos subtract = currentPos.m_121996_((Vec3i)pos);
                BlockPos currentPosImmutable = currentPos.m_7949_();
                if (AllTags.AllBlockTags.TREE_ATTACHMENTS.matches(state)) {
                    attachments.add(currentPosImmutable);
                    visited.add(currentPosImmutable);
                    return;
                }
                int horizontalDistance = Math.max(Math.abs(subtract.m_123341_()), Math.abs(subtract.m_123343_()));
                if (horizontalDistance <= TreeCutter.nonDecayingLeafDistance(state)) {
                    leaves.add(currentPosImmutable);
                    frontier.add(currentPosImmutable);
                    return;
                }
                if (TreeCutter.isLeaf(state) && TreeCutter.getLeafDistance(state) > prevLeafDistance) {
                    leaves.add(currentPosImmutable);
                    frontier.add(currentPosImmutable);
                    return;
                }
            });
        }
        return new Tree(logs, leaves, attachments);
    }

    private static int getLeafDistance(BlockState state) {
        IntegerProperty distanceProperty = LeavesBlock.f_54418_;
        for (Property property : state.m_61148_().keySet()) {
            if (!(property instanceof IntegerProperty)) continue;
            IntegerProperty ip = (IntegerProperty)property;
            if (!property.m_61708_().equals("distance")) continue;
            distanceProperty = ip;
        }
        return (Integer)state.m_61143_((Property)distanceProperty);
    }

    public static boolean isChorus(BlockState stateAbove) {
        return stateAbove.m_60734_() instanceof ChorusPlantBlock || stateAbove.m_60734_() instanceof ChorusFlowerBlock;
    }

    public static boolean isVerticalPlant(BlockState stateAbove) {
        Block block = stateAbove.m_60734_();
        if (block instanceof BambooStalkBlock) {
            return true;
        }
        if (block instanceof CactusBlock) {
            return true;
        }
        if (block instanceof SugarCaneBlock) {
            return true;
        }
        if (block instanceof KelpPlantBlock) {
            return true;
        }
        return block instanceof KelpBlock;
    }

    private static boolean validateCut(BlockGetter reader, BlockPos pos) {
        HashSet<BlockPos> visited = new HashSet<BlockPos>();
        LinkedList<BlockPos> frontier = new LinkedList<BlockPos>();
        frontier.add(pos);
        frontier.add(pos.m_7494_());
        int posY = pos.m_123342_();
        while (!frontier.isEmpty()) {
            BlockPos currentPos = (BlockPos)frontier.remove(0);
            BlockPos belowPos = currentPos.m_7495_();
            visited.add(currentPos);
            boolean lowerLayer = currentPos.m_123342_() == posY;
            BlockState currentState = reader.m_8055_(currentPos);
            BlockState belowState = reader.m_8055_(belowPos);
            if (!TreeCutter.isLog(currentState) && !TreeCutter.isRoot(currentState)) continue;
            if (!lowerLayer && !pos.equals((Object)belowPos) && (TreeCutter.isLog(belowState) || TreeCutter.isRoot(belowState))) {
                return false;
            }
            for (Direction direction : Iterate.directions) {
                BlockPos offset;
                if (direction == Direction.DOWN || direction == Direction.UP && !lowerLayer || visited.contains(offset = currentPos.m_121945_(direction))) continue;
                frontier.add(offset);
            }
        }
        return true;
    }

    private static void forNeighbours(BlockPos pos, Set<BlockPos> visited, SearchDirection direction, Consumer<BlockPos> acceptor) {
        BlockPos.m_121990_((BlockPos)pos.m_7918_(-1, direction.minY, -1), (BlockPos)pos.m_7918_(1, direction.maxY, 1)).filter(((Predicate<BlockPos>)visited::contains).negate()).forEach(acceptor);
    }

    public static boolean isRoot(BlockState state) {
        return AllTags.AllBlockTags.ROOTS.matches(state);
    }

    public static boolean isLog(BlockState state) {
        return state.m_204336_(BlockTags.f_13106_) || AllTags.AllBlockTags.SLIMY_LOGS.matches(state) || state.m_60713_(Blocks.f_50182_);
    }

    private static int nonDecayingLeafDistance(BlockState state) {
        if (state.m_60713_(Blocks.f_50181_)) {
            return 2;
        }
        if (state.m_60713_(Blocks.f_50180_)) {
            return 3;
        }
        if (state.m_204336_(BlockTags.f_13078_) || state.m_60713_(Blocks.f_50702_) || state.m_60713_(Blocks.f_50703_)) {
            return 3;
        }
        return -1;
    }

    private static boolean isLeaf(BlockState state) {
        for (Property property : state.m_61148_().keySet()) {
            if (!(property instanceof IntegerProperty) || !property.m_61708_().equals("distance") || property == BlockStateProperties.f_61388_) continue;
            return true;
        }
        return false;
    }

    public static class Tree
    extends AbstractBlockBreakQueue {
        private final List<BlockPos> logs;
        private final List<BlockPos> leaves;
        private final List<BlockPos> attachments;

        public Tree(List<BlockPos> logs, List<BlockPos> leaves, List<BlockPos> attachments) {
            this.logs = logs;
            this.leaves = leaves;
            this.attachments = attachments;
        }

        @Override
        public void destroyBlocks(Level world, ItemStack toDamage, @Nullable Player playerEntity, BiConsumer<BlockPos, ItemStack> drop) {
            this.attachments.forEach(this.makeCallbackFor(world, 0.03125f, toDamage, playerEntity, drop));
            this.logs.forEach(this.makeCallbackFor(world, 0.5f, toDamage, playerEntity, drop));
            this.leaves.forEach(this.makeCallbackFor(world, 0.125f, toDamage, playerEntity, drop));
        }
    }

    private static enum SearchDirection {
        UP(0, 1),
        DOWN(-1, 0),
        BOTH(-1, 1);

        int minY;
        int maxY;

        private SearchDirection(int minY, int maxY) {
            this.minY = minY;
            this.maxY = maxY;
        }
    }
}

