/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.kinetics.belt;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.kinetics.base.IRotate;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.belt.BeltBlock;
import com.simibubi.create.content.kinetics.belt.BeltHelper;
import com.simibubi.create.content.kinetics.belt.BeltModel;
import com.simibubi.create.content.kinetics.belt.BeltPart;
import com.simibubi.create.content.kinetics.belt.BeltSlope;
import com.simibubi.create.content.kinetics.belt.behaviour.DirectBeltInputBehaviour;
import com.simibubi.create.content.kinetics.belt.behaviour.TransportedItemStackHandlerBehaviour;
import com.simibubi.create.content.kinetics.belt.transport.BeltInventory;
import com.simibubi.create.content.kinetics.belt.transport.BeltMovementHandler;
import com.simibubi.create.content.kinetics.belt.transport.BeltTunnelInteractionHandler;
import com.simibubi.create.content.kinetics.belt.transport.ItemHandlerBeltSegment;
import com.simibubi.create.content.kinetics.belt.transport.TransportedItemStack;
import com.simibubi.create.content.logistics.tunnel.BrassTunnelBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.inventory.VersionedInventoryTrackerBehaviour;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import net.createmod.catnip.nbt.NBTHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;

public class BeltBlockEntity
extends KineticBlockEntity {
    public Map<Entity, BeltMovementHandler.TransportedEntityInfo> passengers;
    public Optional<DyeColor> color;
    public int beltLength;
    public int index;
    public Direction lastInsert;
    public CasingType casing;
    public boolean covered;
    protected BlockPos controller = BlockPos.f_121853_;
    protected BeltInventory inventory;
    protected LazyOptional<IItemHandler> itemHandler = LazyOptional.empty();
    public VersionedInventoryTrackerBehaviour invVersionTracker;
    public CompoundTag trackerUpdateTag;

    public BeltBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.casing = CasingType.NONE;
        this.color = Optional.empty();
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        super.addBehaviours(behaviours);
        behaviours.add(new DirectBeltInputBehaviour(this).onlyInsertWhen(this::canInsertFrom).setInsertionHandler(this::tryInsertingFromSide).considerOccupiedWhen(this::isOccupied));
        behaviours.add(new TransportedItemStackHandlerBehaviour(this, this::applyToAllItems).withStackPlacement(this::getWorldPositionOf));
        this.invVersionTracker = new VersionedInventoryTrackerBehaviour(this);
        behaviours.add(this.invVersionTracker);
    }

    @Override
    public void tick() {
        if (this.beltLength == 0) {
            BeltBlock.initBelt(this.f_58857_, this.f_58858_);
        }
        super.tick();
        if (!AllBlocks.BELT.has(this.f_58857_.m_8055_(this.f_58858_))) {
            return;
        }
        this.initializeItemHandler();
        if (!this.isController()) {
            return;
        }
        this.invalidateRenderBoundingBox();
        this.getInventory().tick();
        if (this.getSpeed() == 0.0f) {
            return;
        }
        if (this.passengers == null) {
            this.passengers = new HashMap<Entity, BeltMovementHandler.TransportedEntityInfo>();
        }
        ArrayList toRemove = new ArrayList();
        this.passengers.forEach((entity, info) -> {
            boolean leftTheBelt;
            boolean canBeTransported = BeltMovementHandler.canBeTransported(entity);
            boolean bl = leftTheBelt = info.getTicksSinceLastCollision() > (this.m_58900_().m_61143_(BeltBlock.SLOPE) != BeltSlope.HORIZONTAL ? 3 : 1);
            if (!canBeTransported || leftTheBelt) {
                toRemove.add(entity);
                return;
            }
            info.tick();
            BeltMovementHandler.transportEntity(this, entity, info);
        });
        toRemove.forEach(this.passengers::remove);
    }

    @Override
    public float calculateStressApplied() {
        if (!this.isController()) {
            return 0.0f;
        }
        return super.calculateStressApplied();
    }

    @Override
    public AABB createRenderBoundingBox() {
        if (!this.isController()) {
            return super.createRenderBoundingBox();
        }
        return super.createRenderBoundingBox().m_82400_((double)(this.beltLength + 1));
    }

    protected void initializeItemHandler() {
        if (this.f_58857_.f_46443_ || this.itemHandler.isPresent()) {
            return;
        }
        if (this.beltLength == 0 || this.controller == null) {
            return;
        }
        if (!this.f_58857_.m_46749_(this.controller)) {
            return;
        }
        BlockEntity be = this.f_58857_.m_7702_(this.controller);
        if (be == null || !(be instanceof BeltBlockEntity)) {
            return;
        }
        BeltInventory inventory = ((BeltBlockEntity)be).getInventory();
        if (inventory == null) {
            return;
        }
        ItemHandlerBeltSegment handler = new ItemHandlerBeltSegment(inventory, this.index);
        this.itemHandler = LazyOptional.of(() -> handler);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (!this.isItemHandlerCap(cap)) {
            return super.getCapability(cap, side);
        }
        if (!BeltBlock.canTransportObjects(this.m_58900_())) {
            return super.getCapability(cap, side);
        }
        if (!this.m_58901_() && !this.itemHandler.isPresent()) {
            this.initializeItemHandler();
        }
        return this.itemHandler.cast();
    }

    @Override
    public void destroy() {
        super.destroy();
        if (this.isController()) {
            this.getInventory().ejectAll();
        }
    }

    @Override
    public void invalidate() {
        super.invalidate();
        this.itemHandler.invalidate();
    }

    @Override
    public void write(CompoundTag compound, boolean clientPacket) {
        if (this.controller != null) {
            compound.m_128365_("Controller", (Tag)NbtUtils.m_129224_((BlockPos)this.controller));
        }
        compound.m_128379_("IsController", this.isController());
        compound.m_128405_("Length", this.beltLength);
        compound.m_128405_("Index", this.index);
        NBTHelper.writeEnum((CompoundTag)compound, (String)"Casing", (Enum)this.casing);
        compound.m_128379_("Covered", this.covered);
        if (this.color.isPresent()) {
            NBTHelper.writeEnum((CompoundTag)compound, (String)"Dye", (Enum)this.color.get());
        }
        if (this.isController()) {
            compound.m_128365_("Inventory", (Tag)this.getInventory().write());
        }
        super.write(compound, clientPacket);
    }

    @Override
    protected void read(CompoundTag compound, boolean clientPacket) {
        super.read(compound, clientPacket);
        if (compound.m_128471_("IsController")) {
            this.controller = this.f_58858_;
        }
        Optional<Object> optional = this.color = compound.m_128441_("Dye") ? Optional.of((DyeColor)NBTHelper.readEnum((CompoundTag)compound, (String)"Dye", DyeColor.class)) : Optional.empty();
        if (!this.wasMoved) {
            if (!this.isController()) {
                this.controller = NbtUtils.m_129239_((CompoundTag)compound.m_128469_("Controller"));
            }
            this.trackerUpdateTag = compound;
            this.index = compound.m_128451_("Index");
            this.beltLength = compound.m_128451_("Length");
        }
        if (this.isController()) {
            this.getInventory().read(compound.m_128469_("Inventory"));
        }
        CasingType casingBefore = this.casing;
        boolean coverBefore = this.covered;
        this.casing = (CasingType)NBTHelper.readEnum((CompoundTag)compound, (String)"Casing", CasingType.class);
        this.covered = compound.m_128471_("Covered");
        if (!clientPacket) {
            return;
        }
        if (casingBefore == this.casing && coverBefore == this.covered) {
            return;
        }
        if (!this.isVirtual()) {
            this.requestModelDataUpdate();
        }
        if (this.m_58898_()) {
            this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 16);
        }
    }

    @Override
    public void clearKineticInformation() {
        super.clearKineticInformation();
        this.beltLength = 0;
        this.index = 0;
        this.controller = null;
        this.trackerUpdateTag = new CompoundTag();
    }

    public boolean applyColor(DyeColor colorIn) {
        if (colorIn == null ? !this.color.isPresent() : this.color.isPresent() && this.color.get() == colorIn) {
            return false;
        }
        if (this.f_58857_.m_5776_()) {
            return true;
        }
        for (BlockPos blockPos : BeltBlock.getBeltChain((LevelAccessor)this.f_58857_, this.getController())) {
            BeltBlockEntity belt = BeltHelper.getSegmentBE((LevelAccessor)this.f_58857_, blockPos);
            if (belt == null) continue;
            belt.color = Optional.ofNullable(colorIn);
            belt.m_6596_();
            belt.sendData();
        }
        return true;
    }

    public BeltBlockEntity getControllerBE() {
        if (this.controller == null) {
            return null;
        }
        if (!this.f_58857_.m_46749_(this.controller)) {
            return null;
        }
        BlockEntity be = this.f_58857_.m_7702_(this.controller);
        if (be == null || !(be instanceof BeltBlockEntity)) {
            return null;
        }
        return (BeltBlockEntity)be;
    }

    public void setController(BlockPos controller) {
        this.controller = controller;
    }

    public BlockPos getController() {
        return this.controller == null ? this.f_58858_ : this.controller;
    }

    public boolean isController() {
        return this.controller != null && this.f_58858_.m_123341_() == this.controller.m_123341_() && this.f_58858_.m_123342_() == this.controller.m_123342_() && this.f_58858_.m_123343_() == this.controller.m_123343_();
    }

    public float getBeltMovementSpeed() {
        return this.getSpeed() / 480.0f;
    }

    public float getDirectionAwareBeltMovementSpeed() {
        int offset = this.getBeltFacing().m_122421_().m_122540_();
        if (this.getBeltFacing().m_122434_() == Direction.Axis.X) {
            offset *= -1;
        }
        return this.getBeltMovementSpeed() * (float)offset;
    }

    public boolean hasPulley() {
        if (!AllBlocks.BELT.has(this.m_58900_())) {
            return false;
        }
        return this.m_58900_().m_61143_(BeltBlock.PART) != BeltPart.MIDDLE;
    }

    protected boolean isLastBelt() {
        if (this.getSpeed() == 0.0f) {
            return false;
        }
        Direction direction = this.getBeltFacing();
        if (this.m_58900_().m_61143_(BeltBlock.SLOPE) == BeltSlope.VERTICAL) {
            return false;
        }
        BeltPart part = (BeltPart)((Object)this.m_58900_().m_61143_(BeltBlock.PART));
        if (part == BeltPart.MIDDLE) {
            return false;
        }
        boolean movingPositively = this.getSpeed() > 0.0f == (direction.m_122421_().m_122540_() == 1) ^ direction.m_122434_() == Direction.Axis.X;
        return part == BeltPart.START ^ movingPositively;
    }

    public Vec3i getMovementDirection(boolean firstHalf) {
        return this.getMovementDirection(firstHalf, false);
    }

    public Vec3i getBeltChainDirection() {
        return this.getMovementDirection(true, true);
    }

    protected Vec3i getMovementDirection(boolean firstHalf, boolean ignoreHalves) {
        boolean movingUp;
        boolean onSlope;
        boolean notHorizontal;
        if (this.getSpeed() == 0.0f) {
            return BlockPos.f_121853_;
        }
        BlockState blockState = this.m_58900_();
        Direction beltFacing = (Direction)blockState.m_61143_((Property)BlockStateProperties.f_61374_);
        BeltSlope slope = (BeltSlope)((Object)blockState.m_61143_(BeltBlock.SLOPE));
        BeltPart part = (BeltPart)((Object)blockState.m_61143_(BeltBlock.PART));
        Direction.Axis axis = beltFacing.m_122434_();
        Direction movementFacing = Direction.m_122390_((Direction.AxisDirection)(axis == Direction.Axis.X ? Direction.AxisDirection.NEGATIVE : Direction.AxisDirection.POSITIVE), (Direction.Axis)axis);
        boolean bl = notHorizontal = blockState.m_61143_(BeltBlock.SLOPE) != BeltSlope.HORIZONTAL;
        if (this.getSpeed() < 0.0f) {
            movementFacing = movementFacing.m_122424_();
        }
        Vec3i movement = movementFacing.m_122436_();
        boolean slopeBeforeHalf = part == BeltPart.END == (beltFacing.m_122421_() == Direction.AxisDirection.POSITIVE);
        boolean bl2 = onSlope = notHorizontal && (part == BeltPart.MIDDLE || slopeBeforeHalf == firstHalf || ignoreHalves);
        boolean bl3 = onSlope && slope == (movementFacing == beltFacing ? BeltSlope.UPWARD : BeltSlope.DOWNWARD) ? true : (movingUp = false);
        if (!onSlope) {
            return movement;
        }
        return new Vec3i(movement.m_123341_(), movingUp ? 1 : -1, movement.m_123343_());
    }

    public Direction getMovementFacing() {
        Direction.Axis axis = this.getBeltFacing().m_122434_();
        return Direction.m_122387_((Direction.Axis)axis, (Direction.AxisDirection)(this.getBeltMovementSpeed() < 0.0f ^ axis == Direction.Axis.X ? Direction.AxisDirection.NEGATIVE : Direction.AxisDirection.POSITIVE));
    }

    protected Direction getBeltFacing() {
        return (Direction)this.m_58900_().m_61143_((Property)BlockStateProperties.f_61374_);
    }

    public BeltInventory getInventory() {
        if (!this.isController()) {
            BeltBlockEntity controllerBE = this.getControllerBE();
            if (controllerBE != null) {
                return controllerBE.getInventory();
            }
            return null;
        }
        if (this.inventory == null) {
            this.inventory = new BeltInventory(this);
        }
        return this.inventory;
    }

    private void applyToAllItems(float maxDistanceFromCenter, Function<TransportedItemStack, TransportedItemStackHandlerBehaviour.TransportedResult> processFunction) {
        BeltBlockEntity controller = this.getControllerBE();
        if (controller == null) {
            return;
        }
        BeltInventory inventory = controller.getInventory();
        if (inventory != null) {
            inventory.applyToEachWithin((float)this.index + 0.5f, maxDistanceFromCenter, processFunction);
        }
    }

    private Vec3 getWorldPositionOf(TransportedItemStack transported) {
        BeltBlockEntity controllerBE = this.getControllerBE();
        if (controllerBE == null) {
            return Vec3.f_82478_;
        }
        return BeltHelper.getVectorForOffset(controllerBE, transported.beltPosition);
    }

    public void setCasingType(CasingType type) {
        boolean shouldBlockHaveCasing;
        if (this.casing == type) {
            return;
        }
        BlockState blockState = this.m_58900_();
        boolean bl = shouldBlockHaveCasing = type != CasingType.NONE;
        if (this.f_58857_.f_46443_) {
            this.casing = type;
            this.f_58857_.m_7731_(this.f_58858_, (BlockState)blockState.m_61124_((Property)BeltBlock.CASING, (Comparable)Boolean.valueOf(shouldBlockHaveCasing)), 0);
            this.requestModelDataUpdate();
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 16);
            return;
        }
        if (this.casing != CasingType.NONE) {
            this.f_58857_.m_46796_(2001, this.f_58858_, Block.m_49956_((BlockState)(this.casing == CasingType.ANDESITE ? AllBlocks.ANDESITE_CASING.getDefaultState() : AllBlocks.BRASS_CASING.getDefaultState())));
        }
        if ((Boolean)blockState.m_61143_((Property)BeltBlock.CASING) != shouldBlockHaveCasing) {
            KineticBlockEntity.switchToBlockState(this.f_58857_, this.f_58858_, (BlockState)blockState.m_61124_((Property)BeltBlock.CASING, (Comparable)Boolean.valueOf(shouldBlockHaveCasing)));
        }
        this.casing = type;
        this.m_6596_();
        this.sendData();
    }

    private boolean canInsertFrom(Direction side) {
        if (this.getSpeed() == 0.0f) {
            return false;
        }
        BlockState state = this.m_58900_();
        if (state.m_61138_(BeltBlock.SLOPE) && (state.m_61143_(BeltBlock.SLOPE) == BeltSlope.SIDEWAYS || state.m_61143_(BeltBlock.SLOPE) == BeltSlope.VERTICAL)) {
            return false;
        }
        return this.getMovementFacing() != side.m_122424_();
    }

    private boolean isOccupied(Direction side) {
        BeltBlockEntity nextBeltController = this.getControllerBE();
        if (nextBeltController == null) {
            return true;
        }
        BeltInventory nextInventory = nextBeltController.getInventory();
        if (nextInventory == null) {
            return true;
        }
        if (this.getSpeed() == 0.0f) {
            return true;
        }
        if (this.getMovementFacing() == side.m_122424_()) {
            return true;
        }
        return !nextInventory.canInsertAtFromSide(this.index, side);
    }

    private ItemStack tryInsertingFromSide(TransportedItemStack transportedStack, Direction side, boolean simulate) {
        BrassTunnelBlockEntity tunnelBE;
        BeltBlockEntity nextBeltController = this.getControllerBE();
        ItemStack inserted = transportedStack.stack;
        ItemStack empty = ItemStack.f_41583_;
        if (!BeltBlock.canTransportObjects(this.m_58900_())) {
            return inserted;
        }
        if (nextBeltController == null) {
            return inserted;
        }
        BeltInventory nextInventory = nextBeltController.getInventory();
        if (nextInventory == null) {
            return inserted;
        }
        BlockEntity teAbove = this.f_58857_.m_7702_(this.f_58858_.m_7494_());
        if (teAbove instanceof BrassTunnelBlockEntity && (tunnelBE = (BrassTunnelBlockEntity)teAbove).hasDistributionBehaviour()) {
            if (!tunnelBE.getStackToDistribute().m_41619_()) {
                return inserted;
            }
            if (!tunnelBE.testFlapFilter(side.m_122424_(), inserted)) {
                return inserted;
            }
            if (!simulate) {
                BeltTunnelInteractionHandler.flapTunnel(nextInventory, this.index, side.m_122424_(), true);
                tunnelBE.setStackToDistribute(inserted, side.m_122424_());
            }
            return empty;
        }
        if (this.isOccupied(side)) {
            return inserted;
        }
        if (simulate) {
            return empty;
        }
        transportedStack = transportedStack.copy();
        transportedStack.beltPosition = (float)this.index + 0.5f - Math.signum(this.getDirectionAwareBeltMovementSpeed()) / 16.0f;
        Direction movementFacing = this.getMovementFacing();
        if (!side.m_122434_().m_122478_()) {
            if (movementFacing != side) {
                transportedStack.sideOffset = (float)side.m_122421_().m_122540_() * 0.675f;
                if (side.m_122434_() == Direction.Axis.X) {
                    transportedStack.sideOffset *= -1.0f;
                }
            } else {
                float extraOffset = transportedStack.prevBeltPosition != 0.0f && BeltHelper.getSegmentBE((LevelAccessor)this.f_58857_, this.f_58858_.m_121945_(movementFacing.m_122424_())) != null ? 0.26f : 0.0f;
                transportedStack.beltPosition = this.getDirectionAwareBeltMovementSpeed() > 0.0f ? (float)this.index - extraOffset : (float)(this.index + 1) + extraOffset;
            }
        }
        transportedStack.prevSideOffset = transportedStack.sideOffset;
        transportedStack.insertedAt = this.index;
        transportedStack.insertedFrom = side;
        transportedStack.prevBeltPosition = transportedStack.beltPosition;
        BeltTunnelInteractionHandler.flapTunnel(nextInventory, this.index, side.m_122424_(), true);
        nextInventory.addItem(transportedStack);
        nextBeltController.m_6596_();
        nextBeltController.sendData();
        return empty;
    }

    public ModelData getModelData() {
        return ModelData.builder().with(BeltModel.CASING_PROPERTY, (Object)this.casing).with(BeltModel.COVER_PROPERTY, (Object)this.covered).build();
    }

    @Override
    protected boolean canPropagateDiagonally(IRotate block, BlockState state) {
        return state.m_61138_(BeltBlock.SLOPE) && (state.m_61143_(BeltBlock.SLOPE) == BeltSlope.UPWARD || state.m_61143_(BeltBlock.SLOPE) == BeltSlope.DOWNWARD);
    }

    @Override
    public float propagateRotationTo(KineticBlockEntity target, BlockState stateFrom, BlockState stateTo, BlockPos diff, boolean connectedViaAxes, boolean connectedViaCogs) {
        if (target instanceof BeltBlockEntity && !connectedViaAxes) {
            return this.getController().equals((Object)((BeltBlockEntity)target).getController()) ? 1.0f : 0.0f;
        }
        return 0.0f;
    }

    public void invalidateItemHandler() {
        this.itemHandler.invalidate();
    }

    public boolean shouldRenderNormally() {
        if (this.f_58857_ == null) {
            return this.isController();
        }
        BlockState state = this.m_58900_();
        return state != null && state.m_61138_(BeltBlock.PART) && state.m_61143_(BeltBlock.PART) == BeltPart.START;
    }

    public void setCovered(boolean blockCoveringBelt) {
        if (blockCoveringBelt == this.covered) {
            return;
        }
        this.covered = blockCoveringBelt;
        this.notifyUpdate();
    }

    public static enum CasingType {
        NONE,
        ANDESITE,
        BRASS;

    }
}

