/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.equipment.toolbox;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllPackets;
import com.simibubi.create.AllPartialModels;
import com.simibubi.create.content.equipment.toolbox.ToolboxBlockEntity;
import com.simibubi.create.content.equipment.toolbox.ToolboxDisposeAllPacket;
import com.simibubi.create.content.equipment.toolbox.ToolboxMenu;
import com.simibubi.create.foundation.gui.AllGuiTextures;
import com.simibubi.create.foundation.gui.AllIcons;
import com.simibubi.create.foundation.gui.menu.AbstractSimiContainerScreen;
import com.simibubi.create.foundation.gui.widget.IconButton;
import com.simibubi.create.foundation.utility.CreateLang;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import dev.engine_room.flywheel.lib.transform.PoseTransformStack;
import dev.engine_room.flywheel.lib.transform.TransformStack;
import java.util.Collections;
import java.util.List;
import net.createmod.catnip.data.Iterate;
import net.createmod.catnip.gui.element.GuiGameElement;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;

public class ToolboxScreen
extends AbstractSimiContainerScreen<ToolboxMenu> {
    protected static final AllGuiTextures BG = AllGuiTextures.TOOLBOX;
    protected static final AllGuiTextures PLAYER = AllGuiTextures.PLAYER_INVENTORY;
    protected Slot hoveredToolboxSlot;
    private IconButton confirmButton;
    private IconButton disposeButton;
    private DyeColor color;
    private List<Rect2i> extraAreas = Collections.emptyList();

    public ToolboxScreen(ToolboxMenu menu, Inventory inv, Component title) {
        super(menu, inv, title);
        this.m_7856_();
    }

    @Override
    protected void m_7856_() {
        this.setWindowSize(30 + BG.getWidth(), BG.getHeight() + PLAYER.getHeight() - 24);
        this.setWindowOffset(-11, 0);
        super.m_7856_();
        this.m_169413_();
        this.color = ((ToolboxBlockEntity)((ToolboxMenu)this.f_97732_).contentHolder).getColor();
        this.confirmButton = new IconButton(this.f_97735_ + 30 + BG.getWidth() - 33, this.f_97736_ + BG.getHeight() - 24, AllIcons.I_CONFIRM);
        this.confirmButton.withCallback(() -> this.f_96541_.f_91074_.m_6915_());
        this.m_142416_((GuiEventListener)this.confirmButton);
        this.disposeButton = new IconButton(this.f_97735_ + 30 + 81, this.f_97736_ + 69, AllIcons.I_TOOLBOX);
        this.disposeButton.withCallback(() -> AllPackets.getChannel().sendToServer((Object)new ToolboxDisposeAllPacket(((ToolboxBlockEntity)((ToolboxMenu)this.f_97732_).contentHolder).m_58899_())));
        this.disposeButton.setToolTip((Component)CreateLang.translateDirect("toolbox.depositBox", new Object[0]));
        this.m_142416_((GuiEventListener)this.disposeButton);
        this.extraAreas = ImmutableList.of((Object)new Rect2i(this.f_97735_ + 30 + BG.getWidth(), this.f_97736_ + BG.getHeight() - 15 - 34 - 6, 72, 68));
    }

    @Override
    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        ((ToolboxMenu)this.f_97732_).renderPass = true;
        super.m_88315_(graphics, mouseX, mouseY, partialTicks);
        ((ToolboxMenu)this.f_97732_).renderPass = false;
    }

    protected void m_7286_(GuiGraphics graphics, float partialTicks, int mouseX, int mouseY) {
        int x = this.f_97735_ + this.f_97726_ - BG.getWidth();
        int y = this.f_97736_;
        BG.render(graphics, x, y);
        graphics.m_280614_(this.f_96547_, this.f_96539_, x + 15, y + 4, 5841956, false);
        int invX = this.f_97735_;
        int invY = this.f_97736_ + this.f_97727_ - PLAYER.getHeight();
        this.renderPlayerInventory(graphics, invX, invY);
        this.renderToolbox(graphics, x + BG.getWidth() + 50, y + BG.getHeight() + 12, partialTicks);
        PoseStack ms = graphics.m_280168_();
        this.hoveredToolboxSlot = null;
        for (int compartment = 0; compartment < 8; ++compartment) {
            int baseIndex = compartment * 4;
            Slot slot = (Slot)((ToolboxMenu)this.f_97732_).f_38839_.get(baseIndex);
            ItemStack itemstack = slot.m_7993_();
            int i = slot.f_40220_ + this.f_97735_;
            int j = slot.f_40221_ + this.f_97736_;
            if (itemstack.m_41619_()) {
                itemstack = ((ToolboxMenu)this.f_97732_).getFilter(compartment);
            }
            if (!itemstack.m_41619_()) {
                int count = ((ToolboxMenu)this.f_97732_).totalCountInCompartment(compartment);
                String s = String.valueOf(count);
                ms.m_85836_();
                ms.m_252880_(0.0f, 0.0f, 100.0f);
                RenderSystem.enableDepthTest();
                graphics.m_280638_((LivingEntity)this.f_96541_.f_91074_, itemstack, i, j, 0);
                graphics.m_280302_(this.f_96547_, itemstack, i, j, s);
                ms.m_85849_();
            }
            if (!this.m_6774_(slot.f_40220_, slot.f_40221_, 16, 16, mouseX, mouseY)) continue;
            this.hoveredToolboxSlot = slot;
            RenderSystem.disableDepthTest();
            RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)false);
            int slotColor = this.getSlotColor(baseIndex);
            graphics.m_280024_(i, j, i + 16, j + 16, slotColor, slotColor);
            RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
            RenderSystem.enableDepthTest();
        }
    }

    private void renderToolbox(GuiGraphics graphics, int x, int y, float partialTicks) {
        PoseStack ms = graphics.m_280168_();
        ((PoseTransformStack)((PoseTransformStack)TransformStack.of((PoseStack)ms).pushPose().translate((float)x, (float)y, 100.0f).scale(50.0f)).rotateXDegrees(-22.0f)).rotateYDegrees(-202.0f);
        GuiGameElement.of((BlockState)AllBlocks.TOOLBOXES.get(this.color).getDefaultState()).render(graphics);
        ((PoseTransformStack)TransformStack.of((PoseStack)ms).pushPose().translate(0.0f, -0.375f, 0.75f).rotateXDegrees(-105.0f * ((ToolboxBlockEntity)((ToolboxMenu)this.f_97732_).contentHolder).lid.getValue(partialTicks))).translate(0.0f, 0.375f, -0.75f);
        GuiGameElement.of((PartialModel)AllPartialModels.TOOLBOX_LIDS.get(this.color)).render(graphics);
        ms.m_85849_();
        for (int offset : Iterate.zeroAndOne) {
            ms.m_85836_();
            ms.m_252880_(0.0f, (float)(-offset * 1) / 8.0f, ((ToolboxBlockEntity)((ToolboxMenu)this.f_97732_).contentHolder).drawers.getValue(partialTicks) * -0.175f * (float)(2 - offset));
            GuiGameElement.of((PartialModel)AllPartialModels.TOOLBOX_DRAWER).render(graphics);
            ms.m_85849_();
        }
        ms.m_85849_();
    }

    @Override
    protected void renderForeground(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        if (this.hoveredToolboxSlot != null) {
            this.f_97734_ = this.hoveredToolboxSlot;
        }
        super.renderForeground(graphics, mouseX, mouseY, partialTicks);
    }

    @Override
    public List<Rect2i> getExtraAreas() {
        return this.extraAreas;
    }
}

