/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.equipment.tool;

import com.simibubi.create.AllItems;
import com.simibubi.create.AllPackets;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.content.equipment.tool.AllToolMaterials;
import com.simibubi.create.content.equipment.tool.CardboardSwordItemRenderer;
import com.simibubi.create.content.equipment.tool.KnockbackPacket;
import com.simibubi.create.foundation.item.render.SimpleCustomRenderer;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Mod.EventBusSubscriber
public class CardboardSwordItem
extends SwordItem {
    public CardboardSwordItem(Item.Properties pProperties) {
        super((Tier)AllToolMaterials.CARDBOARD, 3, 1.0f, pProperties);
    }

    public int getBurnTime(ItemStack itemStack, @Nullable RecipeType<?> recipeType) {
        return 1000;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return enchantment == Enchantments.f_44980_;
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        Map enchants = EnchantmentHelper.m_44831_((ItemStack)book);
        for (Enchantment enchantment : enchants.keySet()) {
            if (enchantment == Enchantments.f_44980_) continue;
            return false;
        }
        return true;
    }

    public int getDefaultTooltipHideFlags(@NotNull ItemStack stack) {
        return ItemStack.TooltipPart.MODIFIERS.m_41809_();
    }

    @SubscribeEvent
    public static void cardboardSwordsMakeNoiseOnClick(PlayerInteractEvent.LeftClickBlock event) {
        ItemStack itemStack = event.getItemStack();
        if (!AllItems.CARDBOARD_SWORD.isIn(itemStack)) {
            return;
        }
        if (event.getAction() != PlayerInteractEvent.LeftClickBlock.Action.START) {
            return;
        }
        if (event.getSide() == LogicalSide.CLIENT) {
            AllSoundEvents.CARDBOARD_SWORD.playAt(event.getLevel(), (Vec3i)event.getPos(), 0.5f, 1.85f, false);
        } else {
            AllSoundEvents.CARDBOARD_SWORD.play(event.getLevel(), event.getEntity(), (Vec3i)event.getPos(), 0.5f, 1.85f);
        }
    }

    @SubscribeEvent
    public static void cardboardSwordsCannotHurtYou(LivingAttackEvent event) {
        Player p;
        LivingEntity livingAttacker;
        Entity attacker = event.getSource().m_7639_();
        LivingEntity target = event.getEntity();
        if (target == null || target.m_6336_() == MobType.f_21642_) {
            return;
        }
        if (!(attacker instanceof LivingEntity) || !AllItems.CARDBOARD_SWORD.isIn((livingAttacker = (LivingEntity)attacker).m_21120_(InteractionHand.MAIN_HAND))) {
            return;
        }
        AllSoundEvents.CARDBOARD_SWORD.playFrom(attacker, 0.75f, 1.85f);
        event.setCanceled(true);
        double knockbackStrength = livingAttacker.m_21133_(Attributes.f_22282_) + 2.0;
        knockbackStrength += (double)EnchantmentHelper.m_44894_((LivingEntity)livingAttacker);
        if (livingAttacker.m_20142_() && (!(livingAttacker instanceof Player) || (p = (Player)livingAttacker).m_36403_(0.5f) > 0.9f)) {
            knockbackStrength += 1.0;
        }
        if (knockbackStrength <= 0.0) {
            return;
        }
        float yRot = livingAttacker.m_146908_();
        CardboardSwordItem.knockback(target, knockbackStrength, yRot);
        boolean targetIsPlayer = target instanceof Player;
        MobCategory targetType = target.getClassification(false);
        if (target instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)target;
            AllPackets.getChannel().send(PacketDistributor.PLAYER.with(() -> sp), (Object)new KnockbackPacket(yRot, (float)knockbackStrength));
        }
        if (!(targetType != MobCategory.MISC && targetType != MobCategory.CREATURE || targetIsPlayer)) {
            target.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 60, 9, true, false, false));
        }
        livingAttacker.m_20256_(livingAttacker.m_20184_().m_82542_(0.6, 1.0, 0.6));
        livingAttacker.m_6858_(false);
    }

    public static void knockback(LivingEntity target, double knockbackStrength, float yRot) {
        target.m_8127_();
        target.m_147240_(knockbackStrength * 0.5, (double)Mth.m_14031_((float)(yRot * ((float)Math.PI / 180))), (double)(-Mth.m_14089_((float)(yRot * ((float)Math.PI / 180)))));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(SimpleCustomRenderer.create((Item)this, new CardboardSwordItemRenderer()));
    }
}

