/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.equipment.potatoCannon;

import com.simibubi.create.AllEnchantments;
import com.simibubi.create.AllEntityTypes;
import com.simibubi.create.CreateClient;
import com.simibubi.create.api.equipment.potatoCannon.PotatoCannonProjectileType;
import com.simibubi.create.content.equipment.armor.BacktankUtil;
import com.simibubi.create.content.equipment.potatoCannon.PotatoCannonItemRenderer;
import com.simibubi.create.content.equipment.potatoCannon.PotatoCannonPacket;
import com.simibubi.create.content.equipment.potatoCannon.PotatoProjectileEntity;
import com.simibubi.create.content.equipment.zapper.ShootableGadgetItemMethods;
import com.simibubi.create.foundation.item.CustomArmPoseItem;
import com.simibubi.create.foundation.item.render.SimpleCustomRenderer;
import com.simibubi.create.foundation.utility.CreateLang;
import com.simibubi.create.foundation.utility.GlobalRegistryAccess;
import com.simibubi.create.infrastructure.config.AllConfigs;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.createmod.catnip.math.VecHelper;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import org.jetbrains.annotations.Nullable;

public class PotatoCannonItem
extends ProjectileWeaponItem
implements CustomArmPoseItem {
    public static final int MAX_DAMAGE = 100;

    public PotatoCannonItem(Item.Properties properties) {
        super(properties.m_41499_(100));
    }

    @Nullable
    public static Ammo getAmmo(Player player, ItemStack heldStack) {
        ItemStack ammoStack = player.m_6298_(heldStack);
        if (ammoStack.m_41619_()) {
            return null;
        }
        Optional<Holder.Reference<PotatoCannonProjectileType>> optionalType = PotatoCannonProjectileType.getTypeForItem(player.m_9236_().m_9598_(), ammoStack.m_41720_());
        if (optionalType.isEmpty()) {
            return null;
        }
        return new Ammo(ammoStack, (PotatoCannonProjectileType)optionalType.get().m_203334_());
    }

    public InteractionResult m_6225_(UseOnContext context) {
        return this.m_7203_(context.m_43725_(), context.m_43723_(), context.m_43724_()).m_19089_();
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack heldStack = player.m_21120_(hand);
        if (ShootableGadgetItemMethods.shouldSwap(player, heldStack, hand, s -> s.m_41720_() instanceof PotatoCannonItem)) {
            return InteractionResultHolder.m_19100_((Object)heldStack);
        }
        Ammo ammo = PotatoCannonItem.getAmmo(player, heldStack);
        if (ammo == null) {
            return InteractionResultHolder.m_19098_((Object)heldStack);
        }
        ItemStack ammoStack = ammo.stack();
        PotatoCannonProjectileType projectileType = ammo.type();
        if (level.f_46443_) {
            CreateClient.POTATO_CANNON_RENDER_HANDLER.dontAnimateItem(hand);
            return InteractionResultHolder.m_19090_((Object)heldStack);
        }
        Vec3 barrelPos = ShootableGadgetItemMethods.getGunBarrelVec(player, hand == InteractionHand.MAIN_HAND, new Vec3(0.75, (double)-0.15f, 1.5));
        Vec3 correction = ShootableGadgetItemMethods.getGunBarrelVec(player, hand == InteractionHand.MAIN_HAND, new Vec3((double)-0.05f, 0.0, 0.0)).m_82546_(player.m_20182_().m_82520_(0.0, (double)player.m_20192_(), 0.0));
        Vec3 lookVec = player.m_20154_();
        Vec3 motion = lookVec.m_82549_(correction).m_82541_().m_82490_(2.0).m_82490_((double)projectileType.velocityMultiplier());
        float soundPitch = projectileType.soundPitch() + (level.m_213780_().m_188501_() - 0.5f) / 4.0f;
        boolean spray = projectileType.split() > 1;
        Vec3 sprayBase = VecHelper.rotate((Vec3)new Vec3(0.0, 0.1, 0.0), (double)(360.0f * level.m_213780_().m_188501_()), (Direction.Axis)Direction.Axis.Z);
        float sprayChange = 360.0f / (float)projectileType.split();
        ItemStack ammoStackCopy = ammoStack.m_41777_();
        for (int i = 0; i < projectileType.split(); ++i) {
            PotatoProjectileEntity projectile = (PotatoProjectileEntity)AllEntityTypes.POTATO_PROJECTILE.create(level);
            projectile.setItem(ammoStackCopy);
            projectile.setEnchantmentEffectsFromCannon(heldStack);
            Vec3 splitMotion = motion;
            if (spray) {
                float imperfection = 40.0f * (level.m_213780_().m_188501_() - 0.5f);
                Vec3 sprayOffset = VecHelper.rotate((Vec3)sprayBase, (double)((float)i * sprayChange + imperfection), (Direction.Axis)Direction.Axis.Z);
                splitMotion = splitMotion.m_82549_(VecHelper.lookAt((Vec3)sprayOffset, (Vec3)motion));
            }
            if (i != 0) {
                projectile.recoveryChance = 0.0f;
            }
            projectile.m_6034_(barrelPos.f_82479_, barrelPos.f_82480_, barrelPos.f_82481_);
            projectile.m_20256_(splitMotion);
            projectile.m_5602_((Entity)player);
            level.m_7967_((Entity)projectile);
        }
        if (!player.m_7500_()) {
            ammoStack.m_41774_(1);
            if (ammoStack.m_41619_()) {
                player.m_150109_().m_36057_(ammoStack);
            }
        }
        if (!BacktankUtil.canAbsorbDamage((LivingEntity)player, PotatoCannonItem.maxUses())) {
            heldStack.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(hand));
        }
        ShootableGadgetItemMethods.applyCooldown(player, heldStack, hand, s -> s.m_41720_() instanceof PotatoCannonItem, projectileType.reloadTicks());
        ShootableGadgetItemMethods.sendPackets(player, b -> new PotatoCannonPacket(barrelPos, lookVec.m_82541_(), ammoStack, hand, soundPitch, (boolean)b));
        return InteractionResultHolder.m_19090_((Object)heldStack);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            super.m_7373_(stack, level, tooltip, flag);
            return;
        }
        Ammo ammo = PotatoCannonItem.getAmmo((Player)player, stack);
        if (ammo == null) {
            super.m_7373_(stack, level, tooltip, flag);
            return;
        }
        ItemStack ammoStack = ammo.stack();
        PotatoCannonProjectileType type = ammo.type();
        int power = stack.getEnchantmentLevel(Enchantments.f_44988_);
        int punch = stack.getEnchantmentLevel(Enchantments.f_44989_);
        float additionalDamageMult = 1.0f + (float)power * 0.2f;
        float additionalKnockback = (float)punch * 0.5f;
        String _attack = "potato_cannon.ammo.attack_damage";
        String _reload = "potato_cannon.ammo.reload_ticks";
        String _knockback = "potato_cannon.ammo.knockback";
        tooltip.add(CommonComponents.f_237098_);
        tooltip.add((Component)Component.m_237115_((String)ammoStack.m_41778_()).m_7220_((Component)Component.m_237113_((String)":")).m_130940_(ChatFormatting.GRAY));
        MutableComponent spacing = CommonComponents.m_264333_();
        ChatFormatting green = ChatFormatting.GREEN;
        ChatFormatting darkGreen = ChatFormatting.DARK_GREEN;
        float damageF = (float)type.damage() * additionalDamageMult;
        MutableComponent damage = Component.m_237113_((String)(damageF == (float)Mth.m_14143_((float)damageF) ? "" + Mth.m_14143_((float)damageF) : "" + damageF));
        MutableComponent reloadTicks = Component.m_237113_((String)("" + type.reloadTicks()));
        MutableComponent knockback = Component.m_237113_((String)("" + (type.knockback() + additionalKnockback)));
        damage = damage.m_130940_(additionalDamageMult > 1.0f ? green : darkGreen);
        knockback = knockback.m_130940_(additionalKnockback > 0.0f ? green : darkGreen);
        reloadTicks = reloadTicks.m_130940_(darkGreen);
        tooltip.add((Component)spacing.m_6879_().m_7220_((Component)CreateLang.translateDirect(_attack, damage).m_130940_(darkGreen)));
        tooltip.add((Component)spacing.m_6879_().m_7220_((Component)CreateLang.translateDirect(_reload, reloadTicks).m_130940_(darkGreen)));
        tooltip.add((Component)spacing.m_6879_().m_7220_((Component)CreateLang.translateDirect(_knockback, knockback).m_130940_(darkGreen)));
        super.m_7373_(stack, level, tooltip, flag);
    }

    public boolean m_6777_(BlockState state, Level world, BlockPos pos, Player player) {
        return false;
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return slotChanged || newStack.m_41720_() != oldStack.m_41720_();
    }

    public Predicate<ItemStack> m_6437_() {
        return stack -> PotatoCannonProjectileType.getTypeForItem(GlobalRegistryAccess.getOrThrow(), stack.m_41720_()).isPresent();
    }

    public int m_6615_() {
        return 15;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        if (enchantment == Enchantments.f_44988_) {
            return true;
        }
        if (enchantment == Enchantments.f_44989_) {
            return true;
        }
        if (enchantment == Enchantments.f_44990_) {
            return true;
        }
        if (enchantment == Enchantments.f_44982_) {
            return true;
        }
        if (enchantment == AllEnchantments.POTATO_RECOVERY.get()) {
            return true;
        }
        return super.canApplyAtEnchantingTable(stack, enchantment);
    }

    public boolean m_142522_(ItemStack stack) {
        return BacktankUtil.isBarVisible(stack, PotatoCannonItem.maxUses());
    }

    public int m_142158_(ItemStack stack) {
        return BacktankUtil.getBarWidth(stack, PotatoCannonItem.maxUses());
    }

    public int m_142159_(ItemStack stack) {
        return BacktankUtil.getBarColor(stack, PotatoCannonItem.maxUses());
    }

    private static int maxUses() {
        return (Integer)AllConfigs.server().equipment.maxPotatoCannonShots.get();
    }

    public boolean onEntitySwing(ItemStack stack, LivingEntity entity) {
        return true;
    }

    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.NONE;
    }

    @Override
    @Nullable
    public HumanoidModel.ArmPose getArmPose(ItemStack stack, AbstractClientPlayer player, InteractionHand hand) {
        if (!player.f_20911_) {
            return HumanoidModel.ArmPose.CROSSBOW_HOLD;
        }
        return null;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(SimpleCustomRenderer.create((Item)this, new PotatoCannonItemRenderer()));
    }

    public record Ammo(ItemStack stack, PotatoCannonProjectileType type) {
    }
}

