/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.equipment.hats;

import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.content.equipment.hats.EntityHats;
import com.simibubi.create.content.trains.schedule.hat.TrainHatInfo;
import com.simibubi.create.content.trains.schedule.hat.TrainHatInfoReloadListener;
import com.simibubi.create.foundation.mixin.accessor.AgeableListModelAccessor;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import dev.engine_room.flywheel.lib.transform.PoseTransformStack;
import dev.engine_room.flywheel.lib.transform.TransformStack;
import java.util.ArrayList;
import java.util.Iterator;
import net.createmod.catnip.render.CachedBuffers;
import net.minecraft.client.model.AgeableListModel;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class CreateHatArmorLayer<T extends LivingEntity, M extends EntityModel<T>>
extends RenderLayer<T, M> {
    public CreateHatArmorLayer(RenderLayerParent<T, M> renderer) {
        super(renderer);
    }

    public void render(PoseStack ms, MultiBufferSource buffer, int light, LivingEntity entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        PartialModel hat = EntityHats.getHatFor(entity);
        if (hat == null) {
            return;
        }
        EntityModel entityModel = this.m_117386_();
        ms.m_85836_();
        PoseTransformStack msr = TransformStack.of((PoseStack)ms);
        TrainHatInfo info = TrainHatInfoReloadListener.getHatInfoFor(entity.m_6095_());
        ArrayList<ModelPart> partsToHead = new ArrayList<ModelPart>();
        if (entityModel instanceof AgeableListModel) {
            ModelPart head;
            AgeableListModel model = (AgeableListModel)entityModel;
            if (model.f_102610_) {
                if (model.f_102007_) {
                    float f = 1.5f / model.f_102010_;
                    ms.m_85841_(f, f, f);
                }
                ms.m_85837_(0.0, (double)(model.f_170338_ / 16.0f), (double)(model.f_170339_ / 16.0f));
            }
            if ((head = CreateHatArmorLayer.getHeadPart(model)) != null) {
                partsToHead.addAll(TrainHatInfo.getAdjustedPart(info, head, ""));
            }
        } else if (entityModel instanceof HierarchicalModel) {
            HierarchicalModel model = (HierarchicalModel)entityModel;
            partsToHead.addAll(TrainHatInfo.getAdjustedPart(info, model.m_142109_(), "head"));
        }
        if (!partsToHead.isEmpty()) {
            partsToHead.forEach(part -> part.m_104299_(ms));
            ModelPart lastChild = (ModelPart)partsToHead.get(partsToHead.size() - 1);
            if (!lastChild.m_171326_()) {
                ModelPart.Cube cube = (ModelPart.Cube)lastChild.f_104212_.get(Mth.m_14045_((int)info.cubeIndex(), (int)0, (int)(lastChild.f_104212_.size() - 1)));
                ms.m_85837_(info.offset().m_7096_() / 16.0, ((double)(cube.f_104336_ - cube.f_104339_) + info.offset().m_7098_()) / 16.0, info.offset().m_7094_() / 16.0);
                float max = Math.max(cube.f_104338_ - cube.f_104335_, cube.f_104340_ - cube.f_104337_) / 8.0f * info.scale();
                ms.m_85841_(max, max, max);
            }
            ms.m_85841_(1.0f, -1.0f, -1.0f);
            ms.m_252880_(0.0f, -0.140625f, 0.0f);
            msr.rotateXDegrees(-8.5f);
            BlockState air = Blocks.f_50016_.m_49966_();
            CachedBuffers.partial((PartialModel)hat, (BlockState)air).disableDiffuse().light(light).renderInto(ms, buffer.m_6299_(Sheets.m_110790_()));
        }
        ms.m_85849_();
    }

    public static void registerOnAll(EntityRenderDispatcher renderManager) {
        for (EntityRenderer renderer : renderManager.getSkinMap().values()) {
            CreateHatArmorLayer.registerOn(renderer);
        }
        for (EntityRenderer renderer : renderManager.f_114362_.values()) {
            CreateHatArmorLayer.registerOn(renderer);
        }
    }

    public static void registerOn(EntityRenderer<?> entityRenderer) {
        if (!(entityRenderer instanceof LivingEntityRenderer)) {
            return;
        }
        LivingEntityRenderer livingRenderer = (LivingEntityRenderer)entityRenderer;
        EntityModel model = livingRenderer.m_7200_();
        if (!(model instanceof HierarchicalModel) && !(model instanceof AgeableListModel)) {
            return;
        }
        CreateHatArmorLayer layer = new CreateHatArmorLayer(livingRenderer);
        livingRenderer.m_115326_(layer);
    }

    private static ModelPart getHeadPart(AgeableListModel<?> model) {
        Iterator<ModelPart> iterator = ((AgeableListModelAccessor)model).create$callHeadParts().iterator();
        if (iterator.hasNext()) {
            ModelPart part = iterator.next();
            return part;
        }
        iterator = ((AgeableListModelAccessor)model).create$callBodyParts().iterator();
        if (iterator.hasNext()) {
            ModelPart part = iterator.next();
            return part;
        }
        return null;
    }
}

