/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.sync;

import com.simibubi.create.foundation.networking.SimplePacketBase;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkEvent;

public class LimbSwingUpdatePacket
extends SimplePacketBase {
    private int entityId;
    private Vec3 position;
    private float limbSwing;

    public LimbSwingUpdatePacket(int entityId, Vec3 position, float limbSwing) {
        this.entityId = entityId;
        this.position = position;
        this.limbSwing = limbSwing;
    }

    public LimbSwingUpdatePacket(FriendlyByteBuf buffer) {
        this.entityId = buffer.readInt();
        this.position = new Vec3(buffer.readDouble(), buffer.readDouble(), buffer.readDouble());
        this.limbSwing = buffer.readFloat();
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
        buffer.writeInt(this.entityId);
        buffer.writeDouble(this.position.f_82479_);
        buffer.writeDouble(this.position.f_82480_);
        buffer.writeDouble(this.position.f_82481_);
        buffer.writeFloat(this.limbSwing);
    }

    @Override
    public boolean handle(NetworkEvent.Context context) {
        context.enqueueWork(() -> {
            ClientLevel world = Minecraft.m_91087_().f_91073_;
            if (world == null) {
                return;
            }
            Entity entity = world.m_6815_(this.entityId);
            if (entity == null) {
                return;
            }
            CompoundTag data = entity.getPersistentData();
            data.m_128405_("LastOverrideLimbSwingUpdate", 0);
            data.m_128350_("OverrideLimbSwing", this.limbSwing);
            entity.m_6453_(this.position.f_82479_, this.position.f_82480_, this.position.f_82481_, entity.m_146908_(), entity.m_146909_(), 2, false);
        });
        return true;
    }
}

