/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions;

import com.simibubi.create.foundation.utility.CreateLang;
import com.simibubi.create.infrastructure.config.AllConfigs;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.block.state.BlockState;

public class AssemblyException
extends Exception {
    private static final long serialVersionUID = 1L;
    public final Component component;
    private BlockPos position = null;

    public static void write(CompoundTag compound, AssemblyException exception) {
        if (exception == null) {
            return;
        }
        CompoundTag nbt = new CompoundTag();
        nbt.m_128359_("Component", Component.Serializer.m_130703_((Component)exception.component));
        if (exception.hasPosition()) {
            nbt.m_128356_("Position", exception.getPosition().m_121878_());
        }
        compound.m_128365_("LastException", (Tag)nbt);
    }

    public static AssemblyException read(CompoundTag compound) {
        if (!compound.m_128441_("LastException")) {
            return null;
        }
        CompoundTag nbt = compound.m_128469_("LastException");
        String string = nbt.m_128461_("Component");
        AssemblyException exception = new AssemblyException((Component)Component.Serializer.m_130701_((String)string));
        if (nbt.m_128441_("Position")) {
            exception.position = BlockPos.m_122022_((long)nbt.m_128454_("Position"));
        }
        return exception;
    }

    public AssemblyException(Component component) {
        this.component = component;
    }

    public AssemblyException(String langKey, Object ... objects) {
        this((Component)CreateLang.translateDirect("gui.assembly.exception." + langKey, objects));
    }

    public static AssemblyException unmovableBlock(BlockPos pos, BlockState state) {
        AssemblyException e = new AssemblyException("unmovableBlock", pos.m_123341_(), pos.m_123342_(), pos.m_123343_(), state.m_60734_().m_49954_());
        e.position = pos;
        return e;
    }

    public static AssemblyException unloadedChunk(BlockPos pos) {
        AssemblyException e = new AssemblyException("chunkNotLoaded", pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
        e.position = pos;
        return e;
    }

    public static AssemblyException structureTooLarge() {
        return new AssemblyException("structureTooLarge", AllConfigs.server().kinetics.maxBlocksMoved.get());
    }

    public static AssemblyException tooManyPistonPoles() {
        return new AssemblyException("tooManyPistonPoles", AllConfigs.server().kinetics.maxPistonPoles.get());
    }

    public static AssemblyException noPistonPoles() {
        return new AssemblyException("noPistonPoles", new Object[0]);
    }

    public static AssemblyException notEnoughSails(int sails) {
        return new AssemblyException("not_enough_sails", sails, AllConfigs.server().kinetics.minimumWindmillSails.get());
    }

    public boolean hasPosition() {
        return this.position != null;
    }

    public BlockPos getPosition() {
        return this.position;
    }
}

