/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.api.contraption.dispenser;

import com.simibubi.create.api.contraption.dispenser.MountedDispenseBehavior;
import com.simibubi.create.content.contraptions.behaviour.MovementContext;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.HopperBlockEntity;
import net.minecraft.world.phys.Vec3;

public class DefaultMountedDispenseBehavior
implements MountedDispenseBehavior {
    public static final MountedDispenseBehavior INSTANCE = new DefaultMountedDispenseBehavior();

    @Override
    public ItemStack dispense(ItemStack stack, MovementContext context, BlockPos pos) {
        Vec3 normal = MountedDispenseBehavior.getDispenserNormal(context);
        Direction closestToFacing = MountedDispenseBehavior.getClosestFacingDirection(normal);
        Container inventory = HopperBlockEntity.m_59390_((Level)context.world, (BlockPos)pos.m_121945_(closestToFacing));
        if (inventory == null) {
            ItemStack remainder = this.execute(stack, context, pos, normal);
            this.playSound((LevelAccessor)context.world, pos);
            this.playAnimation((LevelAccessor)context.world, pos, closestToFacing);
            return remainder;
        }
        ItemStack toInsert = stack.m_255036_(1);
        ItemStack remainder = HopperBlockEntity.m_59326_(null, (Container)inventory, (ItemStack)toInsert, (Direction)closestToFacing.m_122424_());
        if (remainder.m_41619_()) {
            stack.m_41774_(1);
        }
        return stack;
    }

    protected ItemStack execute(ItemStack stack, MovementContext context, BlockPos pos, Vec3 facing) {
        ItemStack toDispense = stack.m_41620_(1);
        DefaultMountedDispenseBehavior.spawnItem(context.world, toDispense, 6, facing, pos, context);
        return stack;
    }

    protected void playSound(LevelAccessor level, BlockPos pos) {
        level.m_46796_(1000, pos, 0);
    }

    protected void playAnimation(LevelAccessor level, BlockPos pos, Vec3 facing) {
        this.playAnimation(level, pos, MountedDispenseBehavior.getClosestFacingDirection(facing));
    }

    protected void playAnimation(LevelAccessor level, BlockPos pos, Direction direction) {
        level.m_46796_(2000, pos, direction.m_122411_());
    }

    public static void spawnItem(Level level, ItemStack stack, int speed, Vec3 facing, BlockPos pos, MovementContext context) {
        double x = (double)pos.m_123341_() + facing.f_82479_ + 0.5;
        double y = (double)pos.m_123342_() + facing.f_82480_ + 0.5;
        double z = (double)pos.m_123343_() + facing.f_82481_ + 0.5;
        y = MountedDispenseBehavior.getClosestFacingDirection(facing).m_122434_() == Direction.Axis.Y ? (y -= 0.125) : (y -= 0.15625);
        ItemEntity entity = new ItemEntity(level, x, y, z, stack);
        double d3 = level.f_46441_.m_188500_() * 0.1 + 0.2;
        entity.m_20334_(level.f_46441_.m_188583_() * 0.0075 * (double)speed + facing.m_7096_() * d3 + context.motion.f_82479_, level.f_46441_.m_188583_() * 0.0075 * (double)speed + facing.m_7098_() * d3 + context.motion.f_82480_, level.f_46441_.m_188583_() * 0.0075 * (double)speed + facing.m_7094_() * d3 + context.motion.f_82481_);
        level.m_7967_((Entity)entity);
    }
}

