/*
 * Decompiled with CFR 0.152.
 */
package it.crystalnest.cobweb.api.pack;

import com.google.common.base.Suppliers;
import com.google.gson.JsonElement;
import com.google.gson.internal.Streams;
import com.google.gson.stream.JsonWriter;
import it.crystalnest.cobweb.Constants;
import it.crystalnest.cobweb.api.pack.DynamicResourceType;
import it.crystalnest.cobweb.platform.Services;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import net.minecraft.SharedConstants;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.metadata.MetadataSectionSerializer;
import net.minecraft.server.packs.metadata.pack.PackMetadataSection;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.server.packs.resources.IoSupplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DynamicResourcePack
implements PackResources {
    private final PackType type;
    private final ResourceLocation name;
    private final String namespace;
    private final Set<String> namespaces = new HashSet<String>();
    private final Supplier<PackMetadataSection> metadata;
    private final Map<ResourceLocation, Supplier<byte[]>> resources = new ConcurrentHashMap<ResourceLocation, Supplier<byte[]>>();

    protected DynamicResourcePack(ResourceLocation name, PackType type) {
        this.type = type;
        this.name = name;
        this.namespace = name.m_135827_();
        this.namespaces.add(this.namespace);
        this.metadata = Suppliers.memoize(() -> new PackMetadataSection((Component)Component.m_237115_((String)(this.namespace + "_dynamic_" + name.m_135815_())), SharedConstants.m_183709_().m_264084_(type)));
    }

    public void register() {
        Services.REGISTRY.registerDynamicResourcePack(this.type, (Supplier<Pack>)Suppliers.memoize(() -> {
            this.build();
            return Pack.m_245512_((String)this.m_5542_(), (Component)Component.m_237115_((String)this.m_5542_()), (boolean)true, (Pack.ResourcesSupplier)new DynamicResourcesSupplier(this), (Pack.Info)Services.PLATFORM.createPackInfo(this.metadata.get().m_10373_(), this.metadata.get().m_10374_()), (PackType)this.type, (Pack.Position)Pack.Position.TOP, (boolean)false, (PackSource)PackSource.f_10528_);
        }));
    }

    public String toString() {
        return this.m_5542_();
    }

    @Nullable
    public IoSupplier<InputStream> m_8017_(String ... strings) {
        return null;
    }

    public IoSupplier<InputStream> m_214146_(@NotNull PackType type, @NotNull ResourceLocation id) {
        if (this.resources.containsKey(id)) {
            return () -> {
                if (this.type == type) {
                    return new ByteArrayInputStream(this.resources.get(id).get());
                }
                throw new IOException(String.format("Tried to access wrong type of resource on %s.", this.name));
            };
        }
        return null;
    }

    public void m_8031_(@NotNull PackType type, @NotNull String namespace, @NotNull String id, @NotNull PackResources.ResourceOutput output) {
        if (this.type == type && this.namespaces.contains(namespace)) {
            this.resources.entrySet().stream().filter(resource -> ((ResourceLocation)resource.getKey()).m_135827_().equals(namespace) && ((ResourceLocation)resource.getKey()).m_135815_().startsWith(id)).forEach(resource -> output.accept((Object)((ResourceLocation)resource.getKey()), () -> new ByteArrayInputStream((byte[])((Supplier)resource.getValue()).get())));
        }
    }

    @NotNull
    public Set<String> m_5698_(@NotNull PackType packType) {
        return this.namespaces;
    }

    public <T> T m_5550_(MetadataSectionSerializer<T> serializer) {
        return (T)(serializer.m_7991_().equals(PackMetadataSection.f_243696_.m_7991_()) ? this.metadata : null);
    }

    @NotNull
    public String m_5542_() {
        return this.name.toString();
    }

    public void close() {
    }

    private void build(ResourceLocation path, Supplier<byte[]> bytes) {
        this.namespaces.add(path.m_135827_());
        this.resources.put(path, (Supplier<byte[]>)Suppliers.memoize(bytes::get));
    }

    protected void build(List<ResourceLocation> paths, Supplier<JsonElement> json) {
        for (ResourceLocation path : paths) {
            JsonElement element = json.get();
            this.build(DynamicResourceType.GENERAL.getPath(path), () -> {
                try (StringWriter stringWriter = new StringWriter();){
                    byte[] byArray;
                    try (JsonWriter jsonWriter = new JsonWriter((Writer)stringWriter);){
                        jsonWriter.setIndent("  ");
                        Streams.write((JsonElement)element, (JsonWriter)jsonWriter);
                        jsonWriter.close();
                        byArray = stringWriter.toString().getBytes();
                    }
                    return byArray;
                }
                catch (IOException e) {
                    Constants.LOGGER.error("Failed to write JSON {} to resource pack\n{}.", new Object[]{path, this.name, e});
                    return new byte[0];
                }
            });
        }
    }

    protected abstract void build();

    public static class DynamicResourcesSupplier
    implements Pack.ResourcesSupplier {
        private final PackResources instance;

        DynamicResourcesSupplier(PackResources instance) {
            this.instance = instance;
        }

        @NotNull
        public PackResources m_247679_(@NotNull String name) {
            return this.instance;
        }
    }
}

