/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.chunkloaders.packet;

import com.supermartijn642.chunkloaders.capability.ChunkLoadingCapability;
import com.supermartijn642.chunkloaders.capability.ServerChunkLoadingCapability;
import com.supermartijn642.core.network.BasePacket;
import com.supermartijn642.core.network.PacketContext;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;

public class PacketToggleChunk
implements BasePacket {
    private UUID owner;
    private ChunkPos pos;

    public PacketToggleChunk(UUID owner, ChunkPos pos) {
        this.owner = owner;
        this.pos = pos;
    }

    public PacketToggleChunk() {
    }

    public void write(FriendlyByteBuf buffer) {
        buffer.m_130077_(this.owner);
        buffer.writeLong(this.pos.m_45588_());
    }

    public void read(FriendlyByteBuf buffer) {
        this.owner = buffer.m_130259_();
        this.pos = new ChunkPos(buffer.readLong());
    }

    public void handle(PacketContext context) {
        Player player = context.getSendingPlayer();
        if (!this.owner.equals(player.m_20148_()) && !player.m_20194_().m_6846_().m_11303_(player.m_36316_())) {
            return;
        }
        ServerChunkLoadingCapability capability = ChunkLoadingCapability.get(player.m_20193_()).castServer();
        if (capability.isChunkLoadedByPlayer(this.owner, this.pos)) {
            capability.stopLoadingChunk(this.owner, this.pos);
        } else if (capability.canPlayerLoadChunk(this.owner, this.pos)) {
            capability.startLoadingChunk(this.owner, this.pos);
        }
    }
}

