/*
 * Decompiled with CFR 0.152.
 */
package com.corgam.cagedmobs.serializers;

import com.corgam.cagedmobs.CagedMobs;
import com.corgam.cagedmobs.registers.CagedRecipeTypes;
import com.corgam.cagedmobs.serializers.entity.AdditionalLootData;
import com.corgam.cagedmobs.serializers.entity.EntityData;
import com.corgam.cagedmobs.serializers.environment.EnvironmentData;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import net.minecraftforge.fml.util.thread.EffectiveSide;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.server.ServerLifecycleHooks;

public class RecipesHelper {
    public static Map<ResourceLocation, Recipe<?>> getRecipes(RecipeType<?> recipeType, RecipeManager manager) {
        Map recipesMap = (Map)ObfuscationReflectionHelper.getPrivateValue(RecipeManager.class, (Object)manager, (String)"f_44007_");
        return (Map)recipesMap.get(recipeType);
    }

    public static List<EntityData> getEntitiesRecipesList(RecipeManager manager) {
        if (manager != null) {
            return manager.m_44013_((RecipeType)CagedRecipeTypes.ENTITY_RECIPE.get());
        }
        return Collections.emptyList();
    }

    public static List<EnvironmentData> getEnvsRecipesList(RecipeManager manager) {
        if (manager != null) {
            return manager.m_44013_((RecipeType)CagedRecipeTypes.ENVIRONMENT_RECIPE.get());
        }
        return Collections.emptyList();
    }

    public static List<AdditionalLootData> getAdditionalLootRecipesList(RecipeManager manager) {
        if (manager != null) {
            return manager.m_44013_((RecipeType)CagedRecipeTypes.ADDITIONAL_LOOT_RECIPE.get());
        }
        return Collections.emptyList();
    }

    public static RecipeManager getRecipeManager() {
        try {
            if (EffectiveSide.get().isClient()) {
                return RecipesHelper.getRecipeManagerClient();
            }
            return RecipesHelper.getRecipeManagerServer();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static RecipeManager getRecipeManagerClient() {
        if (Minecraft.m_91087_().f_91074_ != null) {
            return Minecraft.m_91087_().f_91074_.f_108617_.m_105141_();
        }
        return null;
    }

    private static RecipeManager getRecipeManagerServer() {
        return ServerLifecycleHooks.getCurrentServer().m_129894_();
    }

    public static boolean isEnvValidForEntity(EntityData entity, EnvironmentData env) {
        for (String s : entity.getValidEnvs()) {
            for (String s2 : env.getEnvironments()) {
                if (!s.matches(s2)) continue;
                return true;
            }
        }
        return false;
    }

    public static List<EntityType<?>> getEntityTypesFromConfigList() {
        ArrayList blacklisted = new ArrayList(Collections.emptyList());
        List<? extends String> blacklistedEntities = CagedMobs.SERVER_CONFIG.getEntitiesList();
        for (String string : blacklistedEntities) {
            Optional entityType = EntityType.m_20632_((String)string);
            entityType.ifPresent(blacklisted::add);
        }
        return blacklisted;
    }

    public static boolean isEntityTypeBlacklisted(EntityType<?> type) {
        List<EntityType<?>> list = RecipesHelper.getEntityTypesFromConfigList();
        if (CagedMobs.SERVER_CONFIG.isEntitiesListInWhitelistMode()) {
            return !list.contains(type);
        }
        return list.contains(type);
    }

    public static List<Item> getItemsFromConfigList() {
        ArrayList<Item> blacklisted = new ArrayList<Item>(Collections.emptyList());
        List<? extends String> blacklistedItems = CagedMobs.SERVER_CONFIG.getItemsList();
        for (String string : blacklistedItems) {
            Item i = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(string));
            if (i == Items.f_41852_ && i == null) continue;
            blacklisted.add(i);
        }
        return blacklisted;
    }
}

