/*
 * Decompiled with CFR 0.152.
 */
package com.corgam.cagedmobs.configs;

import java.util.Collections;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;

public class ServerConfig {
    private final ForgeConfigSpec spec;
    private final ForgeConfigSpec.BooleanValue hoppingCagesDisabled;
    private final ForgeConfigSpec.BooleanValue entitiesListInWhitelistMode;
    private final ForgeConfigSpec.ConfigValue<List<? extends String>> entitiesList;
    private final ForgeConfigSpec.BooleanValue itemsListInWhitelistMode;
    private final ForgeConfigSpec.ConfigValue<List<? extends String>> itemsList;
    private final ForgeConfigSpec.BooleanValue singleUseSamplers;
    private final ForgeConfigSpec.BooleanValue disableSamplers;
    private final ForgeConfigSpec.BooleanValue disableSpawnEggs;
    private final ForgeConfigSpec.DoubleValue cagesSpeed;

    public ServerConfig() {
        ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
        builder.comment("Server side config for CagedMobs. If changed it will affect the whole server!");
        builder.push("server");
        builder.comment("Disables Hopping Cages' automatic harvest, making them work the same as the non-hopping variant.");
        this.hoppingCagesDisabled = builder.define("hoppingCagesDisabled", false);
        builder.comment("Makes all samplers (all tiers) only single use. After a mob is sampled and put into the cage the sampler will break.");
        this.singleUseSamplers = builder.define("singleUseSamplers", false);
        builder.comment("Disables all samplers, requiring the player to use only the spawn eggs.");
        this.disableSamplers = builder.define("disableSamplers", false);
        builder.comment("Disables the ability to use spawn eggs on mob cages, requiring the player to use only the samplers.");
        this.disableSpawnEggs = builder.define("disableSpawnEggs", false);
        builder.comment("Sets the speed of all cages. The bigger the value the faster the cages will work (by default: 1.00).");
        this.cagesSpeed = builder.defineInRange("cagesSpeed", 1.0, 0.01, 100.0);
        builder.comment("List of all entities blacklisted from use (in a modid:name format). Players will not be able to put entities from this list into cages nor sample them.\nTo switch this list into a whitelist, set the 'entitiesListInWhitelistMode' value to true. \nExample use: when 'entitiesList' contains [\"minecraft:pig\", \"minecraft:cow\",\"minecraft:rabbit\"] vanilla pig, cow and rabbit will be blacklisted.");
        this.entitiesList = builder.defineList("entitiesList", Collections.emptyList(), it -> it instanceof String);
        builder.comment("Changes the entities list into a whitelist (only entities inside 'entitiesList' will be available). \nExample use: when 'entitiesListInWhitelistMode' value is set to true and 'entitiesList' contains [\"minecraft:pig\", \"minecraft:chicken\"] all entities will be blacklisted except vanilla pig and chicken.");
        this.entitiesListInWhitelistMode = builder.define("entitiesListInWhitelistMode", false);
        builder.comment("List of all items blacklisted from use (in a modid:name format).\nItems in this list will not be able to be produced from cages, even if they are present in one or more recipes.\nTo switch this list into a whitelist, set the 'itemsListInWhitelistMode' value to true. \nExample use: when 'itemsList' contains [\"minecraft:iron_ingot\", \"minecraft:gold_ingot\", \"minecraft:wither_rose\"] iron ingot, gold ingot and wither rose will not drop from any cage recipe.");
        this.itemsList = builder.defineList("itemsList", Collections.emptyList(), it -> it instanceof String);
        builder.comment("Changes the items list into a whitelist (only items inside 'itemsList' can drop from caged mobs). \nExample use: when 'itemsListInWhitelistMode' value is set to true and 'itemsList' contains [\"minecraft:iron_ingot\"] only iron ingots could be obtained from caged entities.");
        this.itemsListInWhitelistMode = builder.define("itemsListInWhitelistMode", false);
        builder.pop();
        this.spec = builder.build();
    }

    public ForgeConfigSpec getForgeConfigSpec() {
        return this.spec;
    }

    public boolean ifHoppingCagesDisabled() {
        return (Boolean)this.hoppingCagesDisabled.get();
    }

    public boolean isEntitiesListInWhitelistMode() {
        return (Boolean)this.entitiesListInWhitelistMode.get();
    }

    public List<? extends String> getEntitiesList() {
        return (List)this.entitiesList.get();
    }

    public boolean isItemsListInWhitelistMode() {
        return (Boolean)this.itemsListInWhitelistMode.get();
    }

    public List<? extends String> getItemsList() {
        return (List)this.itemsList.get();
    }

    public boolean areSamplersSingleUse() {
        return (Boolean)this.singleUseSamplers.get();
    }

    public boolean areSamplersDisabled() {
        return (Boolean)this.disableSamplers.get();
    }

    public boolean areSpawnEggsDisabled() {
        return (Boolean)this.disableSpawnEggs.get();
    }

    public Double getSpeedOfCages() {
        return (Double)this.cagesSpeed.get();
    }
}

