/*
 * Decompiled with CFR 0.152.
 */
package com.corgam.cagedmobs.configs;

import net.minecraftforge.common.ForgeConfigSpec;

public class ClientConfig {
    private final ForgeConfigSpec spec;
    private final ForgeConfigSpec.BooleanValue disableEnvsRender;
    private final ForgeConfigSpec.BooleanValue disableEntitiesRender;
    private final ForgeConfigSpec.BooleanValue disableGrowthRender;
    private final ForgeConfigSpec.BooleanValue disableUpgradesParticles;

    public ClientConfig() {
        ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
        builder.comment("Client side config for CagedMobs. Do not change when shipping in ModPacks!");
        builder.push("client");
        builder.comment("Disables environments rendering inside cages to save on performance.");
        this.disableEnvsRender = builder.define("disableEnvsRender", false);
        builder.comment("Disables entities models rendering inside cages to save on performance.");
        this.disableEntitiesRender = builder.define("disableEntitiesRender", false);
        builder.comment("Disables entities growth progress rendering inside cages and keeps the size of the entity inside the cage always the same.");
        this.disableGrowthRender = builder.define("disableGrowthRender", false);
        builder.comment("Disables particles emitted by the cage upgrades");
        this.disableUpgradesParticles = builder.define("disableUpgradesParticles", false);
        builder.pop();
        this.spec = builder.build();
    }

    public ForgeConfigSpec getForgeConfigSpec() {
        return this.spec;
    }

    public boolean shouldEnvsRender() {
        return (Boolean)this.disableEnvsRender.get() == false;
    }

    public boolean shouldEntitiesRender() {
        return (Boolean)this.disableEntitiesRender.get() == false;
    }

    public boolean shouldGrowthRender() {
        return (Boolean)this.disableGrowthRender.get() == false;
    }

    public boolean shouldUpgradesParticles() {
        return (Boolean)this.disableUpgradesParticles.get() == false;
    }
}

