/*
 * Decompiled with CFR 0.152.
 */
package com.corgam.cagedmobs.addons.jade;

import com.corgam.cagedmobs.blocks.mob_cage.MobCageBlockEntity;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.api.ui.IBoxStyle;
import snownee.jade.api.ui.IElement;
import snownee.jade.api.ui.IElementHelper;

public class CagedMobsComponentProvider
implements IBlockComponentProvider {
    public void appendTooltip(ITooltip tooltip, BlockAccessor blockAccessor, IPluginConfig pluginConfig) {
        EntityType<?> representation;
        BlockEntity blockEntity = blockAccessor.getBlockEntity();
        if (!(blockEntity instanceof MobCageBlockEntity)) {
            return;
        }
        MobCageBlockEntity tile = (MobCageBlockEntity)blockEntity;
        IElementHelper helper = tooltip.getElementHelper();
        if (tile.hasEntity() && tile.hasEnvironment()) {
            tooltip.add(helper.progress(tile.getGrowthPercentage(), (Component)Component.m_237113_((String)String.format("%3.0f%%", Float.valueOf(tile.getGrowthPercentage() * 100.0f))), helper.progressStyle().color(-12277180, -12277180), (IBoxStyle)IBoxStyle.Empty.INSTANCE, true));
        }
        if (tile.hasEnvironment() && (representation = tile.getEnvironmentItemStack()) != null) {
            tooltip.add((Component)Component.m_237115_((String)"JADE.tooltip.cagedmobs.cage.environment"));
            tooltip.add(List.of(helper.item(representation, 1.0f), helper.text(representation.m_41786_())));
        }
        if (tile.hasEntity() && (representation = tile.getEntityType()) != null) {
            tooltip.add((Component)Component.m_237113_((String)(Component.m_237115_((String)"JADE.tooltip.cagedmobs.cage.entity").m_130940_(ChatFormatting.GRAY).getString() + Component.m_237115_((String)representation.m_20675_()).m_130940_(ChatFormatting.GRAY).getString())));
        }
        if (tile.hasAnyUpgrades()) {
            tooltip.add((Component)Component.m_237115_((String)"TOP.tooltip.cagedmobs.cage.upgrades"));
            ArrayList<IElement> upgrades = new ArrayList<IElement>();
            for (ItemStack upgrade : tile.getUpgradesAsItemStacks()) {
                if (upgrade.m_41619_()) continue;
                upgrades.add(helper.item(upgrade));
            }
            tooltip.add(upgrades);
        }
    }

    public ResourceLocation getUid() {
        return new ResourceLocation("cagedmobs", "cagedmobs_jade");
    }
}

