/*
 * Decompiled with CFR 0.152.
 */
package com.corgam.cagedmobs.addons.crafttweaker;

import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.action.base.IAction;
import com.blamejared.crafttweaker.api.action.recipe.ActionAddRecipe;
import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import com.blamejared.crafttweaker.api.recipe.manager.base.IRecipeManager;
import com.corgam.cagedmobs.addons.crafttweaker.CTEntity;
import com.corgam.cagedmobs.registers.CagedRecipeSerializers;
import com.corgam.cagedmobs.registers.CagedRecipeTypes;
import com.corgam.cagedmobs.serializers.entity.EntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraftforge.registries.ForgeRegistries;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@ZenCodeType.Name(value="mods.cagedmobs.EntitiesManager")
public class EntitiesManager
implements IRecipeManager<EntityData> {
    @ZenCodeType.Method
    public CTEntity create(String id, String entityId, int growTicks, boolean requiresWater, int tier, String environment) {
        return this.create(id, entityId, growTicks, requiresWater, tier, new String[]{environment});
    }

    @ZenCodeType.Method
    public CTEntity create(String id, String entityId, int growTicks, boolean requiresWater, int tier, String[] environments) {
        EntityType entityType = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(ResourceLocation.m_135820_((String)entityId));
        CTEntity entity = new CTEntity(id, entityType, growTicks, requiresWater, tier, environments);
        CraftTweakerAPI.apply((IAction)new ActionAddRecipe((IRecipeManager)this, (Recipe)entity.getEntityData(), ""));
        return entity;
    }

    @ZenCodeType.Method
    public CTEntity getEntity(String id) {
        EntityData recipe;
        ResourceLocation resource = ResourceLocation.m_135820_((String)id);
        if (resource != null && (recipe = (EntityData)this.getRecipes().get(resource)) != null) {
            return new CTEntity(recipe);
        }
        throw new IllegalStateException("CagedMobs: Invalid CraftTweaker Entity recipe ID: " + id);
    }

    public ResourceLocation getBracketResourceLocation() {
        return CagedRecipeSerializers.ENTITY_RECIPE_SERIALIZER.getId();
    }

    public RecipeType<EntityData> getRecipeType() {
        return (RecipeType)CagedRecipeTypes.ENTITY_RECIPE.get();
    }
}

