/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.blueprint.common.remolder;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.teamabnormals.blueprint.common.remolder.RemolderEntry;
import com.teamabnormals.blueprint.common.remolder.Remolding;
import com.teamabnormals.blueprint.common.remolder.RemoldingCompiler;
import com.teamabnormals.blueprint.common.remolder.data.MoldingTypes;
import com.teamabnormals.blueprint.core.Blueprint;
import com.teamabnormals.blueprint.core.util.DataUtil;
import com.teamabnormals.blueprint.core.util.modification.selection.ResourceSelector;
import com.teamabnormals.blueprint.core.util.modification.selection.selectors.EmptyResourceSelector;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.resources.FileToIdConverter;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.CloseableResourceManager;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.GsonHelper;

public final class RemoldedResourceManager
implements CloseableResourceManager {
    private static final Gson GSON = new Gson();
    @Nullable
    private static RemoldedResourceManager CLIENT;
    @Nullable
    private static RemoldedResourceManager SERVER;
    private final HashMap<String, IdentityHashMap<MoldingTypes.MoldingType<?>, Pair<Map<String, List<Entry>>, ArrayList<Pair<Predicate<ResourceLocation>, Entry>>>>> fileExtensionToEntries = new HashMap();
    private final CloseableResourceManager manager;
    private final RemoldingCompiler compiler;
    private final PackType packType;
    private final boolean needsAutoReload;

    private RemoldedResourceManager(CloseableResourceManager manager, PackType packType, boolean needsAutoReload) {
        RemoldingCompiler.ExportEntry[] exports;
        this.manager = manager;
        this.packType = packType;
        try (BufferedReader reader = manager.m_215593_(new ResourceLocation("blueprint", "remolder.json")).m_215508_();){
            JsonElement element = (JsonElement)GsonHelper.m_13776_((Gson)GSON, (Reader)reader, JsonElement.class);
            DataResult dataResult = Settings.CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)element);
            Optional dataResultError = dataResult.error();
            if (dataResultError.isPresent()) {
                throw new JsonParseException(((DataResult.PartialResult)dataResultError.get()).message());
            }
            exports = ((Settings)((Pair)dataResult.result().get()).getFirst()).exports;
        }
        catch (JsonParseException | IOException exception) {
            Blueprint.LOGGER.error("Error loading " + packType.m_10305_() + " Remolder settings, using default settings instead!", exception);
            exports = new RemoldingCompiler.ExportEntry[]{};
        }
        this.compiler = new RemoldingCompiler(this.getClass().getClassLoader(), exports);
        this.needsAutoReload = needsAutoReload;
    }

    public static RemoldedResourceManager wrapForClient(CloseableResourceManager manager) {
        CLIENT = new RemoldedResourceManager(manager, PackType.CLIENT_RESOURCES, true);
        return CLIENT;
    }

    public static RemoldedResourceManager wrapForServer(CloseableResourceManager manager, boolean shouldAutoReload) {
        SERVER = new RemoldedResourceManager(manager, PackType.SERVER_DATA, shouldAutoReload);
        return SERVER;
    }

    @Nullable
    public static RemoldedResourceManager client() {
        return CLIENT;
    }

    @Nullable
    public static RemoldedResourceManager server() {
        return SERVER;
    }

    public boolean needsAutoReload() {
        return this.needsAutoReload;
    }

    public void reloadRemolders(Executor executor) {
        HashMap<String, IdentityHashMap<MoldingTypes.MoldingType<?>, Pair<Map<String, List<Entry>>, ArrayList<Pair<Predicate<ResourceLocation>, Entry>>>>> fileExtensionToEntries = this.fileExtensionToEntries;
        fileExtensionToEntries.clear();
        FileToIdConverter fileToIdConverter = FileToIdConverter.m_246568_((String)"remolders");
        Map resources = fileToIdConverter.m_247457_((ResourceManager)this.manager);
        ArrayList<CompletableFuture<Void>> futures = new ArrayList<CompletableFuture<Void>>(resources.size());
        String packTypeDirectory = this.packType.m_10305_() + "/";
        AtomicInteger successfulCount = new AtomicInteger();
        for (Map.Entry entry : resources.entrySet()) {
            futures.add(CompletableFuture.runAsync(() -> {
                ResourceLocation entryKey = (ResourceLocation)entry.getKey();
                ResourceLocation entryId = fileToIdConverter.m_245273_(entryKey);
                entryKey = new ResourceLocation(entryKey.m_135827_(), packTypeDirectory + entryKey.m_135815_());
                try (BufferedReader reader = ((Resource)entry.getValue()).m_215508_();){
                    Remolding<?> remolding;
                    JsonElement element = (JsonElement)GsonHelper.m_13776_((Gson)GSON, (Reader)reader, JsonElement.class);
                    DataResult remolderEntryDataResult = RemolderEntry.CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)element);
                    Optional remolderEntryError = remolderEntryDataResult.error();
                    if (remolderEntryError.isPresent()) {
                        throw new JsonParseException(((DataResult.PartialResult)remolderEntryError.get()).message());
                    }
                    RemolderEntry remolderEntry = (RemolderEntry)((Pair)remolderEntryDataResult.result().get()).getFirst();
                    if (remolderEntry == RemolderEntry.NOOP) {
                        return;
                    }
                    ResourceSelector<?> pathSelector = remolderEntry.pathSelector().getResourceSelector();
                    if (pathSelector == EmptyResourceSelector.INSTANCE) {
                        return;
                    }
                    MoldingTypes.MoldingType<?> moldingType = remolderEntry.molding();
                    try {
                        remolding = this.compiler.compile(entryKey.toString(), moldingType.molding(), remolderEntry.remolder().remold());
                    }
                    catch (Throwable throwable) {
                        throw new JsonParseException("Error while generating modifications for Remolder '" + entryKey + "': " + throwable);
                    }
                    RemoldedResourceManager remoldedResourceManager = this;
                    synchronized (remoldedResourceManager) {
                        for (String fileExtension : moldingType.fileExtensions()) {
                            Pair entries = fileExtensionToEntries.computeIfAbsent(fileExtension, __ -> new IdentityHashMap()).computeIfAbsent(moldingType, __ -> Pair.of(new HashMap(), new ArrayList()));
                            Either<Set<ResourceLocation>, Predicate<ResourceLocation>> either = pathSelector.select();
                            Optional locations = either.left();
                            Set<String> packs = remolderEntry.packs();
                            if (locations.isPresent()) {
                                Map directRemoldings = (Map)entries.getFirst();
                                Entry remoldingEntry = new Entry(packs == null ? s -> true : packs::contains, remolding);
                                ((Set)locations.get()).forEach(location -> directRemoldings.computeIfAbsent(location.toString(), __ -> new ArrayList()).add(remoldingEntry));
                                continue;
                            }
                            ((ArrayList)entries.getSecond()).add(Pair.of((Object)((Predicate)either.right().get()), (Object)new Entry(packs == null ? s -> true : packs::contains, remolding)));
                        }
                    }
                    successfulCount.getAndIncrement();
                }
                catch (JsonParseException | IOException | IllegalArgumentException exception) {
                    Blueprint.LOGGER.error("Couldn't load remolder file {} from {}", (Object)entryId, (Object)entryKey, (Object)exception);
                }
            }, executor));
        }
        CompletableFuture.allOf((CompletableFuture[])futures.toArray(CompletableFuture[]::new)).join();
        Blueprint.LOGGER.info("Successfully loaded {} {} remolders!", (Object)successfulCount.get(), (Object)this.packType.m_10305_());
    }

    @Nullable
    private Function<Resource, Resource> getResourceFunction(ResourceLocation location) {
        String extension;
        IdentityHashMap<MoldingTypes.MoldingType<?>, Pair<Map<String, List<Entry>>, ArrayList<Pair<Predicate<ResourceLocation>, Entry>>>> entriesForExtension;
        String locationString = location.toString();
        int lastIndexOfDot = locationString.lastIndexOf(46);
        if (lastIndexOfDot >= 0 && (entriesForExtension = this.fileExtensionToEntries.get(extension = locationString.substring(lastIndexOfDot + 1))) != null) {
            String locationWithoutExtension = locationString.substring(0, lastIndexOfDot);
            ResourceLocation resourceLocationWithoutExtension = new ResourceLocation(locationWithoutExtension);
            boolean foundNone = true;
            Pair[] typeEntries = new Pair[entriesForExtension.size()];
            int i = 0;
            for (Map.Entry<MoldingTypes.MoldingType<?>, Pair<Map<String, List<Entry>>, ArrayList<Pair<Predicate<ResourceLocation>, Entry>>>> entry : entriesForExtension.entrySet()) {
                Pair<Map<String, List<Entry>>, ArrayList<Pair<Predicate<ResourceLocation>, Entry>>> value = entry.getValue();
                ArrayList indirectRemolders = (ArrayList)value.getSecond();
                ArrayList<Entry> entriesForLocation = (ArrayList<Entry>)((Map)value.getFirst()).get(locationWithoutExtension);
                if (!indirectRemolders.isEmpty()) {
                    entriesForLocation = entriesForLocation == null ? new ArrayList<Entry>() : new ArrayList(entriesForLocation);
                    for (Pair filterAndRemolding : indirectRemolders) {
                        if (!((Predicate)filterAndRemolding.getFirst()).test(resourceLocationWithoutExtension)) continue;
                        entriesForLocation.add((Entry)filterAndRemolding.getSecond());
                    }
                    if (entriesForLocation.isEmpty()) {
                        continue;
                    }
                } else if (entriesForLocation == null) continue;
                foundNone = false;
                typeEntries[i++] = Pair.of(entry.getKey(), entriesForLocation);
            }
            if (foundNone) {
                return null;
            }
            int finalI = i;
            return resource -> {
                for (int j = 0; j < finalI; ++j) {
                    Pair moldingTypeWithEntries = typeEntries[j];
                    resource = ((MoldingTypes.MoldingType)moldingTypeWithEntries.getFirst()).remold(locationWithoutExtension, (Resource)resource, (List)moldingTypeWithEntries.getSecond());
                }
                return resource;
            };
        }
        return null;
    }

    public Set<String> m_7187_() {
        return this.manager.m_7187_();
    }

    public List<Resource> m_213829_(ResourceLocation location) {
        Function<Resource, Resource> resourceFunction = this.getResourceFunction(location);
        if (resourceFunction == null) {
            return this.manager.m_213829_(location);
        }
        return new DataUtil.ReadMappedList<Resource>(this.manager.m_213829_(location), resourceFunction);
    }

    public Map<ResourceLocation, Resource> m_214159_(String path, Predicate<ResourceLocation> locationFilter) {
        Map map = this.manager.m_214159_(path, locationFilter);
        for (Map.Entry entry : map.entrySet()) {
            Function<Resource, Resource> resourceFunction = this.getResourceFunction((ResourceLocation)entry.getKey());
            if (resourceFunction == null) continue;
            entry.setValue(resourceFunction.apply((Resource)entry.getValue()));
        }
        return map;
    }

    public Map<ResourceLocation, List<Resource>> m_214160_(String path, Predicate<ResourceLocation> locationFilter) {
        Map map = this.manager.m_214160_(path, locationFilter);
        for (Map.Entry entry : map.entrySet()) {
            Function<Resource, Resource> resourceFunction = this.getResourceFunction((ResourceLocation)entry.getKey());
            if (resourceFunction == null) continue;
            entry.setValue(new DataUtil.ReadMappedList<Resource>((List)entry.getValue(), resourceFunction));
        }
        return map;
    }

    public Stream<PackResources> m_7536_() {
        return this.manager.m_7536_();
    }

    public Optional<Resource> m_213713_(ResourceLocation location) {
        Function<Resource, Resource> function = this.getResourceFunction(location);
        if (function == null) {
            return this.manager.m_213713_(location);
        }
        return this.manager.m_213713_(location).map(function);
    }

    public void close() {
        this.manager.close();
    }

    public record Settings(RemoldingCompiler.ExportEntry[] exports) {
        private static final Codec<RemoldingCompiler.ExportEntry[]> EXPORTS_CODEC = Codec.unboundedMap((Codec)Codec.STRING, (Codec)Codec.STRING).xmap(map -> {
            Set entries = map.entrySet();
            if (entries.isEmpty()) {
                return new RemoldingCompiler.ExportEntry[0];
            }
            RemoldingCompiler.ExportEntry[] exports = new RemoldingCompiler.ExportEntry[entries.size()];
            int exportsCount = 0;
            for (Map.Entry entry : entries) {
                Pattern pattern = Pattern.compile(String.valueOf(entry.getValue()));
                exports[exportsCount++] = new RemoldingCompiler.ExportEntry((String)entry.getKey(), pattern.pattern(), string -> pattern.matcher((CharSequence)string).matches());
            }
            return exports;
        }, array -> Stream.of(array).collect(Collectors.toMap(RemoldingCompiler.ExportEntry::folder, RemoldingCompiler.ExportEntry::pattern)));
        public static final Codec<Settings> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)EXPORTS_CODEC.fieldOf("exports").forGetter(Settings::exports)).apply((Applicative)instance, Settings::new));
    }

    public record Entry(Predicate<String> packFilter, Remolding<?> remolding) {
    }
}

