/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.blueprint.client.screen.shaking;

import com.teamabnormals.blueprint.client.screen.shaking.ShakeSource;
import com.teamabnormals.blueprint.core.BlueprintConfig;
import com.teamabnormals.blueprint.core.mixin.client.CameraInvokerMixin;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.client.event.ViewportEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="blueprint", value={Dist.CLIENT})
public enum ScreenShakeHandler {
    INSTANCE;

    private static final Random RANDOM;
    private final List<ShakeSource> sources = new LinkedList<ShakeSource>();
    private double prevIntensityX;
    private double prevIntensityY;
    private double prevIntensityZ;
    private double intensityX;
    private double intensityY;
    private double intensityZ;

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            INSTANCE.tick();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void onCameraSetup(ViewportEvent.ComputeCameraAngles event) {
        INSTANCE.shakeCamera(event);
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void onPlayerLoggedOut(ClientPlayerNetworkEvent.LoggingOut event) {
        INSTANCE.clear();
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void onWorldUnload(LevelEvent.Unload event) {
        INSTANCE.clear();
    }

    private static double randomizeIntensity(double intensity) {
        double randomDouble = RANDOM.nextDouble();
        return (1.0 - randomDouble * randomDouble) * ((double)RANDOM.nextInt(2) - 0.5) * intensity * 2.0;
    }

    public boolean addShakeSource(ShakeSource source) {
        List<ShakeSource> sources = this.sources;
        if (sources.size() >= BlueprintConfig.CLIENT.maxScreenShakers) {
            return false;
        }
        sources.add(source);
        return true;
    }

    private void tick() {
        Minecraft minecraft = Minecraft.m_91087_();
        if (!minecraft.m_91104_()) {
            this.prevIntensityX = this.intensityX;
            this.prevIntensityY = this.intensityY;
            this.prevIntensityZ = this.intensityZ;
            List<ShakeSource> sources = this.sources;
            if (sources.isEmpty()) {
                this.intensityZ = 0.0;
                this.intensityY = 0.0;
                this.intensityX = 0.0;
            } else {
                Iterator<ShakeSource> sourceIterator = sources.iterator();
                Entity entity = minecraft.f_91075_;
                Vec3 pos = entity != null ? entity.m_20182_() : Vec3.f_82478_;
                double intensityX = 0.0;
                double intensityY = 0.0;
                double intensityZ = 0.0;
                while (sourceIterator.hasNext()) {
                    ShakeSource shakingSource = sourceIterator.next();
                    shakingSource.tick();
                    if (shakingSource.isStopped()) {
                        sourceIterator.remove();
                        continue;
                    }
                    Vec3 intensity = shakingSource.getIntensity(pos);
                    double newIntensityX = intensityX + intensity.f_82479_;
                    double maxX = shakingSource.getMaxBuildupX();
                    if (newIntensityX <= maxX) {
                        intensityX = newIntensityX;
                    } else if (maxX > intensityX) {
                        intensityX = maxX;
                    }
                    double newIntensityY = intensityY + intensity.f_82480_;
                    double maxY = shakingSource.getMaxBuildupY();
                    if (newIntensityY <= maxY) {
                        intensityY = newIntensityY;
                    } else if (maxY > intensityY) {
                        intensityY = maxY;
                    }
                    double newIntensityZ = intensityZ + intensity.f_82481_;
                    double maxZ = shakingSource.getMaxBuildupZ();
                    if (newIntensityZ <= maxZ) {
                        intensityZ = newIntensityZ;
                        continue;
                    }
                    if (!(maxZ > intensityZ)) continue;
                    intensityZ = maxZ;
                }
                this.intensityX = intensityX != 0.0 ? ScreenShakeHandler.randomizeIntensity(intensityX) : 0.0;
                this.intensityY = intensityY != 0.0 ? ScreenShakeHandler.randomizeIntensity(intensityY) : 0.0;
                this.intensityZ = intensityZ != 0.0 ? ScreenShakeHandler.randomizeIntensity(intensityZ) : 0.0;
            }
        }
    }

    private void shakeCamera(ViewportEvent.ComputeCameraAngles event) {
        double screenShakeScale = BlueprintConfig.CLIENT.screenShakeScale;
        if (screenShakeScale > 0.0) {
            double partialTicks = event.getPartialTick();
            double x = Mth.m_14139_((double)partialTicks, (double)this.prevIntensityX, (double)this.intensityX);
            double y = Mth.m_14139_((double)partialTicks, (double)this.prevIntensityY, (double)this.intensityY);
            double z = Mth.m_14139_((double)partialTicks, (double)this.prevIntensityZ, (double)this.intensityZ);
            if (x != 0.0 || y != 0.0 || z != 0.0) {
                ((CameraInvokerMixin)event.getCamera()).callMove(z * screenShakeScale, y * screenShakeScale, x * screenShakeScale);
            }
        }
    }

    private void clear() {
        this.sources.clear();
        this.intensityZ = 0.0;
        this.intensityY = 0.0;
        this.intensityX = 0.0;
        this.prevIntensityZ = 0.0;
        this.prevIntensityY = 0.0;
        this.prevIntensityX = 0.0;
    }

    static {
        RANDOM = new Random();
    }
}

