/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.adastra.common.items.armor;

import earth.terrarium.adastra.api.systems.OxygenApi;
import earth.terrarium.adastra.common.constants.ConstantComponents;
import earth.terrarium.adastra.common.items.armor.base.CustomDyeableArmorItem;
import earth.terrarium.adastra.common.registry.ModFluids;
import earth.terrarium.adastra.common.tags.ModFluidTags;
import earth.terrarium.adastra.common.tags.ModItemTags;
import earth.terrarium.adastra.common.utils.FluidUtils;
import earth.terrarium.adastra.common.utils.TooltipUtils;
import earth.terrarium.botarium.common.fluid.FluidConstants;
import earth.terrarium.botarium.common.fluid.base.BotariumFluidItem;
import earth.terrarium.botarium.common.fluid.base.FluidContainer;
import earth.terrarium.botarium.common.fluid.base.FluidHolder;
import earth.terrarium.botarium.common.fluid.base.ItemFluidContainer;
import earth.terrarium.botarium.common.fluid.impl.SimpleFluidContainer;
import earth.terrarium.botarium.common.fluid.impl.WrappedItemFluidContainer;
import earth.terrarium.botarium.common.fluid.utils.ClientFluidHooks;
import earth.terrarium.botarium.common.item.ItemStackHolder;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpaceSuitItem
extends CustomDyeableArmorItem
implements BotariumFluidItem<WrappedItemFluidContainer> {
    protected final long tankSize;

    public SpaceSuitItem(ArmorMaterial material, ArmorItem.Type type, long tankSize, Item.Properties properties) {
        super(material, type, properties);
        this.tankSize = tankSize;
    }

    public void m_7373_(@NotNull ItemStack stack, @Nullable Level level, List<Component> tooltipComponents, @NotNull TooltipFlag isAdvanced) {
        tooltipComponents.add(TooltipUtils.getFluidComponent(FluidUtils.getTank(stack), FluidConstants.fromMillibuckets((long)this.tankSize), (Fluid)ModFluids.OXYGEN.get()));
        TooltipUtils.addDescriptionComponent(tooltipComponents, ConstantComponents.SPACE_SUIT_INFO);
    }

    public WrappedItemFluidContainer getFluidContainer(ItemStack holder) {
        return new WrappedItemFluidContainer(holder, (FluidContainer)new SimpleFluidContainer(FluidConstants.fromMillibuckets((long)this.tankSize), 1, (t, f) -> f.is(ModFluidTags.OXYGEN)));
    }

    public static boolean hasFullSet(LivingEntity entity) {
        return SpaceSuitItem.hasFullSet(entity, ModItemTags.SPACE_SUITS);
    }

    public static boolean hasFullNetheriteSet(LivingEntity entity) {
        return SpaceSuitItem.hasFullSet(entity, ModItemTags.NETHERITE_SPACE_SUITS);
    }

    public static boolean hasFullJetSuitSet(LivingEntity entity) {
        return SpaceSuitItem.hasFullSet(entity, ModItemTags.JET_SUITS);
    }

    public static boolean hasFullSet(LivingEntity entity, TagKey<Item> spaceSuitTag) {
        for (ItemStack stack : entity.m_6168_()) {
            if (stack.m_204117_(spaceSuitTag)) continue;
            return false;
        }
        return true;
    }

    public void m_6883_(ItemStack stack, Level level, Entity entity, int slotId, boolean isSelected) {
        Player player;
        super.m_6883_(stack, level, entity, slotId, isSelected);
        if (level.m_5776_()) {
            return;
        }
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity livingEntity = (LivingEntity)entity;
        if (livingEntity instanceof Player && ((player = (Player)livingEntity).m_7500_() || player.m_5833_())) {
            return;
        }
        if (livingEntity.m_6844_(EquipmentSlot.CHEST) != stack) {
            return;
        }
        livingEntity.m_146917_(0);
        if (livingEntity.f_19797_ % 12 == 0 && SpaceSuitItem.hasOxygen(entity)) {
            if (!OxygenApi.API.hasOxygen(entity)) {
                this.consumeOxygen(stack, 1L);
            }
            if (entity.m_204029_(FluidTags.f_13131_)) {
                this.consumeOxygen(stack, 1L);
                livingEntity.m_20301_(Math.min(livingEntity.m_6062_(), livingEntity.m_20146_() + 40));
            }
        }
    }

    public void consumeOxygen(ItemStack stack, long amount) {
        ItemStackHolder holder = new ItemStackHolder(stack);
        ItemFluidContainer container = FluidContainer.of((ItemStackHolder)holder);
        if (container == null) {
            return;
        }
        FluidHolder extracted = container.extractFluid(container.getFirstFluid().copyWithAmount(FluidConstants.fromMillibuckets((long)amount)), false);
        if (holder.isDirty() || extracted.getFluidAmount() > 0L) {
            stack.m_41751_(holder.getStack().m_41783_());
        }
    }

    public static long getOxygenAmount(Entity entity) {
        if (!(entity instanceof LivingEntity)) {
            return 0L;
        }
        LivingEntity livingEntity = (LivingEntity)entity;
        ItemStack stack = livingEntity.m_6844_(EquipmentSlot.CHEST);
        Item item = stack.m_41720_();
        if (!(item instanceof SpaceSuitItem)) {
            return 0L;
        }
        SpaceSuitItem suit = (SpaceSuitItem)item;
        return suit.getFluidContainer(stack).getFirstFluid().getFluidAmount();
    }

    public static boolean hasOxygen(Entity entity) {
        return SpaceSuitItem.getOxygenAmount(entity) > FluidConstants.fromMillibuckets((long)1L);
    }

    public boolean m_142522_(@NotNull ItemStack stack) {
        return FluidUtils.hasFluid(stack);
    }

    public int m_142158_(@NotNull ItemStack stack) {
        WrappedItemFluidContainer fluidContainer = this.getFluidContainer(stack);
        return (int)((double)fluidContainer.getFirstFluid().getFluidAmount() / (double)fluidContainer.getTankCapacity(0) * 13.0);
    }

    public int m_142159_(@NotNull ItemStack stack) {
        return ClientFluidHooks.getFluidColor((FluidHolder)FluidUtils.getTank(stack));
    }
}

