/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.adastra.common.blockentities.pipes;

import earth.terrarium.adastra.common.blockentities.pipes.PipeBlockEntity;
import earth.terrarium.adastra.common.blocks.properties.PipeProperty;
import earth.terrarium.botarium.common.energy.EnergyApi;
import earth.terrarium.botarium.common.energy.base.EnergyContainer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class CableBlockEntity
extends PipeBlockEntity {
    public CableBlockEntity(BlockPos pos, BlockState state) {
        super(pos, state);
    }

    @Override
    public void addNode(@NotNull BlockEntity entity, PipeProperty pipeProperty, Direction direction, BlockPos pos) {
        if (pipeProperty.isNone()) {
            return;
        }
        EnergyContainer container = EnergyContainer.of((BlockEntity)entity, (Direction)direction);
        if (container == null) {
            return;
        }
        if (!pipeProperty.isInsert() && (pipeProperty.isExtract() || container.extractEnergy(container.getStoredEnergy(), true) > 0L)) {
            this.sources.put(pos, direction);
        } else if (pipeProperty.isNormal() || pipeProperty.isInsert()) {
            this.consumers.put(pos, direction);
        }
    }

    @Override
    public void moveContents(long transferRate, @NotNull BlockEntity source, @NotNull BlockEntity consumer, Direction direction) {
        EnergyContainer sourceContainer = EnergyContainer.of((BlockEntity)source, (Direction)direction);
        if (sourceContainer == null) {
            return;
        }
        EnergyContainer consumerContainer = EnergyContainer.of((BlockEntity)consumer, (Direction)direction.m_122424_());
        if (consumerContainer == null) {
            return;
        }
        EnergyApi.moveEnergy((EnergyContainer)sourceContainer, (EnergyContainer)consumerContainer, (long)Math.min(transferRate, sourceContainer.getStoredEnergy()), (boolean)false);
    }

    @Override
    public boolean isValid(@NotNull BlockEntity entity, Direction direction) {
        return EnergyContainer.holdsEnergy((BlockEntity)entity, (Direction)direction.m_122424_());
    }
}

