/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.adastra.common.blockentities.flag;

import com.mojang.authlib.GameProfile;
import dev.architectury.injectables.annotations.PlatformOnly;
import earth.terrarium.adastra.common.blockentities.flag.content.FlagContent;
import earth.terrarium.adastra.common.blockentities.flag.content.UrlContent;
import earth.terrarium.adastra.common.registry.ModBlockEntityTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.SkullBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FlagBlockEntity
extends BlockEntity {
    @Nullable
    private GameProfile owner;
    @Nullable
    private FlagContent content;

    public FlagBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntityTypes.FLAG.get(), pos, state);
    }

    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        if (this.owner != null) {
            CompoundTag compound = new CompoundTag();
            NbtUtils.m_129230_((CompoundTag)compound, (GameProfile)this.owner);
            tag.m_128365_("FlagOwner", (Tag)compound);
        }
        if (this.content != null) {
            tag.m_128365_("FlagContent", (Tag)this.content.toFullTag());
        }
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        if (tag.m_128425_("FlagOwner", 10)) {
            this.setOwner(NbtUtils.m_129228_((CompoundTag)tag.m_128469_("FlagOwner")));
        }
        if (tag.m_128425_("FlagUrl", 8)) {
            this.content = UrlContent.of("https://imgur.com/" + tag.m_128461_("FlagUrl"));
        }
        if (tag.m_128425_("FlagContent", 10)) {
            this.content = FlagContent.fromTag(tag.m_128469_("FlagContent"));
        }
    }

    @Nullable
    public GameProfile getOwner() {
        return this.owner;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOwner(GameProfile profile) {
        FlagBlockEntity flagBlockEntity = this;
        synchronized (flagBlockEntity) {
            this.owner = profile;
        }
        this.loadOwnerProperties();
    }

    private void loadOwnerProperties() {
        SkullBlockEntity.m_155738_((GameProfile)this.owner, owner -> {
            this.owner = owner;
            this.m_6596_();
        });
    }

    @Nullable
    public FlagContent getContent() {
        return this.content;
    }

    public void setContent(@Nullable FlagContent content) {
        this.content = content;
    }

    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    @NotNull
    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    @PlatformOnly(value={"forge"})
    public AABB getRenderBoundingBox() {
        return new AABB(this.m_58899_()).m_82400_(2.0);
    }
}

