/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.adastra.api.systems;

import java.util.Objects;

public final class PlanetData {
    private static final int OXYGEN_BIT_LENGTH = 1;
    private static final int TEMPERATURE_BIT_LENGTH = 16;
    private static final int GRAVITY_BIT_LENGTH = 15;
    private static final float GRAVITY_PRECISION = 100.0f;
    private static final int OXYGEN_BIT = 0;
    private static final int TEMPERATURE_BIT = 1;
    private static final int GRAVITY_BIT = 17;
    private boolean oxygen;
    private short temperature;
    private float gravity;

    public PlanetData(boolean oxygen, short temperature, float gravity) {
        this.oxygen = oxygen;
        this.temperature = temperature;
        this.gravity = gravity;
    }

    public boolean oxygen() {
        return this.oxygen;
    }

    public void setOxygen(boolean oxygen) {
        this.oxygen = oxygen;
    }

    public short temperature() {
        return this.temperature;
    }

    public void setTemperature(short temperature) {
        this.temperature = temperature;
    }

    public float gravity() {
        return this.gravity;
    }

    public void setGravity(float gravity) {
        this.gravity = gravity;
    }

    public int pack() {
        int packedData = 0;
        packedData |= (this.oxygen ? 1 : 0) << 0;
        packedData |= (this.temperature & 0xFFFF) << 1;
        return packedData |= (int)(this.gravity * 100.0f) << 17;
    }

    public static PlanetData unpack(int packedData) {
        boolean oxygen = (packedData >> 0 & 1) == 1;
        short temperature = (short)(packedData >> 1 & 0xFFFF);
        float gravity = (float)(packedData >> 17 & Short.MAX_VALUE) / 100.0f;
        return new PlanetData(oxygen, temperature, gravity);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        PlanetData that = (PlanetData)obj;
        return this.oxygen == that.oxygen && this.temperature == that.temperature && Float.floatToIntBits(this.gravity) == Float.floatToIntBits(that.gravity);
    }

    public int hashCode() {
        return Objects.hash(this.oxygen, this.temperature, Float.valueOf(this.gravity));
    }

    public String toString() {
        return "PlanetData[oxygen=" + this.oxygen + ", temperature=" + this.temperature + ", gravity=" + this.gravity + "]";
    }
}

