/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.yungsapi.world.structure.placement;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.yungnickyoung.minecraft.yungsapi.module.StructurePlacementTypeModule;
import com.yungnickyoung.minecraft.yungsapi.world.structure.exclusion.EnhancedExclusionZone;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.core.Vec3i;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.level.chunk.ChunkGeneratorStructureState;
import net.minecraft.world.level.levelgen.structure.placement.RandomSpreadStructurePlacement;
import net.minecraft.world.level.levelgen.structure.placement.RandomSpreadType;
import net.minecraft.world.level.levelgen.structure.placement.StructurePlacement;
import net.minecraft.world.level.levelgen.structure.placement.StructurePlacementType;

public class EnhancedRandomSpread
extends RandomSpreadStructurePlacement {
    public static final Codec<EnhancedRandomSpread> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)Vec3i.m_194650_((int)16).optionalFieldOf("locate_offset", (Object)Vec3i.f_123288_).forGetter(placement -> placement.m_227072_()), (App)StructurePlacement.FrequencyReductionMethod.f_227108_.optionalFieldOf("frequency_reduction_method", (Object)StructurePlacement.FrequencyReductionMethod.DEFAULT).forGetter(placement -> placement.m_227073_()), (App)Codec.floatRange((float)0.0f, (float)1.0f).optionalFieldOf("frequency", (Object)Float.valueOf(1.0f)).forGetter(placement -> Float.valueOf(placement.m_227074_())), (App)ExtraCodecs.f_144628_.fieldOf("salt").forGetter(placement -> placement.m_227075_()), (App)StructurePlacement.ExclusionZone.f_227077_.optionalFieldOf("exclusion_zone").forGetter(placement -> placement.m_227076_()), (App)EnhancedExclusionZone.CODEC.optionalFieldOf("enhanced_exclusion_zone").forGetter(placement -> placement.enhancedExclusionZone), (App)ExtraCodecs.f_144628_.fieldOf("spacing").forGetter(RandomSpreadStructurePlacement::m_205003_), (App)ExtraCodecs.f_144628_.fieldOf("separation").forGetter(RandomSpreadStructurePlacement::m_205004_), (App)RandomSpreadType.f_205014_.optionalFieldOf("spread_type", (Object)RandomSpreadType.LINEAR).forGetter(RandomSpreadStructurePlacement::m_205005_)).apply((Applicative)builder, builder.stable(EnhancedRandomSpread::new))).flatXmap(EnhancedRandomSpread.verifySpacing(), DataResult::success).codec();
    private final Optional<EnhancedExclusionZone> enhancedExclusionZone;

    private static Function<EnhancedRandomSpread, DataResult<EnhancedRandomSpread>> verifySpacing() {
        return placement -> placement.m_205003_() <= placement.m_205004_() ? DataResult.error(() -> "EnhancedRandomSpread's spacing has to be larger than separation") : DataResult.success((Object)placement);
    }

    public EnhancedRandomSpread(Vec3i locateOffset, StructurePlacement.FrequencyReductionMethod frequencyReductionMethod, Float frequency, Integer salt, Optional<StructurePlacement.ExclusionZone> exclusionZone, Optional<EnhancedExclusionZone> enhancedExclusionZone, Integer spacing, Integer separation, RandomSpreadType randomSpreadType) {
        super(locateOffset, frequencyReductionMethod, frequency.floatValue(), salt.intValue(), exclusionZone, spacing.intValue(), separation.intValue(), randomSpreadType);
        this.enhancedExclusionZone = enhancedExclusionZone;
    }

    public StructurePlacementType<?> m_203443_() {
        return StructurePlacementTypeModule.ENHANCED_RANDOM_SPREAD;
    }

    public boolean m_255071_(ChunkGeneratorStructureState chunkGeneratorStructureState, int x, int z) {
        if (!super.m_255071_(chunkGeneratorStructureState, x, z)) {
            return false;
        }
        return this.enhancedExclusionZone.isEmpty() || !this.enhancedExclusionZone.get().isPlacementForbidden(chunkGeneratorStructureState, x, z);
    }
}

